/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.criteria;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.svp.SignatureCertRefCheckResultConsumer;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.commons.CertificateReference;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.SignatureWithCertReferences;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import java.security.cert.Certificate;
import java.util.List;

public class CheckSigningCertificateReferences
extends AbstractValidationCriterion<SignatureWithCertReferences, SignatureCertRefCheckResultConsumer, SignatureValidationContext> {
    @Override
    public void verify(SignatureWithCertReferences signature, SignatureCertRefCheckResultConsumer result, SignatureValidationContext context) {
        X509CertificateImpl signingCertificate = signature.getSigningCertificate();
        CertificateReference sigCertRef = (CertificateReference)signature.getSigningCertificateReferences().get(0);
        ValidationResult res = null;
        res = sigCertRef.isReferenced((Certificate)signingCertificate) ? SVPFactory.createResultOk() : SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE);
        result.setSigCertRefCheck(res);
    }

    @Override
    public boolean isApplicable(SignatureWithCertReferences signature, SignatureCertRefCheckResultConsumer result, SignatureValidationContext context) {
        List signingCertificateReferences = signature.getSigningCertificateReferences();
        if (signingCertificateReferences == null || signingCertificateReferences.isEmpty()) {
            result.setSigCertRefCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.NOT_VALIDATED, (MinorResult)null));
            return false;
        }
        return true;
    }
}

