/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.criteria;

import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.InformationSource;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.validate.svp.PublicKeyCertificateValidationResult;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.csl.validation.ValidatePluginException;
import de.governikus.csl.validation.context.CertificateValidationContext;
import de.governikus.csl.validation.context.DocumentValidationContext;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.RecursiveValidationCriterion;
import de.governikus.csl.validation.x509.X509Data;
import de.governikus.csl.validation.x509.X509Plugin;
import java.security.cert.X509Certificate;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckSigningCertificate
extends RecursiveValidationCriterion<Signature, SignatureValidationResult, X509Data, PublicKeyCertificateValidationResult, CertificateValidationContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckSigningCertificate.class);

    @Override
    public void verify(Signature signature, SignatureValidationResult result, SignatureValidationContext context) {
        Map<X509Certificate, PublicKeyCertificateValidationResult> prefetchedCertificateValidationResults;
        X509CertificateImpl c = signature.getSigningCertificate();
        X509Certificate issuerCert = null;
        if (c != null) {
            issuerCert = (X509Certificate)c.getWrappedCertificate();
        }
        if (issuerCert == null) {
            return;
        }
        PublicKeyCertificateValidationResult chainResult = null;
        DocumentValidationContext documentValidationContext = context.getDocumentValidationContext();
        if (documentValidationContext != null && (prefetchedCertificateValidationResults = documentValidationContext.getPrefetchedCertificateValidationResults()) != null) {
            chainResult = prefetchedCertificateValidationResults.get(issuerCert);
        }
        if (chainResult == null) {
            X509Plugin plugin = (X509Plugin)context.getConfiguration().getPlugin(Plugin.PluginID.VALIDATE_X509.getID());
            X509Data wrapper = null;
            try {
                wrapper = plugin.parseAsSignature(issuerCert);
            }
            catch (ValidatePluginException e) {
                LOGGER.error("Verification of signature failed.", (Throwable)((Object)e));
                return;
            }
            InformationSource source = context.getCertificateSource();
            CertificateValidationContext contextCopy = new CertificateValidationContext(context.getPolicy());
            contextCopy.copyValuesFrom(context);
            contextCopy.setSignedObjectTypeContext(signature.getType());
            wrapper.setAttachedCertificates(signature.getAttachedCertificates());
            wrapper.setAttachedCRLs(signature.getAttachedCRLs());
            wrapper.setAttachedOCSPValues(signature.getAttachedOCSPValues());
            chainResult = this.recursiveCall(wrapper, plugin, contextCopy);
            chainResult.setInformationSource(source);
        }
        result.setSigningCertificateValidationResult(chainResult);
    }

    @Override
    public boolean isApplicable(Signature signature, SignatureValidationResult result, SignatureValidationContext context) {
        return !(signature instanceof X509Data);
    }
}

