/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.criteria;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.tsl.ExtendedTLInformation;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.TLType;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.csl.validate.svp.TypedDate;
import de.governikus.csl.validate.svp.ValidationMessageCode;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import de.governikus.csl.validation.x509.X509Data;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;

public class CheckClaimedSigningTime
extends AbstractValidationCriterion<Signature, SignatureValidationResult, SignatureValidationContext> {
    @Override
    public void verify(Signature signature, SignatureValidationResult result, SignatureValidationContext context) {
        TypedDate signingTime = signature.getSigningTime();
        if (signingTime == null) {
            this.setResult(result, SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE, (String[])new String[]{"signature_claimed_signing_time_missing"}));
            return;
        }
        Instant claimedSigningTime = signingTime.getDate().toInstant();
        ValidationPolicyType policy = context.getPolicy();
        boolean futureClaimedSigningTimeAllowed = policy.isClaimedSigningTimeInFutureAllowed();
        Instant currentInstant = Instant.now().plusSeconds(2L).truncatedTo(ChronoUnit.SECONDS);
        if (claimedSigningTime.isAfter(currentInstant) && !futureClaimedSigningTimeAllowed) {
            this.setResult(result, SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE, (ValidationMessageCode)SVPFactory.createMessageCode((String)"signature_claimed_signing_time_in_future", (Object[])new Object[]{Date.from(claimedSigningTime), Date.from(currentInstant)})));
            return;
        }
        X509CertificateImpl c = signature.getSigningCertificate();
        ValidationResult signal = null;
        if (c == null) {
            signal = SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.NO_SIGNING_CERTIFICATE_FOUND);
        } else {
            Instant from = c.getNotBefore().toInstant();
            Instant to = c.getNotAfter().toInstant();
            signal = claimedSigningTime.compareTo(from) < 0 || claimedSigningTime.compareTo(to) > 0 ? SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.OUT_OF_BOUNDS_NO_POE) : SVPFactory.createResultOk();
        }
        this.setResult(result, signal);
    }

    private void setResult(SignatureValidationResult result, ValidationResult signal) {
        result.setClaimedSigningTimeCheck(signal);
    }

    @Override
    public boolean isApplicable(Signature signature, SignatureValidationResult result, SignatureValidationContext context) {
        if (context.getPolicy().isClaimedSigningTimeCheckRequired().booleanValue()) {
            X509CertificateImpl signingCertificate = signature.getSigningCertificate();
            if (signingCertificate == null) {
                return true;
            }
            if (signature instanceof BaseCertificateSignature) {
                if (signature.isSigningCertificateTrustedAnchor()) {
                    TLType tlType;
                    ExtendedTLInformation tlInformation = ((BaseCertificateSignature)signature).getTslInformation();
                    if (tlInformation == null || (tlType = tlInformation.getTslType()) == null) {
                        return true;
                    }
                    return !tlType.equals((Object)TLType.OFFICIAL);
                }
            } else {
                X509Data trustedAnchor = context.getTrustedAnchor();
                if (trustedAnchor != null) {
                    boolean dontDoCheck;
                    ExtendedTLInformation tlInformation = trustedAnchor.getTslInformation();
                    if (tlInformation == null) {
                        return true;
                    }
                    boolean bl = dontDoCheck = tlInformation.getTslType().equals((Object)TLType.OFFICIAL) && signingCertificate.getSerialNumber().equals(((X509CertificateImpl)trustedAnchor.getCert()).getSerialNumber());
                    if (dontDoCheck) {
                        return !dontDoCheck;
                    }
                }
            }
            return true;
        }
        this.setResult(result, SVPFactory.create((MajorTotalResult)MajorTotalResult.NOT_VALIDATED, (String)"not_validated_because_of_policy"));
        return false;
    }
}

