/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.criteria;

import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.jcebase.X509CertificateFacade;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.validate.svp.AttributeCertificateValidationResult;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.csl.validation.ValidatePluginException;
import de.governikus.csl.validation.attributecert.AttributeCertificatePlugin;
import de.governikus.csl.validation.attributecert.AttributeCertificateSignature;
import de.governikus.csl.validation.context.CertificateValidationContext;
import de.governikus.csl.validation.context.DocumentValidationContext;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.RecursiveValidationCriterion;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckAttributeCertificates
extends RecursiveValidationCriterion<Signature, SignatureValidationResult, AttributeCertificateSignature, AttributeCertificateValidationResult, CertificateValidationContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckAttributeCertificates.class);

    @Override
    public void verify(Signature signature, SignatureValidationResult result, SignatureValidationContext context) {
        Set attributeCertificates;
        DocumentValidationContext documentValidationContext = context.getDocumentValidationContext();
        Map<AttributeCertificate, AttributeCertificateValidationResult> prefetchedAttributeCertificateValidationResults = null;
        if (documentValidationContext != null) {
            prefetchedAttributeCertificateValidationResults = documentValidationContext.getPrefetchedAttributeCertificateValidationResults();
        }
        if ((attributeCertificates = signature.getAttributeCertificates()) != null) {
            AttributeCertificatePlugin plugin = (AttributeCertificatePlugin)context.getConfiguration().getPlugin(Plugin.PluginID.VALIDATE_ATTRIBUTECERT.getID());
            ArrayList<AttributeCertificateValidationResult> results = new ArrayList<AttributeCertificateValidationResult>();
            for (AttributeCertificate attributeCertificate : attributeCertificates) {
                AttributeCertificateValidationResult prefetchedResult;
                if (prefetchedAttributeCertificateValidationResults != null && (prefetchedResult = prefetchedAttributeCertificateValidationResults.get(attributeCertificate)) != null) {
                    results.add(prefetchedResult);
                    prefetchedResult.setInformationSource(context.getCertificateSource());
                    continue;
                }
                try {
                    AttributeCertificateSignature sig = plugin.parseAsSignature(attributeCertificate);
                    sig.setBaseCertificate((X509CertificateFacade)signature.getSigningCertificate());
                    CertificateValidationContext newContext = (CertificateValidationContext)plugin.createContext(sig, context);
                    newContext.setCertificatePathReferences(null);
                    AttributeCertificateValidationResult validationResult = this.recursiveCall(sig, plugin, newContext);
                    validationResult.setInformationSource(context.getCertificateSource());
                    results.add(validationResult);
                }
                catch (ValidatePluginException e) {
                    LOGGER.error("Validation failed for certificate " + attributeCertificate + ".", (Throwable)((Object)e));
                }
            }
            result.getAttributeCertificateValidationResults().addAll(results);
        }
    }

    @Override
    public boolean isApplicable(Signature signature, SignatureValidationResult result, SignatureValidationContext context) {
        Set attributeCertificates = signature.getAttributeCertificates();
        return attributeCertificates != null && !attributeCertificates.isEmpty();
    }
}

