/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.criteria;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.governikus.csl.algorithm_catalog.AlgorithmCatalog;
import de.governikus.csl.algorithm_catalog.AlgorithmCatalogManager;
import de.governikus.csl.algorithm_catalog.AlgorithmCatalogResponse;
import de.governikus.csl.algorithm_catalog.UnsupportedCatalogNameException;
import de.governikus.csl.algorithm_catalog.Usage;
import de.governikus.csl.algorithm_catalog.impl.PublicKeySupport;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.AlgorithmCatalogMetaInformation;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.uom.validate.SignatureAlgorithmParameter;
import de.governikus.csl.uom.validate.ValidatePolicy;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.uom.validate.commons.SignedContentPart;
import de.governikus.csl.uom.validate.commons.SignedObjectType;
import de.governikus.csl.validate.svp.AlgorithmValidityResult;
import de.governikus.csl.validate.svp.DigestAlgorithmValidityInformation;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.csl.validate.svp.TypedDate;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSignatureAlgorithmValidityCheck
extends AbstractValidationCriterion<Signature, SignatureValidationResult, SignatureValidationContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSignatureAlgorithmValidityCheck.class);

    private TypedDate getBestSigningTime(Signature signature, SignatureValidationResult result, AlgorithmValidityResult algorithmValidationResult, SignatureValidationContext context) {
        TypedDate bestSigningTime = this.getValidationTime(signature, context);
        if (bestSigningTime == null) {
            algorithmValidationResult.setValidationDate(new Date());
            algorithmValidationResult.setValidationDateType(DateType.EXISTENCE);
            algorithmValidationResult.setSignatureAlgorithmValidationResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.SIG_CONSTRAINTS_FAILURE));
        } else {
            algorithmValidationResult.setValidationDate(bestSigningTime.getDate());
            algorithmValidationResult.setValidationDateType(bestSigningTime.getType());
        }
        this.setSignatureAlgorithmValidationResult(result, algorithmValidationResult);
        return bestSigningTime;
    }

    private X509CertificateImpl getSigningCert(Signature signature, SignatureValidationResult result, AlgorithmValidityResult validationResult) {
        X509CertificateImpl signingCertificate = signature.getSigningCertificate();
        if (signingCertificate == null) {
            validationResult.setSignatureAlgorithmValidationResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.NO_SIGNING_CERTIFICATE_FOUND));
            this.setSignatureAlgorithmValidationResult(result, validationResult);
        }
        return signingCertificate;
    }

    @Override
    public void verify(Signature signature, SignatureValidationResult result, SignatureValidationContext context) {
        AlgorithmValidityResult validationResult = new AlgorithmValidityResult();
        TypedDate bestSigningTime = this.getBestSigningTime(signature, result, validationResult, context);
        if (bestSigningTime == null) {
            return;
        }
        X509CertificateImpl signingCertificate = this.getSigningCert(signature, result, validationResult);
        if (signingCertificate == null) {
            return;
        }
        List<SignatureAlgorithmParameter> parameters = this.extractParameters(signingCertificate.getPublicKey());
        List signatureAlgorithmParameters = result.getSignatureAlgorithmParameters();
        if (signatureAlgorithmParameters.isEmpty()) {
            signatureAlgorithmParameters.addAll(parameters);
        }
        Usage usage = this.getUsage(signature.getType(), bestSigningTime);
        ValidationPolicyType policy = context.getPolicy();
        String algoCatToUse = policy.getAlgorithmCatalog().name();
        AlgorithmCatalogManager algorithmCatalogManager = context.getConfiguration().getAlgorithmCatalog();
        this.checkSignatureAlgorithm((ValidatePolicy)policy, validationResult, algorithmCatalogManager, algoCatToUse, signature, result, parameters, usage, bestSigningTime);
        this.checkHashAlgorithms((ValidatePolicy)policy, validationResult, algorithmCatalogManager, usage, signature, bestSigningTime, algoCatToUse);
    }

    protected abstract Usage getUsage(SignedObjectType var1, TypedDate var2);

    protected abstract TypedDate getValidationTime(Signature var1, SignatureValidationContext var2);

    protected abstract boolean isOldAlgorithmCausingInvalidResult(ValidatePolicy var1, Signature var2, Date var3, TypedDate var4);

    private void checkSignatureAlgorithm(ValidatePolicy policy, AlgorithmValidityResult validationResult, AlgorithmCatalogManager algorithmCatalogManager, String algoCatToUse, Signature signature, SignatureValidationResult result, List<SignatureAlgorithmParameter> parameters, Usage usage, TypedDate bestSigningTime) {
        SignatureAlgorithm sigAlg = signature.getSignatureAlgorithm();
        result.setSignatureAlgorithm(SVPFactory.createSignatureAlgorithm((SignatureAlgorithm)sigAlg));
        if (sigAlg == null) {
            validationResult.setSignatureAlgorithmValidationResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.CRYPTO_CONSTRAINTS_FAILURE, (String[])new String[]{"signature_algorithm_missing"}));
            return;
        }
        AlgorithmCatalog algorithmCatalog = null;
        AlgorithmCatalogMetaInformation catalogMetaData = null;
        AlgorithmCatalogResponse resp = null;
        try {
            algorithmCatalog = algorithmCatalogManager.getAlgorithmCatalog(algoCatToUse);
            catalogMetaData = algorithmCatalog.getCatalogMetaData();
            result.setAlgorithmCatalogInformation(catalogMetaData);
            resp = algorithmCatalogManager.getAlgorithmValidity(algoCatToUse, sigAlg, parameters, usage);
        }
        catch (UnsupportedCatalogNameException e) {
            validationResult.setSignatureAlgorithmValidationResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.CRYPTO_CONSTRAINTS_FAILURE, (String[])new String[]{"no_algorithm_catalog_configured"}));
            return;
        }
        catch (IllegalArgumentException e) {
            validationResult.setSignatureAlgorithmValidationResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.GENERIC, (String[])new String[]{"no_signature_algo_usage_defined"}));
            return;
        }
        if (resp.getExpirationDate() == null && !resp.isWithoutExpirationDate()) {
            validationResult.setSignatureAlgorithmValidationResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.CRYPTO_CONSTRAINTS_FAILURE, (String[])new String[]{"signature_algorithm_not_in_catalog"}));
            return;
        }
        Date signatureAlgorithmExpirationDate = resp.getExpirationDate();
        boolean withoutExpirationDate = resp.isWithoutExpirationDate();
        this.setExpirationDate(result, signatureAlgorithmExpirationDate, withoutExpirationDate);
        List reliabilityConcerns = catalogMetaData.getReliabilityConcerns();
        if (reliabilityConcerns != null && !reliabilityConcerns.isEmpty()) {
            validationResult.setSignatureAlgorithmValidationResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.CRYPTO_CONSTRAINTS_FAILURE, (List)reliabilityConcerns));
            return;
        }
        ValidationResult vr = this.createResult(signature, policy, resp, bestSigningTime);
        validationResult.setSignatureAlgorithmValidationResult(vr);
    }

    protected abstract void setExpirationDate(SignatureValidationResult var1, Date var2, boolean var3);

    private void checkHashAlgorithms(ValidatePolicy policy, AlgorithmValidityResult validationResult, AlgorithmCatalogManager algorithmCatalogManager, Usage usage, Signature signature, TypedDate bestSigningTime, String algoCatToUse) {
        List signedContentParts = signature.getSignedContentParts();
        if (signedContentParts != null) {
            ValidationResult vr = null;
            AlgorithmCatalog algorithmCatalog = null;
            AlgorithmCatalogResponse resp = null;
            ArrayList<DigestAlgorithmValidityInformation> digestInformationData = new ArrayList<DigestAlgorithmValidityInformation>();
            for (SignedContentPart scp : signedContentParts) {
                DigestAlgorithmValidityInformation davi;
                DigestAlgorithmValidityInformation davi2;
                boolean contentExists = true;
                try (InputStream is = scp.getContentPart();){
                    contentExists = is != null;
                }
                catch (IOException e) {
                    LOGGER.debug("Skipping algo validity check because of missing content part");
                }
                if (!contentExists) continue;
                DigestAlgorithm digestAlgorithm = scp.getDigestAlgorithm();
                if (digestAlgorithm == null) {
                    vr = SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.CRYPTO_CONSTRAINTS_FAILURE, (String[])new String[]{"signature_hash_algorithm_missing"});
                    DigestAlgorithmValidityInformation davi3 = new DigestAlgorithmValidityInformation();
                    davi3.setValidationResult(vr);
                    digestInformationData.add(davi3);
                    continue;
                }
                try {
                    algorithmCatalog = algorithmCatalogManager.getAlgorithmCatalog(algoCatToUse);
                }
                catch (UnsupportedCatalogNameException e) {
                    vr = SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.CRYPTO_CONSTRAINTS_FAILURE, (String[])new String[]{"no_algorithm_catalog_configured"});
                    DigestAlgorithmValidityInformation davi4 = new DigestAlgorithmValidityInformation();
                    davi4.setValidationResult(vr);
                    digestInformationData.add(davi4);
                    continue;
                }
                AlgorithmCatalogMetaInformation catalogMetaData = algorithmCatalog.getCatalogMetaData();
                List reliabilityConcerns = catalogMetaData.getReliabilityConcerns();
                if (reliabilityConcerns != null && !reliabilityConcerns.isEmpty()) {
                    vr = SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.CRYPTO_CONSTRAINTS_FAILURE, (List)reliabilityConcerns);
                    davi2 = new DigestAlgorithmValidityInformation();
                    davi2.setValidationResult(vr);
                    digestInformationData.add(davi2);
                    continue;
                }
                try {
                    resp = algorithmCatalogManager.getAlgorithmValidity(algoCatToUse, digestAlgorithm, usage);
                }
                catch (UnsupportedCatalogNameException e) {
                    vr = SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.CRYPTO_CONSTRAINTS_FAILURE, (String[])new String[]{"no_algorithm_catalog_configured"});
                    davi = new DigestAlgorithmValidityInformation();
                    davi.setValidationResult(vr);
                    digestInformationData.add(davi);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    vr = SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.GENERIC, (String[])new String[]{"no_hash_algo_usage_defined"});
                    davi = new DigestAlgorithmValidityInformation();
                    davi.setValidationResult(vr);
                    digestInformationData.add(davi);
                    continue;
                }
                if (resp.getExpirationDate() == null && !resp.isWithoutExpirationDate()) {
                    vr = SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.CRYPTO_CONSTRAINTS_FAILURE, (String[])new String[]{"signature_hash_algorithm_not_in_catalog"});
                    davi2 = new DigestAlgorithmValidityInformation();
                    davi2.setValidationResult(vr);
                    digestInformationData.add(davi2);
                    continue;
                }
                vr = this.createResult(signature, policy, resp, bestSigningTime);
                davi2 = new DigestAlgorithmValidityInformation();
                davi2.setValidationResult(vr);
                davi2.setDigestAlgorithm(SVPFactory.createDigestAlgorithm((DigestAlgorithm)digestAlgorithm));
                davi2.setAlgorithmExpirationDate(resp.getExpirationDate());
                digestInformationData.add(davi2);
            }
            validationResult.getDigestAlgorithmValidationResults().addAll(digestInformationData);
        }
    }

    private List<SignatureAlgorithmParameter> extractParameters(PublicKey publicKey) {
        if (RSAPublicKey.class.isInstance(publicKey) || ECPublicKey.class.isInstance(publicKey) || DSAPublicKey.class.isInstance(publicKey)) {
            return PublicKeySupport.Factory.extractParameters((PublicKey)publicKey);
        }
        return new ArrayList<SignatureAlgorithmParameter>();
    }

    private ValidationResult createResult(Signature signature, ValidatePolicy policy, AlgorithmCatalogResponse resp, TypedDate bestSigningTime) {
        ValidationResult vr = SVPFactory.createResultOk();
        Date dateToCompare = bestSigningTime.getDate();
        boolean withoutExpirationDate = resp.isWithoutExpirationDate();
        Date expirationDate = resp.getExpirationDate();
        if (dateToCompare == null || !withoutExpirationDate && expirationDate.compareTo(dateToCompare) < 0) {
            if (this.isOldAlgorithmCausingInvalidResult(policy, signature, expirationDate, bestSigningTime)) {
                vr.setMajor(MajorTotalResult.TOTAL_FAILED);
                vr.setMinor(MinorResult.CRYPTO_CONSTRAINTS_FAILURE);
            } else {
                vr.setMajor(MajorTotalResult.INDETERMINATE);
                vr.setMinor(MinorResult.CRYPTO_CONSTRAINTS_FAILURE_NO_POE);
            }
        }
        return vr;
    }

    protected abstract void setSignatureAlgorithmValidationResult(SignatureValidationResult var1, AlgorithmValidityResult var2);

    protected void buildInvalidateResult(SignatureValidationResult result) {
        AlgorithmValidityResult avr = new AlgorithmValidityResult();
        avr.setSignatureAlgorithmValidationResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.NOT_VALIDATED, (String)"not_validated_because_of_policy"));
        DigestAlgorithmValidityInformation davi = new DigestAlgorithmValidityInformation();
        davi.setValidationResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.NOT_VALIDATED, (String)"not_validated_because_of_policy"));
        avr.getDigestAlgorithmValidationResults().add(davi);
        this.setSignatureAlgorithmValidationResult(result, avr);
    }
}

