/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.context;

import de.governikus.csl.certStore.CertStoreCollection;
import de.governikus.csl.uom.jcebase.CertificateBase;
import de.governikus.csl.uom.validate.InformationSource;
import de.governikus.csl.uom.validate.PathValidationMethod;
import de.governikus.csl.uom.validate.RevocationValueValidationDepth;
import de.governikus.csl.uom.validate.ValidatePolicy;
import de.governikus.csl.uom.validate.commons.CertificateReference;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.utils.TrustStore;
import de.governikus.csl.validate.svp.TimestampValidationResult;
import de.governikus.csl.validate.svp.TypedDate;
import de.governikus.csl.validation.Configuration;
import de.governikus.csl.validation.context.DocumentValidationContext;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.validation.revocation.service.RevocationValueService;
import de.governikus.csl.validation.x509.X509Data;
import de.governikus.csl.validation.x509.chain.CertChainValidationStep;
import de.governikus.csl.validation.x509.chain.OkCheck;
import de.governikus.csl.validation.x509.chain.ValidationStepCheck;
import de.governikus.csl.validation.x509.chain.ValidationStepChecker;
import de.governikus.csl.validation.x509.chain.ValidationStepCheckerParser;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureValidationContext
implements Cloneable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignatureValidationContext.class);
    private CertChainValidationStep certChainValidationDepth;
    private ValidationStepChecker revocationValueValidationDepthChecker;
    private Deque<CertificateBase> ocspStack = new ArrayDeque<CertificateBase>();
    private CertStoreCollection certStore;
    private RevocationValueService revocationValueRequester;
    private Date validationDate;
    private TrustStore trustStore;
    private InformationSource certificateSource;
    private List<? extends CertificateReference> certificatePathReferences;
    private ValidationPolicyType policy;
    private Configuration configuration;
    private DocumentValidationContext documentValidationContext;
    private String lastOCSPURL;
    private TypedDate bestSigningTime;
    private TypedDate bestAlgValidationTime;
    private PathValidationMethod pathValidationMethod;
    private X509Data trustedAnchor;
    private Date selectedValidationDate;
    private List<TimestampValidationResult> prefetchedContentTimestampValidationResults;

    public Date getSelectedValidationDate() {
        return this.selectedValidationDate;
    }

    public void setSelectedValidationDate(Date selectedValidationDate) {
        this.selectedValidationDate = selectedValidationDate;
    }

    public SignatureValidationContext(ValidationPolicyType policy) {
        this.policy = policy;
    }

    public Deque<CertificateBase> getOcspStack() {
        return this.ocspStack;
    }

    public void setOcspStack(Deque<CertificateBase> ocspStack) {
        this.ocspStack = ocspStack;
    }

    public CertStoreCollection getCertStore() {
        return this.certStore;
    }

    public void setCertStore(CertStoreCollection certStore) {
        this.certStore = certStore;
    }

    public Date getValidationDate() {
        return this.validationDate;
    }

    public void setValidationDate(Date validationDate) {
        this.validationDate = validationDate;
    }

    public RevocationValueService getRevocationValueRequester() {
        return this.revocationValueRequester;
    }

    public void setRevocationValueRequester(RevocationValueService revocationValueRequester) {
        this.revocationValueRequester = revocationValueRequester;
    }

    public void setTrustStore(TrustStore trustStore) {
        this.trustStore = trustStore;
    }

    public TrustStore getTrustStore() {
        return this.trustStore;
    }

    public void setCertificatePathReferences(List<? extends CertificateReference> signingCertificateReferences) {
        this.certificatePathReferences = signingCertificateReferences;
    }

    public List<? extends CertificateReference> getCertificatePathReferences() {
        return this.certificatePathReferences;
    }

    public void copyValuesFrom(SignatureValidationContext context) {
        this.trustStore = context.trustStore;
        this.certificatePathReferences = context.certificatePathReferences != null ? new ArrayList<CertificateReference>(context.certificatePathReferences) : null;
        this.certificateSource = context.certificateSource;
        this.trustStore = context.trustStore;
        this.validationDate = context.validationDate;
        this.revocationValueRequester = context.revocationValueRequester;
        this.certStore = context.certStore;
        this.ocspStack = new ArrayDeque<CertificateBase>();
        this.ocspStack.addAll(context.ocspStack);
        this.policy = context.policy;
        if (context.certChainValidationDepth != null) {
            this.certChainValidationDepth = new CertChainValidationStep(context.certChainValidationDepth);
        }
        this.configuration = context.configuration;
        this.revocationValueValidationDepthChecker = context.revocationValueValidationDepthChecker;
        this.documentValidationContext = context.documentValidationContext;
        this.lastOCSPURL = context.lastOCSPURL;
        this.bestSigningTime = context.bestSigningTime;
        this.bestAlgValidationTime = context.bestAlgValidationTime;
        this.trustedAnchor = context.trustedAnchor;
        if (context.prefetchedContentTimestampValidationResults != null) {
            this.prefetchedContentTimestampValidationResults = new ArrayList<TimestampValidationResult>(context.prefetchedContentTimestampValidationResults);
        }
    }

    public InformationSource getCertificateSource() {
        return this.certificateSource;
    }

    public void setCertificateSource(InformationSource certificateSource) {
        this.certificateSource = certificateSource;
    }

    public ValidationPolicyType getPolicy() {
        return this.policy;
    }

    public void setPolicy(ValidationPolicyType policy) {
        this.policy = policy;
    }

    public CertChainValidationStep getCertChainValidationDepth() {
        return this.certChainValidationDepth;
    }

    public void setCertChainValidationDepth(CertChainValidationStep certChainValidationDepth) {
        this.certChainValidationDepth = certChainValidationDepth;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public ValidationStepChecker getRevocationValueValidationDepthChecker() {
        return this.revocationValueValidationDepthChecker;
    }

    public void setRevocationValueValidationDepthChecker(ValidationStepChecker revocationValueValidationDepthChecker) {
        this.revocationValueValidationDepthChecker = revocationValueValidationDepthChecker;
    }

    public DocumentValidationContext getDocumentValidationContext() {
        return this.documentValidationContext;
    }

    public void setDocumentValidationContext(DocumentValidationContext documentValidationContext) {
        this.documentValidationContext = documentValidationContext;
    }

    public String getLastOCSPURL() {
        return this.lastOCSPURL;
    }

    public void setLastOCSPURL(String lastOCSPURL) {
        this.lastOCSPURL = lastOCSPURL;
    }

    public TypedDate getBestSigningTime() {
        return this.bestSigningTime;
    }

    public void setBestSigningTime(TypedDate bestSigningTime) {
        this.bestSigningTime = bestSigningTime;
    }

    public void extendContext(Signature signature, Date validationDate, ValidatePolicy policy) {
        ValidationStepChecker versionChecker = null;
        if (policy != null) {
            try {
                RevocationValueValidationDepth revocationValueValidationDepth = policy.getRevocationValueValidationDepth();
                if (revocationValueValidationDepth == null) {
                    revocationValueValidationDepth = RevocationValueValidationDepth.MINIMAL;
                }
                versionChecker = ValidationStepCheckerParser.getInstance().getVersionChecker(revocationValueValidationDepth);
            }
            catch (IllegalArgumentException | ParseException e) {
                LOGGER.warn("Can't parse certificate chain validation depth pattern", (Throwable)e);
            }
        }
        if (versionChecker == null) {
            ArrayList<ValidationStepCheck> checks = new ArrayList<ValidationStepCheck>();
            checks.add(new OkCheck(true));
            versionChecker = new ValidationStepChecker(checks);
        }
        if (validationDate == null) {
            validationDate = new Date();
        }
        this.setValidationDate(validationDate);
        this.setRevocationValueValidationDepthChecker(versionChecker);
        CertStoreCollection defaultCertStore = this.configuration.getCertStore();
        RevocationValueService defaultRevocationService = this.configuration.getRevocationService();
        TrustStore defaultTrustStore = this.configuration.getTrustStore();
        this.setCertStore(defaultCertStore);
        this.setRevocationValueRequester(defaultRevocationService);
        this.setTrustStore(defaultTrustStore);
    }

    public PathValidationMethod getPathValidationMethod() {
        return this.pathValidationMethod;
    }

    public void setPathValidationMethod(PathValidationMethod pathValidationMethod) {
        this.pathValidationMethod = pathValidationMethod;
    }

    public TypedDate getBestAlgValidationTime() {
        return this.bestAlgValidationTime;
    }

    public void setBestAlgValidationTime(TypedDate bestAlgValidationTime) {
        this.bestAlgValidationTime = bestAlgValidationTime;
    }

    public X509Data getTrustedAnchor() {
        return this.trustedAnchor;
    }

    public void setTrustedAnchor(X509Data trustedAnchor) {
        this.trustedAnchor = trustedAnchor;
    }

    public List<TimestampValidationResult> getPrefetchedContentTimestampValidationResults() {
        return this.prefetchedContentTimestampValidationResults;
    }

    public void setPrefetchedContentTimestampValidationResults(List<TimestampValidationResult> prefetchedContentTimestampValidationResults) {
        this.prefetchedContentTimestampValidationResults = prefetchedContentTimestampValidationResults;
    }
}

