/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.context;

import de.governikus.csl.certStore.CertStoreCollection;
import de.governikus.csl.certStore.FixedOrderCertStore;
import de.governikus.csl.certStore.ListCertStore;
import de.governikus.csl.uom.validate.InformationSource;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.uom.validate.commons.SignatureValidationDataAttachment;
import de.governikus.csl.validate.svp.TimestampValidationResult;
import de.governikus.csl.validation.context.CertificateValidationContext;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.validation.revocation.RevocationValueBuilder;
import de.governikus.csl.validation.revocation.service.AttachedRevocationValueService;
import de.governikus.csl.validation.revocation.service.ListRevocationValueService;
import de.governikus.csl.validation.revocation.service.RevocationValueCache;
import de.governikus.csl.validation.revocation.service.RevocationValueService;
import de.governikus.csl.validation.revocation.service.WrappingRevocationValueService;
import java.security.cert.CRL;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextUtil.class);

    private ContextUtil() {
    }

    public static void extendContextWithAttachedCertificates(Signature signature, SignatureValidationContext context) {
        Set certs = signature.getAttachedCertificates();
        ContextUtil.extendContextWithCertificates(context, certs, InformationSource.SIGNATURE);
    }

    public static void extendContextWithCertificates(SignatureValidationContext context, Collection<SignatureValidationDataAttachment<X509Certificate>> certs, InformationSource source) {
        if (certs != null && !certs.isEmpty()) {
            ListCertStore listCertStore = new ListCertStore(certs, source);
            Object certStore = context.getCertStore();
            certStore = certStore != null ? certStore.fork(listCertStore) : new FixedOrderCertStore(listCertStore);
            context.setCertStore((CertStoreCollection)certStore);
        }
    }

    public static void extendContextWithAttachedRevocationValues(Signature signature, SignatureValidationContext context) {
        List ocsp = signature.getAttachedOCSPValues();
        List crl = signature.getAttachedCRLs();
        ContextUtil.extendContextWithRevocationValues(context, ocsp, crl, InformationSource.SIGNATURE);
    }

    public static void extendContextWithRevocationValues(SignatureValidationContext context, List<SignatureValidationDataAttachment<OCSPResp>> ocsp, List<SignatureValidationDataAttachment<CRL>> crl, InformationSource source) {
        if (ocsp != null && !ocsp.isEmpty() || crl != null && !crl.isEmpty()) {
            AlgorithmManager manager = context.getConfiguration().getAlgorithmManager();
            RevocationValueService defaultService = context.getRevocationValueRequester();
            RevocationValueBuilder requester = null;
            requester = defaultService != null ? new AttachedRevocationValueService(ocsp, crl, defaultService, false, manager, source) : new ListRevocationValueService(ocsp, crl, manager, source);
            context.setRevocationValueRequester((RevocationValueService)((Object)requester));
        }
    }

    public static void extendContextWithPrefetchedContentTimestampResults(SignatureValidationContext context, List<TimestampValidationResult> contentTimestampValidationResults) {
        if (contentTimestampValidationResults != null && !contentTimestampValidationResults.isEmpty()) {
            context.setPrefetchedContentTimestampValidationResults(contentTimestampValidationResults);
        }
    }

    public static AttachedRevocationValueService getOfflineAndOnlineService(CertificateValidationContext context) {
        RevocationValueService requester = context.getRevocationValueRequester();
        if (!AttachedRevocationValueService.class.isInstance(requester)) {
            return null;
        }
        return (AttachedRevocationValueService)AttachedRevocationValueService.class.cast(requester);
    }

    public static RevocationValueService getOnlineService(CertificateValidationContext context) {
        AttachedRevocationValueService attachedService = ContextUtil.getOfflineAndOnlineService(context);
        if (attachedService == null) {
            RevocationValueService requester = context.getRevocationValueRequester();
            if (RevocationValueCache.class.isInstance(requester)) {
                return (RevocationValueService)RevocationValueCache.class.cast(requester);
            }
            if (WrappingRevocationValueService.class.isInstance(requester)) {
                return (RevocationValueService)WrappingRevocationValueService.class.cast(requester);
            }
            return null;
        }
        return attachedService.getDefaultService();
    }

    public static ListRevocationValueService getOfflineService(CertificateValidationContext context) {
        AttachedRevocationValueService attachedService = ContextUtil.getOfflineAndOnlineService(context);
        if (attachedService == null) {
            RevocationValueService requester = context.getRevocationValueRequester();
            if (ListRevocationValueService.class.isInstance(requester)) {
                return (ListRevocationValueService)ListRevocationValueService.class.cast(requester);
            }
            return null;
        }
        RevocationValueService localService = attachedService.getLocalService();
        if (!ListRevocationValueService.class.isInstance(localService)) {
            return null;
        }
        return (ListRevocationValueService)ListRevocationValueService.class.cast(localService);
    }

    public static Map<byte[], CertificateValidationContext> getTmpContextByRevocationValue(CertificateValidationContext context) {
        ListRevocationValueService localService = ContextUtil.getOfflineService(context);
        if (!ListRevocationValueService.class.isInstance(localService)) {
            return Collections.emptyMap();
        }
        HashMap<byte[], CertificateValidationContext> contexts = new HashMap<byte[], CertificateValidationContext>();
        ContextUtil.addOcspTmpContexts(context, localService, contexts);
        ValidationPolicyType policy = context.getPolicy();
        if (policy != null && !policy.isOnlyOCSPAllowed().booleanValue()) {
            ContextUtil.addCrlTmpContexts(context, localService, contexts);
        }
        return contexts;
    }

    public static void addOcspTmpContexts(CertificateValidationContext context, ListRevocationValueService localService, Map<byte[], CertificateValidationContext> contexts) {
        List<SignatureValidationDataAttachment<OCSPResp>> ocsps = localService.getOcsps();
        if (ocsps != null) {
            for (SignatureValidationDataAttachment<OCSPResp> ocsp : ocsps) {
                OCSPResp value = (OCSPResp)ocsp.getValue();
                try {
                    byte[] encoded = value.getEncoded();
                    if (encoded == null || encoded.length == 0) {
                        LOGGER.debug("No null or empty attached OCSP revocation value");
                        continue;
                    }
                    CertificateValidationContext tmpContext = ContextUtil.getOcspOfflineCheckTmpContext(context, ocsp);
                    contexts.put(encoded, tmpContext);
                }
                catch (Exception e) {
                    LOGGER.error("Error during tmp OCSP context building", (Throwable)e);
                }
            }
        }
    }

    public static void addCrlTmpContexts(CertificateValidationContext context, ListRevocationValueService localService, Map<byte[], CertificateValidationContext> contexts) {
        List<SignatureValidationDataAttachment<CRL>> crls = localService.getCrls();
        if (crls != null) {
            for (SignatureValidationDataAttachment<CRL> crl : crls) {
                CRL value = (CRL)crl.getValue();
                try {
                    byte[] encoded = ((X509CRL)value).getEncoded();
                    if (encoded == null || encoded.length == 0) {
                        LOGGER.debug("No null or empty attached CRL revocation value");
                        continue;
                    }
                    CertificateValidationContext tmpContext = ContextUtil.getCrlOfflineCheckTmpContext(context, crl);
                    contexts.put(encoded, tmpContext);
                }
                catch (Exception e) {
                    LOGGER.error("Error during tmp CRL context building", (Throwable)e);
                }
            }
        }
    }

    public static CertificateValidationContext getOcspOfflineCheckTmpContext(CertificateValidationContext context, SignatureValidationDataAttachment<OCSPResp> ocsp) {
        return ContextUtil.getOfflineCheckTmpContext(context, Collections.singletonList(ocsp), null);
    }

    public static CertificateValidationContext getCrlOfflineCheckTmpContext(CertificateValidationContext context, SignatureValidationDataAttachment<CRL> crl) {
        return ContextUtil.getOfflineCheckTmpContext(context, null, Collections.singletonList(crl));
    }

    public static CertificateValidationContext getOfflineCheckTmpContext(CertificateValidationContext context, List<SignatureValidationDataAttachment<OCSPResp>> ocsp, List<SignatureValidationDataAttachment<CRL>> crl) {
        CertificateValidationContext tmpContext = new CertificateValidationContext(context);
        tmpContext.setRevocationValueRequester(null);
        ContextUtil.extendContextWithRevocationValues(tmpContext, ocsp, crl, InformationSource.SIGNATURE);
        return tmpContext;
    }
}

