/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.attributecert;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.jcebase.X509AttributeCertificateImpl;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.validate.svp.AttributeCertificateValidationResult;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.attributecert.AttributeCertificateSignature;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import java.security.GeneralSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckBaseCertificate
extends AbstractValidationCriterion<AttributeCertificateSignature, AttributeCertificateValidationResult, SignatureValidationContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckBaseCertificate.class);

    @Override
    public void verify(AttributeCertificateSignature signature, AttributeCertificateValidationResult result, SignatureValidationContext context) {
        try {
            boolean checkHolder = ((X509AttributeCertificateImpl)signature.getCert()).checkHolder(signature.getBaseCertificate());
            ValidationResult res = null;
            if (checkHolder) {
                res = SVPFactory.createResultOk();
            } else {
                LOGGER.warn("Can't check base certificate against attribute certificate. No check holder.");
                res = SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.FORMAT_FAILURE);
            }
            result.setBaseCertificateCheck(res);
        }
        catch (GeneralSecurityException e) {
            LOGGER.warn("Can't check base certificate against attribute certificate", (Throwable)e);
            result.setBaseCertificateCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.FORMAT_FAILURE));
        }
    }

    @Override
    public boolean isApplicable(AttributeCertificateSignature signature, AttributeCertificateValidationResult result, SignatureValidationContext context) {
        return signature.getBaseCertificate() != null;
    }
}

