/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.attributecert;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.validate.svp.AttributeCertificateValidationResult;
import de.governikus.csl.validate.svp.TypedDate;
import de.governikus.csl.validation.SignatureValidator;
import de.governikus.csl.validation.attributecert.AttributeCertificateSignature;
import de.governikus.csl.validation.context.CertificateValidationContext;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.x509.CertChainResult;
import de.governikus.csl.validation.x509.CertificateValidator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AttributeCertificateValidator
implements SignatureValidator<AttributeCertificateSignature, AttributeCertificateValidationResult, CertificateValidationContext> {
    private CertificateValidator validator;
    private AttributeCertificateSignature signature;
    private CertificateValidationContext context;

    public AttributeCertificateValidator(CertificateValidator validator, AttributeCertificateSignature signature, CertificateValidationContext context) {
        this.validator = validator;
        this.signature = signature;
        this.context = context;
    }

    private List<TypedDate> listPossiblePOEs(SignatureValidationContext context) {
        Date validationDate;
        ArrayList<TypedDate> possiblePOEs = new ArrayList<TypedDate>();
        TypedDate bestSigningTime = context.getBestSigningTime();
        if (bestSigningTime != null) {
            possiblePOEs.add(bestSigningTime);
        }
        if ((validationDate = context.getValidationDate()) != null) {
            possiblePOEs.add(SVPFactory.createTypedDate((Date)validationDate, (DateType)DateType.EXISTENCE));
        }
        return possiblePOEs;
    }

    @Override
    public AttributeCertificateValidationResult validateSignature() {
        CertChainResult<AttributeCertificateValidationResult> result = this.validator.validate(this.signature, this.context, this.listPossiblePOEs(this.context), this.listPossibleAlgValidationTimes(this.context));
        if (this.context.getPolicy() != null) {
            // empty if block
        }
        return result.getCertificateValidationResult();
    }

    @Override
    public CertificateValidationContext getContext() {
        return this.context;
    }

    private List<TypedDate> listPossibleAlgValidationTimes(SignatureValidationContext context) {
        Date validationDate;
        ArrayList<TypedDate> possiblePOEs = new ArrayList<TypedDate>();
        TypedDate bestSigningTime = context.getBestAlgValidationTime();
        if (bestSigningTime != null) {
            possiblePOEs.add(bestSigningTime);
        }
        if ((validationDate = context.getValidationDate()) != null) {
            possiblePOEs.add(SVPFactory.createTypedDate((Date)validationDate, (DateType)DateType.EXISTENCE));
        }
        return possiblePOEs;
    }
}

