/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.attributecert;

import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.governikus.csl.core.impl.BaseObjectToValidate;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.LogHelper;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.PluginType;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.docs.ByteArrayDocument;
import de.governikus.csl.uom.jcebase.ASN1CertUtil;
import de.governikus.csl.uom.jcebase.X509AttributeCertificateImpl;
import de.governikus.csl.uom.jcebase.X509CertificateFacade;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.ObjectToValidate;
import de.governikus.csl.uom.validate.commons.SignedObjectType;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.validate.svp.AttributeCertificateValidationResult;
import de.governikus.csl.validate.svp.ObjectValidationResult;
import de.governikus.csl.validation.AbstractDocumentPlugin;
import de.governikus.csl.validation.CertificateDocumentValidator;
import de.governikus.csl.validation.IncludedFileValidator;
import de.governikus.csl.validation.ObjectValidator;
import de.governikus.csl.validation.SignatureValidator;
import de.governikus.csl.validation.ValidatePlugin;
import de.governikus.csl.validation.ValidatePluginException;
import de.governikus.csl.validation.ValidationCriterion;
import de.governikus.csl.validation.attributecert.AttributeCertificateDataExtractor;
import de.governikus.csl.validation.attributecert.AttributeCertificateSignature;
import de.governikus.csl.validation.attributecert.AttributeCertificateValidator;
import de.governikus.csl.validation.attributecert.CheckBaseCertificate;
import de.governikus.csl.validation.context.CertificateValidationContext;
import de.governikus.csl.validation.dataExtractor.DataExtractor;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.validation.x509.criteria.CheckChainEnd;
import de.governikus.csl.validation.x509.criteria.RevocationStatusChecker;
import de.governikus.csl.validation.x509.criteria.RevocationTrustCheck;
import de.governikus.csl.validation.x509.criteria.ValidityCheck;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.slf4j.Logger;

@PluginType(id=Plugin.PluginID.VALIDATE_ATTRIBUTECERT, type=ValidatePlugin.class)
public class AttributeCertificatePlugin
extends AbstractDocumentPlugin<BaseObjectToValidate<AttributeCertificateSignature>, AttributeCertificateSignature, ObjectValidationResult, AttributeCertificateValidationResult, CertificateValidationContext> {
    public AttributeCertificatePlugin() {
        super(AttributeCertificateSignature.class, CertificateValidationContext.class);
    }

    @Override
    public BaseObjectToValidate<AttributeCertificateSignature> parseDocument(SignedData doc, TempDataManager tempDataManager) throws ValidatePluginException {
        Document signatureDocument = doc.getSignature();
        AttributeCertificate cert = null;
        try (InputStream is = signatureDocument.getInputStream();){
            cert = CryptoProviderUtil.loadAttributeCertificate((InputStream)is);
        }
        catch (Exception e) {
            throw new ValidatePluginException(this, "Can't parse document", e);
        }
        if (cert == null) {
            throw new ValidatePluginException(this, "Can't parse document");
        }
        X509CertificateImpl baseCert = null;
        List contents = doc.getContents();
        if (contents != null && !contents.isEmpty()) {
            Document content = (Document)contents.get(0);
            try (InputStream is = content.getInputStream();){
                CertificateFactory factory = CryptoProviderUtil.getCertificateFactoryInstance((String)"X509");
                X509Certificate generateCertificate = (X509Certificate)factory.generateCertificate(is);
                baseCert = new X509CertificateImpl(generateCertificate);
            }
            catch (IOException | NoSuchProviderException | CertificateException e) {
                LogHelper.logException(null, (Logger)this.logger, (Throwable)e);
            }
        }
        return this.parse(cert, (X509CertificateFacade)baseCert);
    }

    private BaseObjectToValidate<AttributeCertificateSignature> parse(AttributeCertificate cert, X509CertificateFacade baseCert) throws ValidatePluginException {
        BaseObjectToValidate result = new BaseObjectToValidate();
        result.setName("Attribute certificate " + cert.getAcinfo().getIssuer().toString());
        ArrayList<AttributeCertificateSignature> signatures = new ArrayList<AttributeCertificateSignature>();
        result.setSignatures(signatures);
        AttributeCertificateSignature signature = this.parseAsSignature(cert);
        signature.setBaseCertificate(baseCert);
        signatures.add(signature);
        return result;
    }

    public AttributeCertificateSignature parseAsSignature(AttributeCertificate cert) throws ValidatePluginException {
        AttributeCertificateSignature signature = new AttributeCertificateSignature();
        AlgorithmManager algorithmManager = this.configuration.getAlgorithmManager();
        String oid = cert.getSignatureAlgorithm().getAlgorithm().getId();
        SignatureAlgorithm signatureAlgorithm = null;
        try {
            signatureAlgorithm = ASN1CertUtil.getSignatureAlgorithm((AttributeCertificate)cert, (AlgorithmManager)algorithmManager);
        }
        catch (IllegalArgumentException | CertificateException e1) {
            this.logger.warn("Can't get signature algorithm from attribute certificate", (Throwable)e1);
            signatureAlgorithm = algorithmManager.getSignatureAlgorithmByOID(oid);
        }
        signature.setSignatureAlgorithm(signatureAlgorithm);
        signature.setSignatureValue(cert.getSignatureValue().getBytes());
        try {
            ByteArrayDocument bais = new ByteArrayDocument(cert.getAcinfo().getEncoded());
            signature.setSignedContent((Document)bais);
        }
        catch (IOException e) {
            this.logger.debug("Can't parse attribute certificate.", (Throwable)e);
            throw new ValidatePluginException(this, "Can't parse attribute certificate", e);
        }
        Date claimedSigningTime = null;
        try {
            claimedSigningTime = cert.getAcinfo().getAttrCertValidityPeriod().getNotBeforeTime().getDate();
        }
        catch (ParseException e) {
            this.logger.debug("Can't get signing time", (Throwable)e);
            throw new ValidatePluginException(this, "Can't get signing time", e);
        }
        if (claimedSigningTime != null) {
            signature.setSigningTime(SVPFactory.createTypedDate((Date)claimedSigningTime, (DateType)DateType.CLAIMED_SIGNING_TIME));
        }
        signature.setCert(new X509AttributeCertificateImpl(cert));
        signature.setType(SignedObjectType.ATTRIBUTE_CERTIFICATE);
        return signature;
    }

    @Override
    protected ObjectValidationResult createResultStructure(ObjectToValidate<?> objectToValidate) {
        return SVPFactory.createObjectValidationResult((String)Plugin.PluginID.VALIDATE_ATTRIBUTECERT.getID());
    }

    @Override
    protected AttributeCertificateValidationResult createSignatureValidationResultStructure() {
        return new AttributeCertificateValidationResult();
    }

    @Override
    public CertificateValidationContext createContext(AttributeCertificateSignature signature, ValidationPolicyType policy) {
        return new CertificateValidationContext(policy);
    }

    @Override
    public SignatureValidator<?, ? extends AttributeCertificateValidationResult, CertificateValidationContext> createSignatureValidator(AttributeCertificateSignature signature, CertificateValidationContext context, List<ValidationCriterion<? super AttributeCertificateSignature, ? super AttributeCertificateValidationResult, ? super CertificateValidationContext>> customCriteria) {
        return new AttributeCertificateValidator(this.configuration.getCertValidator(), signature, context);
    }

    public static List<ValidationCriterion<? super AttributeCertificateSignature, ? super AttributeCertificateValidationResult, ? super CertificateValidationContext>> getAllKnownCustomPlugins() {
        ArrayList<ValidationCriterion<? super AttributeCertificateSignature, ? super AttributeCertificateValidationResult, ? super CertificateValidationContext>> result = new ArrayList<ValidationCriterion<? super AttributeCertificateSignature, ? super AttributeCertificateValidationResult, ? super CertificateValidationContext>>();
        result.add(new CheckBaseCertificate());
        result.add(new RevocationStatusChecker());
        result.add(new ValidityCheck());
        result.add(new RevocationTrustCheck());
        result.add(new CheckChainEnd());
        return result;
    }

    @Override
    public DataExtractor<? super AttributeCertificateSignature, ? super AttributeCertificateValidationResult> getSignatureDataExtractor() {
        return new AttributeCertificateDataExtractor();
    }

    @Override
    public ObjectValidator getDocumentValidator(BaseObjectToValidate<AttributeCertificateSignature> parsedDocument, IncludedFileValidator requestProcessor) {
        return new CertificateDocumentValidator<AttributeCertificateSignature, AttributeCertificateValidationResult>(this, parsedDocument, this.getConfiguration().getCertValidator());
    }
}

