/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.attributecert;

import de.governikus.csl.result.LDAPEntry;
import de.governikus.csl.uom.jcebase.X509AttributeCertificateImpl;
import de.governikus.csl.validate.svp.AttributeCertificateValidationResult;
import de.governikus.csl.validation.attributecert.AttributeCertificateSignature;
import de.governikus.csl.validation.dataExtractor.DefaultSignatureDataExtractor;
import javax.security.auth.x500.X500Principal;

public class AttributeCertificateDataExtractor
extends DefaultSignatureDataExtractor<AttributeCertificateSignature, AttributeCertificateValidationResult> {
    @Override
    public void extractData(AttributeCertificateSignature source, AttributeCertificateValidationResult destination) {
        X500Principal issuer;
        super.extractData(source, destination);
        X509AttributeCertificateImpl cert = (X509AttributeCertificateImpl)source.getCert();
        destination.setCert(cert);
        X500Principal subject = cert.getHolderIssuerX500Principal();
        if (subject != null) {
            LDAPEntry lDAPEntry = new LDAPEntry(subject);
        }
        if ((issuer = cert.getIssuerX500Principal()) != null) {
            LDAPEntry lDAPEntry = new LDAPEntry(issuer);
        }
        destination.setValidityModel(source.getValidityModel());
    }
}

