/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.algorithm;

import de.governikus.csl.algorithm_catalog.AlgorithmCatalog;
import de.governikus.csl.algorithm_catalog.AlgorithmCatalogException;
import de.governikus.csl.algorithm_catalog.FallbackAlgorithmCatalogManager;
import de.governikus.csl.simple.xml.EnvelopedXMLSignatureValidationResult;
import de.governikus.csl.simple.xml.EnvelopedXMLSignatureValidator;
import de.governikus.csl.tsl.InvalidTLSignatureHandlingApproach;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.docs.ByteArrayDocument;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.validation.algorithm.InvalidSignedAlgorithmCatalogException;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.IOUtils;

public class SecuredAlgorithmCatalog
extends FallbackAlgorithmCatalogManager {
    private CertStore certStore;
    private InvalidTLSignatureHandlingApproach brokenSignatureHandlingInstruction = InvalidTLSignatureHandlingApproach.USE_TL_BUT_INVALIDATE_RESULTS;

    public AlgorithmCatalog addCatalog(String key, Document document) throws JAXBException, IOException, AlgorithmCatalogException {
        AlgorithmCatalog result = null;
        try (InputStream is = document.getInputStream();){
            result = super.addCatalog(key, is);
        }
        this.checkSignature(result, document);
        return result;
    }

    public AlgorithmCatalog addCatalog(String key, InputStream is) throws JAXBException, IOException, AlgorithmCatalogException {
        byte[] data = IOUtils.toByteArray((InputStream)is);
        AlgorithmCatalog result = null;
        ByteArrayDocument bad = new ByteArrayDocument(data);
        try (InputStream str = bad.getInputStream();){
            result = super.addCatalog(key, str);
        }
        this.checkSignature(result, (Document)bad);
        return result;
    }

    public AlgorithmCatalog setDefaultCatalog(Document document) throws IOException, JAXBException, AlgorithmCatalogException {
        AlgorithmCatalog result = null;
        result = super.setDefaultCatalog(document);
        this.checkSignature(result, document);
        return result;
    }

    private void checkSignature(AlgorithmCatalog catalog, Document doc) throws IOException, InvalidSignedAlgorithmCatalogException {
        if (!this.checkSignature(doc) && this.process(this.brokenSignatureHandlingInstruction)) {
            catalog.addReliabilityConcern("algo_cat_invalid_signature");
        }
    }

    private boolean checkSignature(Document doc) throws IOException {
        if (this.certStore == null) {
            return false;
        }
        try (InputStream is = doc.getInputStream();){
            EnvelopedXMLSignatureValidator validator = new EnvelopedXMLSignatureValidator(this.certStore);
            EnvelopedXMLSignatureValidationResult validateResult = validator.validate(is);
            boolean bl = validateResult.isSignatureValid() && validateResult.isWholeDocumentSigned();
            return bl;
        }
    }

    private boolean process(InvalidTLSignatureHandlingApproach errorHandlingType) throws InvalidSignedAlgorithmCatalogException {
        switch (errorHandlingType) {
            case THROW_EXCEPTION: {
                throw new InvalidSignedAlgorithmCatalogException();
            }
            case USE_TL: {
                break;
            }
            case USE_TL_BUT_INVALIDATE_RESULTS: {
                return true;
            }
        }
        return false;
    }

    private CertStore createCertStore(List<? extends Certificate> allowedCertificates) {
        List<? extends Certificate> certs = allowedCertificates;
        if (certs == null) {
            certs = new ArrayList<Certificate>();
        }
        CollectionCertStoreParameters certStoreParameters = new CollectionCertStoreParameters(certs);
        try {
            return CertStore.getInstance("Collection", (CertStoreParameters)certStoreParameters, CryptoProviderUtil.PROVIDER);
        }
        catch (Exception e) {
            try {
                return CertStore.getInstance("Collection", (CertStoreParameters)certStoreParameters, "BC");
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public void setAllowedCertificates(List<? extends Certificate> allowedCertificates) {
        this.certStore = this.createCertStore(allowedCertificates);
    }

    public InvalidTLSignatureHandlingApproach getBrokenSignatureHandlingInstruction() {
        return this.brokenSignatureHandlingInstruction;
    }

    public void setBrokenSignatureHandlingInstruction(InvalidTLSignatureHandlingApproach brokenSignatureHandlingInstruction) {
        this.brokenSignatureHandlingInstruction = brokenSignatureHandlingInstruction;
    }
}

