/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation;

import de.governikus.csl.request.ValidationOptions;
import de.governikus.csl.result.DocumentValidationResultList;
import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.DetachedContentCallback;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.InstanceProvider;
import de.governikus.csl.uom.MissingPluginException;
import de.governikus.csl.uom.ProcessorParameters;
import de.governikus.csl.uom.ProcessorType;
import de.governikus.csl.uom.RequestProcessor;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.docs.BasenameMappingDetachedContentCallback;
import de.governikus.csl.uom.impl.AbstractRequestProcessor;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.util.TempDataManagerImpl;
import de.governikus.csl.uom.validate.ValidateOptions;
import de.governikus.csl.uom.validate.ValidateProcessor;
import de.governikus.csl.uom.validate.ValidateRequest;
import de.governikus.csl.uom.validate.ValidateResponse;
import de.governikus.csl.utils.CslTimingUtil;
import de.governikus.csl.utils.MagicBytes;
import de.governikus.csl.validate.svp.ObjectValidationResult;
import de.governikus.csl.validation.Configuration;
import de.governikus.csl.validation.IncludedFileValidator;
import de.governikus.csl.validation.IncorrectFormatException;
import de.governikus.csl.validation.ObjectValidator;
import de.governikus.csl.validation.ValidatePlugin;
import de.governikus.csl.validation.ValidatePluginException;
import de.governikus.csl.validation.ValidationProcessorParams;
import de.governikus.csl.validation.context.DocumentValidationContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProcessorType(id=RequestProcessor.ProcessorID.VALIDATE, type=ValidateProcessor.class)
public class ValidationRequestProcessor
extends AbstractRequestProcessor
implements IncludedFileValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidationRequestProcessor.class);
    private Configuration config;
    private TempDataManager tempDataManager;

    public ValidationRequestProcessor() {
    }

    public ValidationRequestProcessor(Configuration config) {
        this.config = config;
        String tmpDir = System.getProperty("java.io.tmpdir");
        File tmpDirectory = new File(tmpDir);
        File folder = new File(tmpDirectory, "ValidationRequestProcessor");
        if (!folder.exists()) {
            folder.mkdir();
        }
        this.init(config, (TempDataManager)new TempDataManagerImpl(folder));
    }

    public ValidationRequestProcessor(Configuration config, TempDataManager tempDataManager) {
        this.init(config, tempDataManager);
    }

    private void init(Configuration config, TempDataManager tempDataManager) {
        this.config = config;
        this.tempDataManager = tempDataManager;
    }

    public ObjectValidationResult validate(SignedData sda, ValidateOptions options) throws CoreException {
        ValidationOptions opts = this.checkOptions(options);
        DocumentValidationContext documentValidationContext = new DocumentValidationContext();
        documentValidationContext.setOptions(opts);
        return this.validate(sda, documentValidationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectValidationResult validate(SignedData sda, DocumentValidationContext context) throws CoreException {
        String name = sda.getSignature() == null ? "?" : sda.getSignature().getName();
        TempDataManager requestTempDataManager = this.tempDataManager.createChildManager("request");
        try {
            Instant parseStart = null;
            if (CslTimingUtil.isTimingDebuggingEnabled()) {
                parseStart = Instant.now();
            }
            ObjectValidator pr = this.parseDocument(sda, requestTempDataManager);
            if (CslTimingUtil.isTimingDebuggingEnabled() && parseStart != null) {
                LOGGER.debug("Parsing of {} took {} ms.", (Object)name, (Object)Duration.between(parseStart, Instant.now()).toMillis());
            }
            if (pr == null) {
                throw new CoreException("Document cannot be parsed!");
            }
            Instant validateStart = null;
            if (CslTimingUtil.isTimingDebuggingEnabled()) {
                validateStart = Instant.now();
            }
            LOGGER.debug("Start validating {}", (Object)name);
            ObjectValidationResult result = pr.validate(context);
            LOGGER.debug("Finished validating {}", (Object)name);
            if (CslTimingUtil.isTimingDebuggingEnabled() && validateStart != null) {
                LOGGER.debug("Validation of {} took {} ms.", (Object)name, (Object)Duration.between(validateStart, Instant.now()).toMillis());
            }
            ObjectValidationResult objectValidationResult = result;
            return objectValidationResult;
        }
        finally {
            Instant tmpCleanupStart = null;
            if (CslTimingUtil.isTimingDebuggingEnabled()) {
                tmpCleanupStart = Instant.now();
            }
            requestTempDataManager.cleanUp();
            if (CslTimingUtil.isTimingDebuggingEnabled() && tmpCleanupStart != null) {
                LOGGER.debug("Cleaning up tmp data for validation of {} took {} ms.", (Object)name, (Object)Duration.between(tmpCleanupStart, Instant.now()).toMillis());
            }
        }
    }

    private ValidationOptions checkOptions(ValidateOptions options) {
        if (options == null) {
            ValidationOptions opt = new ValidationOptions();
            opt.setValidationDate(new Date());
            return opt;
        }
        if (options instanceof ValidationOptions) {
            ValidationOptions vopts = (ValidationOptions)options;
            if (vopts.getValidationDate() == null) {
                vopts.setValidationDate(new Date());
            }
            if (vopts.getDetachedContentCallback() == null) {
                vopts.setDetachedContentCallback((DetachedContentCallback)new BasenameMappingDetachedContentCallback());
            }
            return vopts;
        }
        throw new IllegalArgumentException("Unsupported options type");
    }

    public ObjectValidator parseDocument(SignedData sda, TempDataManager requestTempDataManager) throws CoreException {
        Document signature = sda.getSignature();
        byte[] magicBytes = ValidationRequestProcessor.readMagicBytes(signature);
        String name = signature.getName();
        ObjectValidator doc = null;
        LinkedList<ValidatePlugin> pluginsToUse = new LinkedList<ValidatePlugin>(this.config.getPrioritisedPluginList());
        Iterator iterator = pluginsToUse.iterator();
        while (iterator.hasNext()) {
            ValidatePlugin p = (ValidatePlugin)iterator.next();
            MagicBytes formatMagicBytes = p.getMagicBytesOfDocumentFormat();
            if (formatMagicBytes != null && formatMagicBytes.containedIn(magicBytes)) {
                doc = this.parse(p, sda, requestTempDataManager);
                if (doc != null) {
                    LOGGER.debug("{} is able to parse document {}", (Object)p.getID(), (Object)name);
                    return doc;
                }
                iterator.remove();
                continue;
            }
            String[] supportedFileExtensions = p.getSupportedFileExtensions();
            if (name == null || supportedFileExtensions == null) continue;
            String loweredName = name.toLowerCase(Locale.ENGLISH);
            boolean extensionSupported = false;
            for (String supportedFileExtension : supportedFileExtensions) {
                if (!loweredName.endsWith(supportedFileExtension.toLowerCase(Locale.ENGLISH))) continue;
                extensionSupported = true;
                break;
            }
            if (!extensionSupported) continue;
            doc = this.parse(p, sda, requestTempDataManager);
            if (doc != null) {
                LOGGER.debug("{} is able to parse document {}", (Object)p.getID(), (Object)name);
                return doc;
            }
            iterator.remove();
        }
        Document signatureData = signature;
        if (signatureData.getContentType() != null) {
            final String mimeType = signatureData.getContentType();
            Collections.sort(pluginsToUse, new Comparator<ValidatePlugin>(){

                @Override
                public int compare(ValidatePlugin o1, ValidatePlugin o2) {
                    boolean b2;
                    boolean b1 = o1.supportsMimeType(mimeType);
                    if (b1 == (b2 = o2.supportsMimeType(mimeType))) {
                        return 0;
                    }
                    if (b1) {
                        return -1;
                    }
                    if (b2) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
        for (ValidatePlugin verifier : pluginsToUse) {
            doc = this.parse(verifier, sda, requestTempDataManager);
            if (doc == null) continue;
            LOGGER.debug("{} is able to parse document {}", (Object)verifier.getID(), (Object)name);
            return doc;
        }
        throw new MissingPluginException("No Plugin found!");
    }

    private ObjectValidator parse(ValidatePlugin plugin, SignedData signedData, TempDataManager tmpDataManager) throws IncorrectFormatException {
        ObjectValidator result;
        block4: {
            result = null;
            try {
                result = plugin.getObjectValidator(signedData, tmpDataManager, this);
            }
            catch (IncorrectFormatException e) {
                throw e;
            }
            catch (ValidatePluginException e) {
                if (LOGGER.isDebugEnabled()) {
                    Document signature = signedData.getSignature();
                    LOGGER.debug("{} can't parse document {}", (Object)plugin.getClass().getSimpleName(), (Object)(signature != null ? signature.getName() : ""));
                }
                if (!LOGGER.isTraceEnabled()) break block4;
                LOGGER.trace("ParseException: ", (Throwable)((Object)e));
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] readMagicBytes(Document signature) {
        int bytesToRead = 5;
        try (InputStream is = signature.getInputStream();){
            byte[] data = new byte[bytesToRead];
            IOUtils.read((InputStream)is, (byte[])data, (int)0, (int)bytesToRead);
            byte[] byArray = data;
            return byArray;
        }
        catch (IOException e) {
            LOGGER.error("Can't read magic bytes", (Throwable)e);
            return null;
        }
    }

    public ValidateResponse validate(ValidateRequest validateRequest) throws CoreException {
        ValidateOptions options = (ValidateOptions)validateRequest.getOptions();
        options = this.checkOptions(options);
        DocumentValidationResultList result = new DocumentValidationResultList();
        SignedData document = validateRequest.getSignedData();
        if (document != null) {
            ObjectValidationResult verifyResult = this.validate(document, options);
            result.setDocumentValidationResult(verifyResult);
        }
        result.setValidationTime(options.getValidationDate());
        return result;
    }

    public void setParams(ProcessorParameters params) throws Exception {
        ValidationProcessorParams p = (ValidationProcessorParams)params;
        if (p.getTempDataManager() == null && p.getConfig() != null) {
            this.config = p.getConfig();
            String tmpDir = System.getProperty("java.io.tmpdir");
            File tmpDirectory = new File(tmpDir);
            File folder = new File(tmpDirectory, "ValidationRequestProcessor");
            if (!folder.exists()) {
                folder.mkdir();
            }
            this.init(this.config, (TempDataManager)new TempDataManagerImpl(folder));
        } else if (p.getConfig() != null && p.getTempDataManager() != null) {
            this.init(p.getConfig(), p.getTempDataManager());
        } else {
            throw new Exception("Invalid Arguments");
        }
    }

    public synchronized void setInstanceProvider(InstanceProvider instanceProvider) {
    }
}

