/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation;

import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.csl.validate.svp.TypedDate;
import de.governikus.csl.validation.Configuration;
import de.governikus.csl.validation.ETSIBasicSignatureValidator;
import de.governikus.csl.validation.SignatureValidationAlgorithm;
import de.governikus.csl.validation.SignatureValidationInitializer;
import de.governikus.csl.validation.SignatureValidator;
import de.governikus.csl.validation.ValidationCriterion;
import de.governikus.csl.validation.context.SignatureValidationContext;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureValidatorImpl<SOTYPE extends Signature, SORESULT extends SignatureValidationResult, CONTEXT extends SignatureValidationContext>
implements SignatureValidator<SOTYPE, SORESULT, CONTEXT> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignatureValidatorImpl.class);
    private SignatureValidationInitializer<SOTYPE, SORESULT> plugin;
    private SOTYPE signature;
    private CONTEXT context;
    private List<ValidationCriterion<? super SOTYPE, ? super SORESULT, ? super CONTEXT>> customCriteria = new ArrayList<ValidationCriterion<? super SOTYPE, ? super SORESULT, ? super CONTEXT>>();

    public SignatureValidatorImpl(SignatureValidationInitializer<SOTYPE, SORESULT> plugin, SOTYPE signature, CONTEXT context) {
        this.plugin = plugin;
        this.signature = signature;
        this.context = context;
    }

    private SORESULT validateSignature(SOTYPE signature, CONTEXT context) {
        Configuration configuration = ((SignatureValidationContext)context).getConfiguration();
        return this.validateSignature(signature, context, configuration.getBasicCriterias());
    }

    private SORESULT validateSignature(SOTYPE signature, CONTEXT context, List<ValidationCriterion<? super Signature, ? super SignatureValidationResult, ? super SignatureValidationContext>> basicCriteria) {
        SignatureValidationAlgorithm<SOTYPE, SORESULT, CONTEXT> validator = this.selectSignatureAlgorithm(signature, (SignatureValidationContext)context, basicCriteria);
        SORESULT sr = validator.validate(signature, context);
        if (sr != null && sr.getBestSignatureTime() == null) {
            TypedDate bestSigningTime = ((SignatureValidationContext)context).getBestSigningTime();
            sr.setBestSignatureTime(bestSigningTime.getDate());
            sr.setBestSignatureTimeType(bestSigningTime.getType());
        }
        return sr;
    }

    private SignatureValidationAlgorithm<SOTYPE, SORESULT, CONTEXT> selectSignatureAlgorithm(SOTYPE signature, SignatureValidationContext context, List<ValidationCriterion<? super Signature, ? super SignatureValidationResult, ? super SignatureValidationContext>> basicCriteria) {
        return new ETSIBasicSignatureValidator<SOTYPE, SORESULT, CONTEXT>(basicCriteria, this.customCriteria, this.plugin);
    }

    public void setCustomCriteria(List<ValidationCriterion<? super SOTYPE, ? super SORESULT, ? super CONTEXT>> customCriteria) {
        if (this.customCriteria == null) {
            this.customCriteria = new ArrayList<ValidationCriterion<? super SOTYPE, ? super SORESULT, ? super CONTEXT>>();
        }
        this.customCriteria.addAll(customCriteria);
    }

    @Override
    public SORESULT validateSignature() {
        return this.validateSignature(this.signature, this.context);
    }

    @Override
    public CONTEXT getContext() {
        return this.context;
    }
}

