/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation;

import de.governikus.csl.certStore.CertStore;
import de.governikus.csl.certStore.CertStoreResponse;
import de.governikus.csl.certStore.ListCertStore;
import de.governikus.csl.core.impl.SignatureValidationDataAttachmentImpl;
import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.ResourceUtil;
import de.governikus.csl.uom.jcebase.X509CertificateBaseFacade;
import de.governikus.csl.uom.validate.InformationSource;
import de.governikus.csl.utils.CryptoProviderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SigGCACertStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(SigGCACertStore.class);
    private static final SigGCACertStore INSTANCE = new SigGCACertStore();
    private CertStore aes_certs;
    private CertStore qes_certs;

    private SigGCACertStore() {
    }

    public static synchronized SigGCACertStore getInstance() throws CoreException {
        if (!INSTANCE.isInit()) {
            INSTANCE.init();
        }
        return INSTANCE;
    }

    private void init() throws CoreException {
        LOGGER.info("Initializing SigG-CA-CertStore");
        try {
            this.aes_certs = this.load("issuerAdvanced.p12", "123456".toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
            throw new CoreException("Can't load advanced SigG certificate store", (Throwable)e);
        }
        try {
            this.qes_certs = this.load("issuerQualified.p12", "123456".toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
            throw new CoreException("Can't load qualified SigG certificate store", (Throwable)e);
        }
    }

    private boolean isInit() {
        return this.qes_certs != null && this.aes_certs != null;
    }

    private CertStore load(String name, char[] password) throws KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keyStore = CryptoProviderUtil.createKeyStore();
        try (InputStream is = ResourceUtil.getResourceAsStream((String)name);){
            keyStore.load(is, password);
        }
        HashSet<SignatureValidationDataAttachmentImpl> certs = new HashSet<SignatureValidationDataAttachmentImpl>();
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            Certificate[] certificateChain;
            String nextElement = aliases.nextElement();
            X509Certificate certificate = (X509Certificate)keyStore.getCertificate(nextElement);
            if (certificate != null) {
                certs.add(new SignatureValidationDataAttachmentImpl((Object)certificate));
            }
            if ((certificateChain = keyStore.getCertificateChain(nextElement)) == null) continue;
            for (Certificate c : certificateChain) {
                certs.add(new SignatureValidationDataAttachmentImpl((Object)((X509Certificate)c)));
            }
        }
        return new ListCertStore(certs, InformationSource.FILE);
    }

    private boolean isIssuerInCertStore(X509CertificateBaseFacade<?> cert, CertStore certStore) {
        CertStoreResponse signingCertificates = certStore.getSigningCertificates(cert, new Date());
        if (signingCertificates == null) {
            return false;
        }
        List matchingCertificates = signingCertificates.getMatchingCertificates();
        return matchingCertificates != null && !matchingCertificates.isEmpty();
    }

    public boolean isQualifiedSigGCertificate(X509CertificateBaseFacade<?> cert) {
        return this.isIssuerInCertStore(cert, this.qes_certs);
    }

    public boolean isAdvancedSigGCertificate(X509CertificateBaseFacade<?> cert) {
        return this.isIssuerInCertStore(cert, this.aes_certs);
    }
}

