/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.governikus.csl.uom.validate.commons.OCSPReference;
import de.governikus.csl.utils.CryptoProviderUtil;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Date;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.RespID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPReferenceImpl
implements OCSPReference {
    private static final Logger LOGGER = LoggerFactory.getLogger(OCSPReferenceImpl.class);
    private DigestAlgorithm digestAlgorithm;
    private byte[] digestValue;
    private X500Name name;
    private Date productionDate;

    public OCSPReferenceImpl(DigestAlgorithm digestAlgorithm, byte[] digestValue, X500Name ldapName, Date productionDate) {
        this.digestAlgorithm = digestAlgorithm;
        this.digestValue = digestValue;
        this.name = ldapName;
        this.productionDate = productionDate;
    }

    public boolean isReferenced(OCSPResp ocsp) {
        X500Name responderName;
        BasicOCSPResp basicResp = null;
        try {
            Object responseObject = ocsp.getResponseObject();
            if (responseObject != null) {
                basicResp = (BasicOCSPResp)responseObject;
            }
        }
        catch (OCSPException e1) {
            LOGGER.error("Couldn't get ocsp response", (Throwable)e1);
            return false;
        }
        if (basicResp == null) {
            LOGGER.debug("OCSP response does not contain a response object");
            return false;
        }
        Date producedAt = basicResp.getProducedAt();
        if (producedAt != null && this.productionDate != null && !producedAt.equals(this.productionDate)) {
            return false;
        }
        RespID responder = basicResp.getResponderId();
        if (responder != null && (responderName = responder.toASN1Primitive().getName()) != null && this.name != null && !responderName.equals((Object)this.name)) {
            return false;
        }
        DigestAlgorithm da = this.digestAlgorithm;
        try {
            byte[] toDigest = ocsp.getEncoded();
            MessageDigest md = CryptoProviderUtil.getMessageDigestInstance((String)da.getJCAName());
            md.update(toDigest);
            byte[] digest = md.digest();
            return MessageDigest.isEqual(this.digestValue, digest);
        }
        catch (IOException | NoSuchAlgorithmException | NoSuchProviderException e) {
            LOGGER.error("Error during comparing of ocsp value digests", (Throwable)e);
            return false;
        }
    }
}

