/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation;

import de.governikus.csl.core.impl.DetachedSignedData;
import de.governikus.csl.request.ValidationOptions;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.DetachedContentCallback;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.core.impl.SimpleSignedData;
import de.governikus.csl.uom.docs.BasenameMappingDetachedContentCallback;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.uom.validate.PolicyEvaluationState;
import de.governikus.csl.uom.validate.PolicyOrigin;
import de.governikus.csl.uom.validate.TimestampQuality;
import de.governikus.csl.uom.validate.ValidatePolicy;
import de.governikus.csl.uom.validate.ValidityModelDeterminationResult;
import de.governikus.csl.uom.validate.commons.ObjectToValidate;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.uom.validate.commons.Timestamp;
import de.governikus.csl.utils.CslTimingUtil;
import de.governikus.csl.validate.svp.AdESSignatureValidationResult;
import de.governikus.csl.validate.svp.ArchiveTimestampValidationResult;
import de.governikus.csl.validate.svp.ERSValidationResult;
import de.governikus.csl.validate.svp.EvidenceRecordValidationResult;
import de.governikus.csl.validate.svp.ObjectValidationResult;
import de.governikus.csl.validate.svp.PublicKeyCertificateValidationResult;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.csl.validate.svp.TimestampValidationResult;
import de.governikus.csl.validate.svp.TypedDate;
import de.governikus.csl.validation.BestPOEDeterminator;
import de.governikus.csl.validation.Configuration;
import de.governikus.csl.validation.IncludedFileValidator;
import de.governikus.csl.validation.ObjectValidationCriterion;
import de.governikus.csl.validation.ObjectValidator;
import de.governikus.csl.validation.ResultInitializer;
import de.governikus.csl.validation.SignatureValidator;
import de.governikus.csl.validation.TypedValidatePlugin;
import de.governikus.csl.validation.context.DocumentValidationContext;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.dataExtractor.DataExtractor;
import de.governikus.csl.validation.policy.EvaluatedValidationPolicyType;
import de.governikus.csl.validation.policy.EvaluatingPolicyReferenceManager;
import de.governikus.csl.validation.policy.PolicyEvaluator;
import de.governikus.csl.validation.policy.PolicyProviderManager;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.validation.test.PrefetchingSignatureValidator;
import de.governikus.csl.validation.test.ValidationDocket;
import de.governikus.csl.validation.tsp.ArchiveTimestampResponseEntry;
import de.governikus.csl.validation.x509.CertChainResult;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleSignedObjectValidator<DOCTYPE extends ObjectToValidate<SOTYPE>, SOTYPE extends Signature, RESULT extends ObjectValidationResult, SORESULT extends SignatureValidationResult, CONTEXT extends SignatureValidationContext>
implements ObjectValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultipleSignedObjectValidator.class);
    protected DOCTYPE doc;
    protected DataExtractor<? super DOCTYPE, ? super RESULT> documentDataExtractor;
    protected ResultInitializer<RESULT, SORESULT> resultCreator;
    protected List<ObjectValidationCriterion<? super DOCTYPE, ? super RESULT>> documentValidators;
    protected TypedValidatePlugin<DOCTYPE, SOTYPE, RESULT, SORESULT, CONTEXT> plugin;
    private Configuration config;
    protected IncludedFileValidator requestProcessor;
    private Date validationDate;
    private EvaluatingPolicyReferenceManager policyManager;
    private boolean includePoliciesInResult;
    private ValidationPolicyType policyFromRequest;
    private List<String> signatureFileExtensionsAllowed = Arrays.asList("p7s", "pkcs7", "signature");

    public DOCTYPE getObjectToValidate() {
        return this.doc;
    }

    public MultipleSignedObjectValidator(TypedValidatePlugin<DOCTYPE, SOTYPE, RESULT, SORESULT, CONTEXT> documentPlugin, DOCTYPE parsedDocument, Configuration config, IncludedFileValidator requestProcessor) {
        this.resultCreator = documentPlugin.getResultInitializer();
        this.documentDataExtractor = documentPlugin.getDocumentDataExtractor();
        this.plugin = documentPlugin;
        this.doc = parsedDocument;
        this.config = config;
        this.requestProcessor = requestProcessor;
    }

    public RESULT validate(DOCTYPE document, DocumentValidationContext documentValidationContext) {
        List policyEntries;
        List signatures;
        this.configure(documentValidationContext);
        Map<Signature, ValidationDocket<Signature, SignatureValidationResult>> validationDockets = this.validateCertsAndTimestamps(document, documentValidationContext);
        ObjectValidationResult result = (ObjectValidationResult)this.resultCreator.createResultStructure((ObjectToValidate<?>)document);
        this.applyDocumentValidators(document, documentValidationContext, result);
        Instant sigValStart = null;
        if (CslTimingUtil.isTimingDebuggingEnabled()) {
            sigValStart = Instant.now();
        }
        if ((signatures = document.getSignatures()) != null) {
            List signatureValidationResults = result.getSignatureValidationResults();
            for (Signature signature : signatures) {
                SORESULT q = this.validateSignature(signature, validationDockets, documentValidationContext);
                signatureValidationResults.add(q);
            }
        }
        if (CslTimingUtil.isTimingDebuggingEnabled() && sigValStart != null) {
            LOGGER.debug("Signature validation for document {} took {} ms.", (Object)document.getName(), (Object)Duration.between(sigValStart, Instant.now()).toMillis());
        }
        if (this.documentDataExtractor != null) {
            this.documentDataExtractor.extractData(document, result);
        }
        this.validateIncludedFiles(document, result, documentValidationContext);
        if (this.includePoliciesInResult && (policyEntries = this.policyManager.getPolicyEntries()) != null) {
            result.getPolicyEntries().addAll(policyEntries);
        }
        return (RESULT)result;
    }

    private SORESULT validateSignature(SOTYPE signature, Map<Signature, ValidationDocket<Signature, SignatureValidationResult>> validationDockets, DocumentValidationContext documentValidationContext) {
        ValidationDocket signatureDocket = Optional.ofNullable(validationDockets).map(x -> (ValidationDocket)x.get(signature)).orElse(null);
        EvaluatedValidationPolicyType evaluatedPolicy = this.determinePolicy(signatureDocket);
        ValidationPolicyType policy = evaluatedPolicy.getPolicy();
        int policyRef = this.policyManager.addPolicy(evaluatedPolicy);
        TypedDate bestPOE = this.getBestPOE(signature, signatureDocket, policy);
        TypedDate bestAlgoTime = this.getBestAlgoTimes(signatureDocket, policy);
        SORESULT q = this.validateSignature(signature, documentValidationContext, bestPOE, bestAlgoTime, policy);
        q.setPolicyReference(policyRef);
        if (AdESSignatureValidationResult.class.isAssignableFrom(q.getClass())) {
            this.setPolicyRefOnCounterSignature((AdESSignatureValidationResult)q, policyRef);
        }
        if (signatureDocket != null) {
            this.transferTimestampResults(q, signatureDocket, policy);
        }
        return q;
    }

    private void setPolicyRefOnCounterSignature(AdESSignatureValidationResult sigValidationResult, int policyRef) {
        for (SignatureValidationResult csResult : sigValidationResult.getCounterSignatureValidationResults()) {
            csResult.setPolicyReference(policyRef);
            if (!AdESSignatureValidationResult.class.isAssignableFrom(csResult.getClass())) continue;
            this.setPolicyRefOnCounterSignature((AdESSignatureValidationResult)csResult, policyRef);
        }
    }

    private TypedDate getBestAlgoTimes(ValidationDocket<Signature, SignatureValidationResult> signatureDocket, ValidationPolicyType policy) {
        List<TypedDate> possibleAlgValTimes = null;
        if (signatureDocket != null) {
            possibleAlgValTimes = signatureDocket.getPossibleAlgValidationTimes();
        }
        if (possibleAlgValTimes == null) {
            possibleAlgValTimes = new ArrayList<TypedDate>();
            possibleAlgValTimes.add(SVPFactory.createTypedDate((Date)this.validationDate, (DateType)DateType.EXISTENCE));
        }
        return BestPOEDeterminator.getBestPOEForAlgorithmValidity(possibleAlgValTimes, (ValidatePolicy)policy);
    }

    private TypedDate getBestPOE(SOTYPE signature, ValidationDocket<Signature, SignatureValidationResult> signatureDocket, ValidationPolicyType policy) {
        TypedDate bestPOE = null;
        if (signatureDocket != null) {
            CertChainResult<PublicKeyCertificateValidationResult> signingCertificateValidationResult = signatureDocket.getSigningCertificateValidationResult();
            if (signingCertificateValidationResult != null) {
                bestPOE = signingCertificateValidationResult.getBestPOE();
            } else {
                List<TypedDate> possiblePOEs = signatureDocket.getPossiblePOEs();
                if (possiblePOEs != null && !possiblePOEs.isEmpty()) {
                    bestPOE = BestPOEDeterminator.getBestPOE(possiblePOEs, (ValidatePolicy)policy);
                }
            }
        }
        if (bestPOE == null) {
            bestPOE = signature.getSigningTime();
        }
        return bestPOE;
    }

    private EvaluatedValidationPolicyType determinePolicy(ValidationDocket<Signature, SignatureValidationResult> signatureDocket) {
        CertChainResult<PublicKeyCertificateValidationResult> signingCertificateValidationResult;
        if (signatureDocket != null && (signingCertificateValidationResult = signatureDocket.getSigningCertificateValidationResult()) != null) {
            return signingCertificateValidationResult.getPolicy();
        }
        PolicyProviderManager policyProviderManager = this.config.getPolicyProviderManager();
        if (this.policyFromRequest == null) {
            EvaluatedValidationPolicyType evalPol = new EvaluatedValidationPolicyType();
            evalPol.setPolicyOrigin(PolicyOrigin.AUTOMATIC_DETERMINATION);
            evalPol.setEvaluationState(PolicyEvaluationState.TRUSTED_POLICY);
            evalPol.setPolicy(policyProviderManager.getPolicyProvider().getAES_eIDAS_SigG());
            return evalPol;
        }
        return PolicyEvaluator.createEvaluatedPolicy((ValidationPolicyType)this.policyFromRequest, (PolicyOrigin)PolicyOrigin.REQUEST, (boolean)true, (PolicyProviderManager)policyProviderManager);
    }

    private void transferTimestampResults(SORESULT signatureResult, ValidationDocket<Signature, SignatureValidationResult> signatureDocket, ValidationPolicyType policy) {
        List<EvidenceRecordValidationResult> evidenceRecordValidationResults;
        List<TimestampValidationResult> contentTimestampValidationResults;
        List<ValidationDocket<Timestamp, TimestampValidationResult>> timestampValidationResults = signatureDocket.getTimestamps();
        if (timestampValidationResults != null && !timestampValidationResults.isEmpty()) {
            List signatureTimestampResults = signatureResult.getSignatureTimestampResults();
            timestampValidationResults.forEach(x -> signatureTimestampResults.add(x.getSignatureValidationResult()));
        }
        if ((contentTimestampValidationResults = signatureDocket.getContentTimestampValidationResults()) != null && signatureResult instanceof AdESSignatureValidationResult) {
            ((AdESSignatureValidationResult)signatureResult).getSignedDataTimestampResults().addAll(contentTimestampValidationResults);
        }
        if ((evidenceRecordValidationResults = signatureDocket.getEvidenceRecordValidationResults()) != null && signatureResult instanceof AdESSignatureValidationResult) {
            ((AdESSignatureValidationResult)signatureResult).getEvidenceRecordValidationResults().addAll(evidenceRecordValidationResults);
        } else if (evidenceRecordValidationResults != null && signatureResult instanceof ERSValidationResult) {
            ((ERSValidationResult)signatureResult).getEvidenceRecordValidationResults().addAll(evidenceRecordValidationResults);
        }
        List<ArchiveTimestampResponseEntry> archiveTimestampValidationResults = signatureDocket.getArchiveTimestampValidationResults();
        if (archiveTimestampValidationResults != null && signatureResult instanceof AdESSignatureValidationResult) {
            List archiveTimestampValidationResults2 = ((AdESSignatureValidationResult)signatureResult).getArchiveTimestampValidationResults();
            for (ArchiveTimestampResponseEntry entry : archiveTimestampValidationResults) {
                ArchiveTimestampValidationResult archiveTimestampValidationResult = entry.getValidationResult();
                TimestampQuality timestampQuality = archiveTimestampValidationResult.getTimestampQuality();
                DateType minimalRequiredAlgPOELevel = policy.getMinimalRequiredAlgPOELevel();
                if (timestampQuality == null || minimalRequiredAlgPOELevel.compareTo((Enum)DateType.fromTimestampQuality((TimestampQuality)timestampQuality)) > 0) {
                    archiveTimestampValidationResult.setUsageHint(SVPFactory.createMessageCode((String)"archive_timestamp_quality_too_low"));
                }
                archiveTimestampValidationResults2.add(archiveTimestampValidationResult);
            }
        }
    }

    private void applyDocumentValidators(DOCTYPE document, DocumentValidationContext documentValidationContext, RESULT result) {
        if (this.documentValidators != null) {
            for (ObjectValidationCriterion<DOCTYPE, RESULT> crit : this.documentValidators) {
                if (!crit.isApplicable(document, documentValidationContext)) continue;
                crit.validate(document, result, documentValidationContext);
            }
        }
    }

    private Map<Signature, ValidationDocket<Signature, SignatureValidationResult>> validateCertsAndTimestamps(DOCTYPE document, DocumentValidationContext documentValidationContext) {
        Map<Signature, ValidationDocket<Signature, SignatureValidationResult>> validationDockets;
        Instant prefetchingStart = null;
        if (CslTimingUtil.isTimingDebuggingEnabled()) {
            prefetchingStart = Instant.now();
        }
        if ((validationDockets = documentValidationContext.getValidationDockets()) == null) {
            PrefetchingSignatureValidator psv = new PrefetchingSignatureValidator(this.validationDate, documentValidationContext, this.policyManager, this.config, this.policyFromRequest);
            validationDockets = psv.process((ObjectToValidate<?>)document);
            documentValidationContext.setValidationDockets(validationDockets);
        }
        if (CslTimingUtil.isTimingDebuggingEnabled() && prefetchingStart != null) {
            LOGGER.debug("Prefetching for document {} took {} ms.", (Object)document.getName(), (Object)Duration.between(prefetchingStart, Instant.now()).toMillis());
        }
        return validationDockets;
    }

    private void configure(DocumentValidationContext documentValidationContext) {
        ValidationOptions options = documentValidationContext.getOptions();
        if (options != null) {
            this.validationDate = options.getValidationDate();
            this.policyFromRequest = options.getPolicy();
        }
        if (this.validationDate == null) {
            this.validationDate = new Date();
        }
        EvaluatingPolicyReferenceManager newPolicyManager = documentValidationContext.getPolicyManager();
        PolicyProviderManager policyProviderManager = this.config.getPolicyProviderManager();
        if (newPolicyManager == null) {
            newPolicyManager = new EvaluatingPolicyReferenceManager(policyProviderManager);
            documentValidationContext.setPolicyManager(newPolicyManager);
            this.includePoliciesInResult = true;
        } else {
            this.includePoliciesInResult = false;
        }
        this.policyManager = newPolicyManager;
    }

    private void validateIncludedFiles(DOCTYPE document, RESULT result, DocumentValidationContext documentValidationContext) {
        int maxIncludedFileRecursions;
        ValidationOptions options = documentValidationContext.getOptions();
        List includedFilesToValidate = document.getIncludedFilesToValidate();
        if (includedFilesToValidate == null || includedFilesToValidate.isEmpty()) {
            return;
        }
        int currentIncludedFilesRecursionLevel = documentValidationContext.getIncludedFileRecursionLevel();
        if (currentIncludedFilesRecursionLevel < (maxIncludedFileRecursions = Integer.min(this.config.getMaxIncludedFileRecursions(), options.getMaxRecursiveValidationStepsForIncludedFiles()))) {
            List<SignedData> signaturesToValidate = this.mapContentsToDetachedSignatures(includedFilesToValidate, documentValidationContext);
            List includedFilesValidationResults = result.getIncludedFileValidationResults();
            for (SignedData includedFile : signaturesToValidate) {
                ObjectValidationResult contentFileValidationResult;
                Document signature;
                block7: {
                    signature = includedFile.getSignature();
                    DocumentValidationContext context = new DocumentValidationContext();
                    context.setOptions(options);
                    context.setPolicyManager(this.policyManager);
                    context.setIncludedFileRecursionLevel(currentIncludedFilesRecursionLevel + 1);
                    contentFileValidationResult = null;
                    try {
                        LOGGER.debug("Found included file {}", (Object)signature.getName());
                        contentFileValidationResult = this.requestProcessor.validate(includedFile, context);
                    }
                    catch (CoreException e) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Can't validate included file {}", (Object)signature.getName());
                        }
                        if (!LOGGER.isTraceEnabled()) break block7;
                        LOGGER.trace("Exception: ", (Throwable)e);
                    }
                }
                if (contentFileValidationResult == null) {
                    contentFileValidationResult = SVPFactory.createObjectValidationResult((String)"UNKNOWN");
                    contentFileValidationResult.setObjectName(signature.getName());
                }
                includedFilesValidationResults.add(contentFileValidationResult);
            }
        }
    }

    List<SignedData> mapContentsToDetachedSignatures(List<Document> documents, DocumentValidationContext documentValidationContext) {
        ArrayList<SignedData> result = new ArrayList<SignedData>();
        if (documents.isEmpty()) {
            return result;
        }
        if (documents.size() == 1) {
            result.add((SignedData)new SimpleSignedData(documents.get(0)));
            return result;
        }
        DetachedContentCallback detachedContentCallback = documentValidationContext.getOptions().getDetachedContentCallback();
        if (detachedContentCallback instanceof BasenameMappingDetachedContentCallback) {
            this.signatureFileExtensionsAllowed = ((BasenameMappingDetachedContentCallback)detachedContentCallback).getSignatureFileExtensionsAllowed();
        }
        List signatureDocs = documents.stream().filter(this::hasSignatureFileExtension).collect(Collectors.toList());
        HashSet<Document> consumedDocs = new HashSet<Document>();
        HashMap<Document, ArrayList<DetachedSignedData>> contentSigMap = new HashMap<Document, ArrayList<DetachedSignedData>>();
        for (Document sigDoc : signatureDocs) {
            List retrievedDetachedContent = detachedContentCallback.retrieveDetachedContent(sigDoc, documents);
            if (retrievedDetachedContent.isEmpty()) {
                result.add((SignedData)new SimpleSignedData(sigDoc));
            } else {
                Document contentDoc = (Document)retrievedDetachedContent.get(0);
                DetachedSignedData detachedSignedData = new DetachedSignedData(sigDoc, contentDoc);
                contentSigMap.putIfAbsent(contentDoc, new ArrayList<DetachedSignedData>(Arrays.asList(detachedSignedData)));
                List sameContentSigs = (List)contentSigMap.get(contentDoc);
                if (sameContentSigs != null) {
                    boolean addFlag = false;
                    for (DetachedSignedData otherSignatureWithSameContent : sameContentSigs) {
                        if (otherSignatureWithSameContent.equals(detachedSignedData)) continue;
                        otherSignatureWithSameContent.addOnSameContent(detachedSignedData);
                        detachedSignedData.addOnSameContent(otherSignatureWithSameContent);
                        addFlag = true;
                    }
                    if (addFlag) {
                        sameContentSigs.add(detachedSignedData);
                    }
                }
                result.add((SignedData)detachedSignedData);
                consumedDocs.add(contentDoc);
            }
            consumedDocs.add(sigDoc);
        }
        if (consumedDocs.size() != documents.size()) {
            ArrayList<Document> docList = new ArrayList<Document>(documents);
            docList.removeAll(consumedDocs);
            docList.forEach(x -> result.add((SignedData)new SimpleSignedData(x)));
        }
        return result;
    }

    private boolean hasSignatureFileExtension(Document document) {
        int extPos = document.getName().lastIndexOf(".");
        return extPos > 0 && this.signatureFileExtensionsAllowed.contains(document.getName().substring(extPos + 1).toLowerCase());
    }

    protected SORESULT validateSignature(SOTYPE signature, DocumentValidationContext documentValidationContext, TypedDate poe, TypedDate bestAlgoTime, ValidationPolicyType policy) {
        PublicKeyCertificateValidationResult x509ValidationResult;
        TypedDate bestPOE = poe;
        if (poe == null) {
            bestPOE = SVPFactory.createTypedDate((Date)this.validationDate, (DateType)DateType.EXISTENCE);
        }
        ValidityModelDeterminationResult validityModel = null;
        Map<X509Certificate, PublicKeyCertificateValidationResult> prefetchedCertificateValidationResults = documentValidationContext.getPrefetchedCertificateValidationResults();
        if (prefetchedCertificateValidationResults != null && (x509ValidationResult = prefetchedCertificateValidationResults.get(signature.getSigningCertificate())) != null) {
            validityModel = x509ValidationResult.getValidityModel();
        }
        if (validityModel != null && validityModel.isEnforceUsageOfClaimedSigningTime() && bestPOE.getType() != DateType.CLAIMED_SIGNING_TIME && signature.getSigningTime() != null) {
            bestPOE = signature.getSigningTime();
        }
        SignatureValidator<?, SORESULT, CONTEXT> signatureValidator = this.plugin.createSignatureValidator(signature, this.validationDate, policy, documentValidationContext);
        CONTEXT context = signatureValidator.getContext();
        ((SignatureValidationContext)context).setBestSigningTime(bestPOE);
        ((SignatureValidationContext)context).setBestAlgValidationTime(bestAlgoTime);
        return signatureValidator.validateSignature();
    }

    public List<ObjectValidationCriterion<? super DOCTYPE, ? super RESULT>> getDocumentValidators() {
        return this.documentValidators;
    }

    public void setDocumentValidators(List<ObjectValidationCriterion<? super DOCTYPE, ? super RESULT>> documentValidators) {
        this.documentValidators = documentValidators;
    }

    @Override
    public ObjectValidationResult validate(DocumentValidationContext documentValidationContext) {
        return this.validate(this.doc, documentValidationContext);
    }
}

