/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation;

import de.governikus.csl.cvs.client.CertificateValidationRequestBuilder;
import de.governikus.csl.cvs.client.CvsClientRequestError;
import de.governikus.csl.cvs.client.DynamicCVSClient;
import de.governikus.csl.cvs.client.model.AttributeCertEntry;
import de.governikus.csl.cvs.client.model.AttributeCertificateValidationRequest;
import de.governikus.csl.cvs.client.model.AttributeCertificateValidationResponse;
import de.governikus.csl.cvs.client.model.CertEntry;
import de.governikus.csl.cvs.client.model.CertificateValidationRequest;
import de.governikus.csl.cvs.client.model.CertificateValidationRequestBase;
import de.governikus.csl.cvs.client.model.CertificateValidationResponse;
import de.governikus.csl.cvs.client.model.CertificateValidationResponseBase;
import de.governikus.csl.cvs.client.model.CompoundCertificateValidationRequest;
import de.governikus.csl.cvs.client.model.CompoundCertificateValidationResponse;
import de.governikus.csl.cvs.client.model.ResponseEntry;
import de.governikus.csl.request.ValidationOptions;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.jcebase.X509AttributeCertificateImpl;
import de.governikus.csl.uom.jcebase.X509CertificateFacade;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.uom.validate.commons.ValidationData;
import de.governikus.csl.validate.svp.AttributeCertificateValidationResult;
import de.governikus.csl.validate.svp.CertificateValidationResult;
import de.governikus.csl.validate.svp.EvaluatedPolicyEntry;
import de.governikus.csl.validate.svp.ForwardedCVSInfo;
import de.governikus.csl.validate.svp.PublicKeyCertificateValidationResult;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.csl.validate.svp.TimestampValidationResult;
import de.governikus.csl.validate.svp.TypedDate;
import de.governikus.csl.validate.svp.ValidationMessageCode;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.attributecert.AttributeCertificateSignature;
import de.governikus.csl.validation.context.CertificateValidationContext;
import de.governikus.csl.validation.policy.EvaluatedValidationPolicyType;
import de.governikus.csl.validation.policy.SimplePolicyReferenceManager;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.validation.test.ValidationDocket;
import de.governikus.csl.validation.tsp.TimestampedObject;
import de.governikus.csl.validation.x509.CertChainResult;
import de.governikus.csl.validation.x509.CertificateValidator;
import de.governikus.csl.validation.x509.X509Data;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardingCertificateValidator
implements CertificateValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ForwardingCertificateValidator.class);
    private static final String RESPONSE_WITHOUT_RESULT = "Received cvs response contains no validation result, result will be INDETERMINATE with TRY_LATER.";
    private static final String NO_RESPONSE = "Received no cvs response, result will be INDETERMINATE with TRY_LATER.";
    private static final String NO_ERROR_INFO = " No detailed error information available.";
    private static final String ERROR_INFO = " CVS client threw: \"{0}\"";
    private DynamicCVSClient cvs;

    public ForwardingCertificateValidator(DynamicCVSClient cvs) {
        this.cvs = cvs;
    }

    private <S extends Signature, R extends SignatureValidationResult> CompoundCertificateValidationRequest buildRequest(List<ValidationDocket<S, R>> validationDockets, Map<Integer, ValidationDocket<S, R>> certificateMapping, Map<Integer, ValidationDocket<S, R>> attributeCertificateMapping, ValidationPolicyType policyFromRequest, ValidationData validationData) {
        CompoundCertificateValidationRequest request = new CompoundCertificateValidationRequest();
        SimplePolicyReferenceManager policyManager = new SimplePolicyReferenceManager();
        int policyRef = -1;
        if (policyFromRequest != null) {
            policyRef = policyManager.addPolicy(policyFromRequest);
        }
        int certCtr = 0;
        int attribCertCtr = 0;
        List certEntries = request.getCertEntries();
        List attributeCertEntries = request.getAttributeCertificates();
        HashMap<X509CertificateImpl, Integer> certIDMap = new HashMap<X509CertificateImpl, Integer>();
        Set attachedCertificates = null;
        Set attachedCRLs = null;
        Set attachedOCSPs = null;
        for (ValidationDocket<S, R> docket : validationDockets) {
            Set<AttributeCertificate> attributeCertificates;
            Object signature = docket.getSignature();
            List<TimestampValidationResult> contentTimestampValidationResults = docket.getContentTimestampValidationResults();
            X509CertificateImpl cert = docket.getSigningCertificate();
            if (cert != null) {
                CertEntry entry = new CertEntry();
                if (signature instanceof TimestampedObject) {
                    TimestampedObject timestampedObject = (TimestampedObject)((Object)signature);
                    entry.setEuQc(timestampedObject.hasEUQCStatement());
                }
                entry.setId(++certCtr);
                entry.getPossiblePOE().addAll(docket.getPossiblePOEs());
                List<TypedDate> possibleAlgValidationTimes = docket.getPossibleAlgValidationTimes();
                if (possibleAlgValidationTimes != null) {
                    entry.getPossibleAlgValidationTimes().addAll(possibleAlgValidationTimes);
                }
                if (contentTimestampValidationResults != null) {
                    entry.getContentTimestampValidationResults().addAll(contentTimestampValidationResults);
                }
                entry.setSignatureType(signature.getType());
                if (policyRef >= 0) {
                    entry.setPolicyReference(Integer.valueOf(policyRef));
                }
                certificateMapping.put(certCtr, docket);
                certIDMap.put(cert, certCtr);
                try {
                    entry.setCertificate(cert.getEncoded());
                    certEntries.add(entry);
                }
                catch (CertificateEncodingException ex) {
                    LOGGER.warn("Failed to encode certificates.", (Throwable)ex);
                }
            }
            if ((attributeCertificates = docket.getAttributeCertificates()) != null) {
                for (AttributeCertificate attribCert : attributeCertificates) {
                    AttributeCertEntry acEntry = new AttributeCertEntry();
                    acEntry.setId(++attribCertCtr);
                    acEntry.setBaseCertID(Integer.valueOf(certCtr));
                    acEntry.getPossiblePOE().addAll(docket.getPossiblePOEs());
                    if (contentTimestampValidationResults != null) {
                        acEntry.getContentTimestampValidationResults().addAll(contentTimestampValidationResults);
                    }
                    if (policyRef >= 0) {
                        acEntry.setPolicyReference(Integer.valueOf(policyRef));
                    }
                    attributeCertificateMapping.put(attribCertCtr, docket);
                    try {
                        acEntry.setCertificate(attribCert.getEncoded());
                        attributeCertEntries.add(acEntry);
                    }
                    catch (IOException ex) {
                        LOGGER.warn("Failed to encode attribute certificates.", (Throwable)ex);
                    }
                }
            }
            if (signature == null) continue;
            attachedCertificates = this.addIfExists(attachedCertificates, signature.getAttachedCertificates());
            attachedCRLs = this.addIfExists(attachedCRLs, signature.getAttachedCRLs());
            attachedOCSPs = this.addIfExists(attachedOCSPs, signature.getAttachedOCSPValues());
        }
        if (validationData != null) {
            attachedCertificates = this.addIfExists(attachedCertificates, validationData.getCertificates());
            attachedCRLs = this.addIfExists(attachedCRLs, validationData.getCRLs());
            attachedOCSPs = this.addIfExists(attachedOCSPs, validationData.getOCSPValues());
        }
        if (attributeCertEntries.isEmpty() && certEntries.isEmpty()) {
            return null;
        }
        List policyEntries = policyManager.getPolicyEntries();
        if (policyEntries != null && !policyEntries.isEmpty()) {
            request.getPolicies().addAll(policyEntries);
        }
        CertificateValidationRequestBuilder.extendRequestWithAttachedValidationData((CertificateValidationRequestBase)request, attachedCertificates, attachedCRLs, attachedOCSPs);
        return request;
    }

    private <T> Set<T> addIfExists(Set<T> base, Collection<T> toBeAdded) {
        if (toBeAdded == null || toBeAdded.isEmpty()) {
            return base;
        }
        if (base == null) {
            base = new HashSet<T>();
        }
        base.addAll(toBeAdded);
        return base;
    }

    @Override
    public CertChainResult<PublicKeyCertificateValidationResult> validate(X509Data signature, CertificateValidationContext context, List<TypedDate> possiblePOEs, List<TypedDate> potentialAlgValidationTimes) {
        try {
            CertificateValidationRequest cvr = new CertificateValidationRequest();
            cvr.setCertificate(((X509CertificateImpl)signature.getCert()).getEncoded());
            cvr.setPolicy(context.getPolicy());
            cvr.setSignatureType(context.getSignedObjectTypeContext());
            List<TimestampValidationResult> prefetchedContentTimestampValidationResults = context.getPrefetchedContentTimestampValidationResults();
            if (prefetchedContentTimestampValidationResults != null) {
                cvr.getContentTimestampValidationResults().addAll(prefetchedContentTimestampValidationResults);
            }
            if (possiblePOEs != null) {
                cvr.getPossiblePOE().addAll(possiblePOEs);
            }
            if (potentialAlgValidationTimes != null) {
                cvr.getPossibleAlgValidationTimes().addAll(potentialAlgValidationTimes);
            }
            CertificateValidationRequestBuilder.extendRequestWithAttachedValidationData((CertificateValidationRequestBase)cvr, (Collection)signature.getAttachedCertificates(), (Collection)signature.getAttachedCRLs(), (Collection)signature.getAttachedOCSPValues());
            CertificateValidationResponse response = this.cvs.validate(cvr);
            return this.buildResponse(response, CertificateValidationResponse::getCertificateValidationResult, CertificateValidationResponse::getPolicy, () -> {
                PublicKeyCertificateValidationResult x = new PublicKeyCertificateValidationResult();
                x.setCert((X509CertificateImpl)signature.getCert());
                return x;
            });
        }
        catch (CertificateEncodingException e) {
            LOGGER.error("Can't validate certificate.", (Throwable)e);
            return null;
        }
    }

    private <T extends CertificateValidationResult, R extends CertificateValidationResponseBase> CertChainResult<T> buildResponse(R response, Function<R, T> validationResult, Function<R, EvaluatedValidationPolicyType> policy, Supplier<T> factory) {
        ValidationResult result;
        CertificateValidationResult validationResponse = null;
        CvsClientRequestError requestError = this.cvs.getError();
        if (response != null) {
            validationResponse = (CertificateValidationResult)validationResult.apply(response);
            if (validationResponse == null) {
                ValidationResult result2;
                if (requestError != null) {
                    LOGGER.trace("Received cvs response contains no validation result, result will be INDETERMINATE with TRY_LATER. CVS client threw: \"{0}\"", (Object)requestError.getMessage());
                    result2 = SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.TRY_LATER, (ValidationMessageCode)SVPFactory.createMessageCode((String)"cvs_client_error", (Object[])new Object[]{this.cvs.getUrl(), requestError.getType().name(), requestError.getMessage()}));
                } else {
                    LOGGER.trace("Received cvs response contains no validation result, result will be INDETERMINATE with TRY_LATER. No detailed error information available.");
                    result2 = SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.TRY_LATER, (ValidationMessageCode)SVPFactory.createMessageCode((String)"cvs_not_responding", (Object[])new Object[]{this.cvs.getUrl().toString()}));
                }
                validationResponse = (CertificateValidationResult)factory.get();
                validationResponse.setValidityCheck(result2);
                return new CertChainResult<CertificateValidationResult>(validationResponse, null, policy.apply(response));
            }
            validationResponse.setCvsResponseSignatureValidationResult(response.getCvsSignatureValidationResult());
            validationResponse.setCvsForwardedResponseSignatureValidationResult(response.getForwardedCVSSignatureValidationResult());
            if (response instanceof CertificateValidationResponse) {
                validationResponse.setForwardedCVSInfo(ForwardingCertificateValidator.cloneForwardingInformation((CertificateValidationResponse)response));
            }
            TypedDate bestPOE = SVPFactory.createTypedDate((Date)validationResponse.getBestSignatureTime(), (DateType)validationResponse.getBestSignatureTimeType());
            return new CertChainResult<CertificateValidationResult>(validationResponse, bestPOE, policy.apply(response));
        }
        if (requestError != null) {
            LOGGER.trace("Received no cvs response, result will be INDETERMINATE with TRY_LATER. CVS client threw: \"{0}\"", (Object)requestError.getMessage());
            result = SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.TRY_LATER, (ValidationMessageCode)SVPFactory.createMessageCode((String)"cvs_client_error", (Object[])new Object[]{this.cvs.getUrl().toString(), requestError.getType().name(), requestError.getMessage()}));
        } else {
            LOGGER.trace("Received no cvs response, result will be INDETERMINATE with TRY_LATER. No detailed error information available.");
            result = SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.TRY_LATER, (ValidationMessageCode)SVPFactory.createMessageCode((String)"cvs_not_responding", (Object[])new Object[]{this.cvs.getUrl().toString()}));
        }
        validationResponse = (CertificateValidationResult)factory.get();
        validationResponse.setValidityCheck(result);
        return new CertChainResult<CertificateValidationResult>(validationResponse, null, null);
    }

    private static ForwardedCVSInfo cloneForwardingInformation(@NonNull CertificateValidationResponse response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        if (response.getForwardedCVSInfo() == null) {
            return null;
        }
        return (ForwardedCVSInfo)response.getForwardedCVSInfo().clone();
    }

    @Override
    public CertChainResult<AttributeCertificateValidationResult> validate(AttributeCertificateSignature signature, CertificateValidationContext context, List<TypedDate> possiblePOEs, List<TypedDate> potentialAlgValidationTimes) {
        TypedDate signingTime;
        X509AttributeCertificateImpl ac = (X509AttributeCertificateImpl)signature.getCert();
        X509CertificateFacade signingCertificate = signature.getBaseCertificate();
        byte[] certBytes = null;
        byte[] baseCertificateBytes = null;
        AttributeCertificateValidationRequest cvr = new AttributeCertificateValidationRequest();
        cvr.setPolicy(context.getPolicy());
        List<TimestampValidationResult> prefetchedContentTimestampValidationResults = context.getPrefetchedContentTimestampValidationResults();
        if (prefetchedContentTimestampValidationResults != null) {
            cvr.getContentTimestampValidationResults().addAll(prefetchedContentTimestampValidationResults);
        }
        CertificateValidationRequestBuilder.extendRequestWithAttachedValidationData((CertificateValidationRequestBase)cvr, (Collection)signature.getAttachedCertificates(), (Collection)signature.getAttachedCRLs(), (Collection)signature.getAttachedOCSPValues());
        try {
            certBytes = ac.getEncoded();
            baseCertificateBytes = signingCertificate.getEncoded();
        }
        catch (CertificateEncodingException e) {
            LOGGER.warn("Can't serialize certificate", (Throwable)e);
            return null;
        }
        cvr.setAttributeCertificate(certBytes);
        cvr.setBaseCertificate(baseCertificateBytes);
        if (possiblePOEs != null) {
            cvr.getPossiblePOE().addAll(possiblePOEs);
        }
        if (potentialAlgValidationTimes != null) {
            cvr.getPossibleAlgValidationTimes().addAll(potentialAlgValidationTimes);
        }
        if ((signingTime = signature.getSigningTime()) != null) {
            cvr.getPossiblePOE().add(signingTime);
        }
        AttributeCertificateValidationResponse validationResult = this.cvs.validateAttributeCertificate(cvr);
        return this.buildResponse(validationResult, AttributeCertificateValidationResponse::getAttributeCertificateValidationResult, AttributeCertificateValidationResponse::getPolicy, () -> {
            AttributeCertificateValidationResult x = new AttributeCertificateValidationResult();
            x.setCert(ac);
            return x;
        });
    }

    @Override
    public <S extends Signature, R extends SignatureValidationResult> void prefetchCertificateValidation(List<ValidationDocket<S, R>> validationDockets, ValidationPolicyType policyFromRequest, ValidationOptions options) {
        CompoundCertificateValidationRequest request;
        HashMap<Integer, ValidationDocket<S, R>> certificateMapping = new HashMap<Integer, ValidationDocket<S, R>>();
        HashMap<Integer, ValidationDocket<S, R>> attributeCertificateMapping = new HashMap<Integer, ValidationDocket<S, R>>();
        ValidationData validationData = null;
        if (options != null) {
            validationData = options.getValidationData();
        }
        if ((request = this.buildRequest(validationDockets, certificateMapping, attributeCertificateMapping, policyFromRequest, validationData)) == null) {
            return;
        }
        CompoundCertificateValidationResponse relayResult = this.sendRequest(request, options);
        if (relayResult == null) {
            LOGGER.warn("CVS does not return a result for prefetched certificate validation request");
            return;
        }
        this.processResponse(relayResult, certificateMapping, attributeCertificateMapping);
    }

    private CompoundCertificateValidationResponse sendRequest(CompoundCertificateValidationRequest request, ValidationOptions options) {
        String cvsURL = null;
        Collection trustedIssuer = null;
        if (options != null) {
            cvsURL = options.getCVSURL();
            trustedIssuer = options.getCVSTrustedIssuers();
        }
        LOGGER.debug("Issuing request");
        return this.cvs.validateCompound(request, cvsURL, trustedIssuer);
    }

    private <S extends Signature, R extends SignatureValidationResult> void processResponse(CompoundCertificateValidationResponse relayResult, Map<Integer, ValidationDocket<S, R>> certificateMapping, Map<Integer, ValidationDocket<S, R>> attributeCertificateMapping) {
        List attributeCertificateValidationResults;
        LOGGER.debug("Adding validation results to document context");
        List validationResults = relayResult.getValidationResults();
        List policies = relayResult.getPolicies();
        Map<Integer, EvaluatedValidationPolicyType> policyMap = policies.stream().collect(Collectors.toMap(EvaluatedPolicyEntry::getId, EvaluatedPolicyEntry::getPolicy));
        if (validationResults != null) {
            for (ResponseEntry re : validationResults) {
                int id = re.getId();
                PublicKeyCertificateValidationResult certificateValidationResult = re.getCertificateValidationResult();
                certificateValidationResult.setCvsResponseSignatureValidationResult(relayResult.getCvsSignatureValidationResult());
                certificateValidationResult.setCvsForwardedResponseSignatureValidationResult(re.getForwardedCVSSignatureValidationResult());
                ValidationDocket<S, R> validationDocket = certificateMapping.get(id);
                CertChainResult<PublicKeyCertificateValidationResult> res = this.createResult(certificateValidationResult, policyMap.get(re.getPolicyReference()));
                validationDocket.setSigningCertificateValidationResult(res);
            }
        }
        if ((attributeCertificateValidationResults = relayResult.getAttributeCertificateValidationResults()) != null) {
            for (ResponseEntry re : attributeCertificateValidationResults) {
                int id = re.getId();
                AttributeCertificateValidationResult attributeCertificateValidationResult = re.getAttributeCertificateValidationResult();
                attributeCertificateValidationResult.setCvsResponseSignatureValidationResult(relayResult.getCvsSignatureValidationResult());
                attributeCertificateValidationResult.setCvsForwardedResponseSignatureValidationResult(relayResult.getForwardedCVSSignatureValidationResult());
                ValidationDocket<S, R> validationDocket = attributeCertificateMapping.get(id);
                if (validationDocket == null) continue;
                CertChainResult<AttributeCertificateValidationResult> res = this.createResult(attributeCertificateValidationResult, policyMap.get(re.getPolicyReference()));
                List<CertChainResult<AttributeCertificateValidationResult>> attributeCertificateValidationResults2 = validationDocket.getAttributeCertificateValidationResults();
                if (attributeCertificateValidationResults2 == null) {
                    attributeCertificateValidationResults2 = new ArrayList<CertChainResult<AttributeCertificateValidationResult>>();
                    validationDocket.setAttributeCertificateValidationResults(attributeCertificateValidationResults2);
                }
                attributeCertificateValidationResults2.add(res);
            }
        }
    }

    private <T extends CertificateValidationResult> CertChainResult<T> createResult(T certificateValidationResult, EvaluatedValidationPolicyType evaluatedValidationPolicyType) {
        Date bestSignatureTime = certificateValidationResult.getBestSignatureTime();
        DateType bestSignatureTimeType = certificateValidationResult.getBestSignatureTimeType();
        TypedDate bestPOE = SVPFactory.createTypedDate((Date)bestSignatureTime, (DateType)bestSignatureTimeType);
        return new CertChainResult<T>(certificateValidationResult, bestPOE, evaluatedValidationPolicyType);
    }
}

