/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation;

import de.governikus.csl.certStore.CertStore;
import de.governikus.csl.certStore.CertStoreResponse;
import de.governikus.csl.certStore.CertificateData;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.InformationSource;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.utils.CslTimingUtil;
import de.governikus.csl.validate.svp.CertificateValidationResult;
import de.governikus.csl.validate.svp.PublicKeyCertificateValidationResult;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.AttachedRevocationValueValidator;
import de.governikus.csl.validation.IssuerCertificateResolver;
import de.governikus.csl.validation.ResultInitializer;
import de.governikus.csl.validation.SignatureValidationAlgorithm;
import de.governikus.csl.validation.SignatureValidationInitializer;
import de.governikus.csl.validation.ValidationCriterion;
import de.governikus.csl.validation.context.CertificateValidationContext;
import de.governikus.csl.validation.context.ContextUtil;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.CheckAttributeCertificates;
import de.governikus.csl.validation.criteria.CheckSigningCertificate;
import de.governikus.csl.validation.dataExtractor.DataExtractor;
import de.governikus.csl.validation.x509.X509Data;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ETSIBasicSignatureValidator<SOTYPE extends Signature, SORESULT extends SignatureValidationResult, CONTEXT extends SignatureValidationContext>
implements SignatureValidationAlgorithm<SOTYPE, SORESULT, CONTEXT> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ETSIBasicSignatureValidator.class);
    protected List<ValidationCriterion<? super SOTYPE, ? super SORESULT, ? super CONTEXT>> criteria;
    private DataExtractor<? super SOTYPE, ? super SORESULT> extractor;
    protected List<ValidationCriterion<? super Signature, ? super SignatureValidationResult, ? super SignatureValidationContext>> genericCriteria;
    private ResultInitializer<?, SORESULT> initializer;
    private IssuerCertificateResolver<SOTYPE> resolver;
    private AttachedRevocationValueValidator<SOTYPE, SORESULT, CONTEXT> attachedRevoValValidator;

    public ETSIBasicSignatureValidator(List<ValidationCriterion<? super Signature, ? super SignatureValidationResult, ? super SignatureValidationContext>> genericCriteria, List<ValidationCriterion<? super SOTYPE, ? super SORESULT, ? super CONTEXT>> criteria, SignatureValidationInitializer<SOTYPE, SORESULT> plugin) {
        this.genericCriteria = genericCriteria;
        this.criteria = criteria;
        this.extractor = plugin.getSignatureDataExtractor();
        this.initializer = plugin.getResultInitializer();
        this.resolver = plugin.getCertificateResolver();
        this.attachedRevoValValidator = new AttachedRevocationValueValidator(criteria, this.initializer);
    }

    @Override
    public SORESULT validate(SOTYPE signature, CONTEXT context) {
        return this.basicSignatureValidation(signature, context);
    }

    protected SORESULT basicSignatureValidation(SOTYPE signature, CONTEXT context) {
        if (this.attachedRevoValValidator.isEnabled(signature, context)) {
            this.attachedRevoValValidator.initPreprocessedRevoactionResult((X509Data)((Object)X509Data.class.cast(signature)), (CertificateValidationContext)CertificateValidationContext.class.cast(context));
        } else {
            this.extendContext(signature, context);
        }
        if (signature.getSigningCertificate() != null) {
            ((SignatureValidationContext)context).setCertificateSource(InformationSource.SIGNATURE);
            return this.basicSignatureValidation1(signature, context);
        }
        if (this.resolver == null) {
            return this.basicSignatureValidation1(signature, context);
        }
        List certs = new ArrayList();
        CertStoreResponse res = this.resolver.getIssuerCertificates(signature, (CertStore)((SignatureValidationContext)context).getCertStore());
        if (res != null) {
            certs = res.getMatchingCertificates();
            ((SignatureValidationContext)context).setCertificateSource(res.getInformationSource());
        }
        if (certs.isEmpty()) {
            return this.basicSignatureValidation1(signature, context);
        }
        SORESULT result = null;
        for (CertificateData cert : certs) {
            signature.setSigningCertificate(new X509CertificateImpl(cert.getCertificate()));
            result = this.basicSignatureValidation1(signature, context);
            if (result.getOverallResult(true).getMajor() == MajorTotalResult.TOTAL_PASSED) break;
            String certificateURL = cert.getCertificateURL();
            if (certificateURL == null) continue;
            PublicKeyCertificateValidationResult signingCertificateValidationResult = result.getSigningCertificateValidationResult();
            signingCertificateValidationResult.setDownloadUrl(certificateURL);
        }
        return result;
    }

    private void extendContext(SOTYPE signature, CONTEXT context) {
        ContextUtil.extendContextWithAttachedCertificates(signature, context);
        ContextUtil.extendContextWithAttachedRevocationValues(signature, context);
    }

    private SORESULT basicSignatureValidation1(SOTYPE signature, CONTEXT context) {
        CertificateValidationResult certResult;
        ValidationResult revocationResult;
        SORESULT result = this.initializer.createSignatureResultStructure();
        int critSize = (this.genericCriteria != null ? this.genericCriteria.size() : 0) + (this.criteria != null ? this.criteria.size() : 0);
        List criteriaToProcess = new ArrayList(critSize);
        if (this.genericCriteria != null) {
            criteriaToProcess.addAll(this.genericCriteria);
        }
        if (this.criteria != null) {
            criteriaToProcess.addAll(this.criteria);
        }
        this.attachedRevoValValidator.insertResult(result, criteriaToProcess);
        criteriaToProcess = this.rearrangeCriterias(criteriaToProcess);
        Instant critStart = null;
        while (criteriaToProcess != null && !criteriaToProcess.isEmpty()) {
            ArrayList waitingGenericChecks = null;
            int numProcessed = 0;
            for (ValidationCriterion crit : criteriaToProcess) {
                if (!crit.isApplicable(signature, result, context)) continue;
                if (crit.preconditionsFulfilled(signature, result)) {
                    if (CslTimingUtil.isCriterionsTimingDebuggingEnabled()) {
                        critStart = Instant.now();
                    }
                    ++numProcessed;
                    crit.verify(signature, result, context);
                    if (!CslTimingUtil.isCriterionsTimingDebuggingEnabled() || critStart == null) continue;
                    String subject = "unknown signer";
                    if (signature.getSigningCertificate() != null) {
                        subject = signature.getSigningCertificate().getSubjectX500Principal().toString();
                    }
                    LOGGER.debug("Verifying criterion {} for {} took {} ms.", new Object[]{crit.getClass().getSimpleName(), subject, Duration.between(critStart, Instant.now()).toMillis()});
                    continue;
                }
                if (waitingGenericChecks == null) {
                    waitingGenericChecks = new ArrayList();
                }
                waitingGenericChecks.add(crit);
            }
            criteriaToProcess = waitingGenericChecks;
            if (numProcessed != 0) continue;
            break;
        }
        if (this.attachedRevoValValidator.isEnabled(signature, context) && this.attachedRevoValValidator.getPreprocessedRevocationResult() == null && CertificateValidationResult.class.isInstance(result) && (revocationResult = (certResult = (CertificateValidationResult)CertificateValidationResult.class.cast(result)).getRevocationStatusCheck()) != null) {
            revocationResult.getMessages().addAll(this.attachedRevoValValidator.getIgnoreReasons());
        }
        if (this.extractor != null) {
            this.extractor.extractData(signature, result);
        }
        return result;
    }

    private List<ValidationCriterion<? super SOTYPE, ? super SORESULT, ? super CONTEXT>> rearrangeCriterias(List<ValidationCriterion<? super SOTYPE, ? super SORESULT, ? super CONTEXT>> criteriaToProcess) {
        ArrayList<ValidationCriterion<SOTYPE, SORESULT, CONTEXT>> sorted = new ArrayList<ValidationCriterion<SOTYPE, SORESULT, CONTEXT>>(criteriaToProcess.size());
        ValidationCriterion<? super SOTYPE, ? super SORESULT, ? super CONTEXT> checkSigningCert = null;
        ValidationCriterion<? super SOTYPE, ? super SORESULT, ? super CONTEXT> checkAttribCert = null;
        ListIterator<ValidationCriterion<SOTYPE, SORESULT, CONTEXT>> listIterator = criteriaToProcess.listIterator();
        while (listIterator.hasNext()) {
            ValidationCriterion<? super SOTYPE, ? super SORESULT, ? super CONTEXT> criterion = listIterator.next();
            if (criterion instanceof CheckSigningCertificate) {
                checkSigningCert = criterion;
                listIterator.remove();
                continue;
            }
            if (!(criterion instanceof CheckAttributeCertificates)) continue;
            checkAttribCert = criterion;
            listIterator.remove();
        }
        if (checkAttribCert != null) {
            sorted.add(0, checkAttribCert);
        }
        if (checkSigningCert != null) {
            sorted.add(0, checkSigningCert);
        }
        sorted.addAll(criteriaToProcess);
        return sorted;
    }
}

