/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation;

import de.governikus.csl.uom.validate.commons.ContainerObjectToValidate;
import de.governikus.csl.uom.validate.commons.ObjectToValidate;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.validate.svp.ContainerObjectValidationResult;
import de.governikus.csl.validate.svp.ObjectValidationResult;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.csl.validation.Configuration;
import de.governikus.csl.validation.ContainerPlugin;
import de.governikus.csl.validation.IncludedFileValidator;
import de.governikus.csl.validation.MultipleSignedObjectValidator;
import de.governikus.csl.validation.ObjectValidator;
import de.governikus.csl.validation.context.DocumentValidationContext;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.policy.EvaluatingPolicyReferenceManager;
import de.governikus.csl.validation.policy.PolicyProviderManager;
import java.util.List;

public class ContainerValidator<OT extends ContainerObjectToValidate<SIGNATURE>, SIGNATURE extends Signature, RESULT extends ContainerObjectValidationResult, SIGNATURERESULT extends SignatureValidationResult, CONTEXT extends SignatureValidationContext>
extends MultipleSignedObjectValidator<OT, SIGNATURE, RESULT, SIGNATURERESULT, CONTEXT> {
    private final PolicyProviderManager policyProviderManager;
    private ContainerPlugin<OT, SIGNATURE, RESULT, SIGNATURERESULT, CONTEXT> documentPlugin;

    public ContainerValidator(ContainerPlugin<OT, SIGNATURE, RESULT, SIGNATURERESULT, CONTEXT> documentPlugin, OT parsedDocument, Configuration config, IncludedFileValidator requestProcessor) {
        super(documentPlugin, parsedDocument, config, requestProcessor);
        this.documentPlugin = documentPlugin;
        this.policyProviderManager = config.getPolicyProviderManager();
    }

    public ContainerObjectValidationResult validate(DocumentValidationContext context) {
        List policyEntries;
        EvaluatingPolicyReferenceManager policyManager = context.getPolicyManager();
        boolean addResult = false;
        if (policyManager == null) {
            policyManager = new EvaluatingPolicyReferenceManager(this.policyProviderManager);
            context.setPolicyManager(policyManager);
            addResult = true;
        }
        ContainerObjectValidationResult result = (ContainerObjectValidationResult)super.validate(this.doc, context);
        List containedObjectsToValidate = ((ContainerObjectToValidate)this.doc).getContainedObjectsToValidate();
        if (containedObjectsToValidate != null) {
            List childResults = result.getResultsForContainedObjects();
            for (ObjectToValidate otv : containedObjectsToValidate) {
                ObjectValidator childObjectValidator = this.documentPlugin.getDocumentValidatorForContainedDocument(otv, this.requestProcessor);
                ObjectValidationResult childResult = childObjectValidator.validate(context);
                childResults.add(childResult);
            }
        }
        if (addResult && (policyEntries = policyManager.getPolicyEntries()) != null) {
            result.getPolicyEntries().addAll(policyEntries);
        }
        return result;
    }
}

