/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation;

import de.governikus.csl.algorithm_catalog.AlgorithmCatalogManager;
import de.governikus.csl.certStore.CertStoreCollection;
import de.governikus.csl.cvs.client.DynamicCVSClient;
import de.governikus.csl.uom.validate.ObjectValidationResult;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.ObjectToValidate;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.utils.TrustStore;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.csl.validation.ConfigurationBuilder;
import de.governikus.csl.validation.ObjectValidationCriterion;
import de.governikus.csl.validation.PrioritisedValidationPluginComparator;
import de.governikus.csl.validation.ValidatePlugin;
import de.governikus.csl.validation.ValidationCriterion;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.policy.PolicyProviderManager;
import de.governikus.csl.validation.revocation.service.RevocationValueService;
import de.governikus.csl.validation.x509.CertificateValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Configuration {
    private RevocationValueService revocationService;
    private CertStoreCollection certStore;
    private TrustStore trustStore;
    private List<ValidationCriterion<? super Signature, ? super SignatureValidationResult, ? super SignatureValidationContext>> basicCriterias;
    private List<ObjectValidationCriterion<? super ObjectToValidate<?>, ? super ObjectValidationResult>> basicObjectValidationCriteria;
    private ExecutorService executorService;
    private Map<String, ValidatePlugin> plugins;
    private ArrayList<ValidatePlugin> prioPlugins;
    private static final PrioritisedValidationPluginComparator PRIO_COMPARATOR = new PrioritisedValidationPluginComparator();
    private AlgorithmManager algorithmManager;
    private AlgorithmCatalogManager algorithmCatalog;
    private double swapFileThresholdValue = 1.0;
    private boolean swapFileThresholdPercent = true;
    private DynamicCVSClient certificateValidationService;
    private int maxIncludedFileRecursions = 3;
    private CertificateValidator certValidator;
    private PolicyProviderManager policyProviderManager;

    public RevocationValueService getRevocationService() {
        return this.revocationService;
    }

    public void setRevocationService(RevocationValueService revocationService) {
        this.revocationService = revocationService;
    }

    public CertStoreCollection getCertStore() {
        return this.certStore;
    }

    public void setCertStore(CertStoreCollection certStore) {
        this.certStore = certStore;
    }

    public TrustStore getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(TrustStore trustStore) {
        this.trustStore = trustStore;
    }

    public List<ValidationCriterion<? super Signature, ? super SignatureValidationResult, ? super SignatureValidationContext>> getBasicCriterias() {
        return this.basicCriterias;
    }

    public void setBasicCriterias(List<ValidationCriterion<? super Signature, ? super SignatureValidationResult, ? super SignatureValidationContext>> basicCriterias) {
        this.basicCriterias = basicCriterias;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public Map<String, ValidatePlugin> getPlugins() {
        return this.plugins;
    }

    public List<ValidatePlugin> getPrioritisedPluginList() {
        return this.prioPlugins;
    }

    public void setPlugins(Map<String, ValidatePlugin> plugins) {
        this.plugins = plugins;
        if (plugins != null) {
            this.prioPlugins.addAll(plugins.values());
        }
    }

    public void addPlugin(ValidatePlugin p) {
        if (this.plugins == null) {
            this.plugins = new HashMap<String, ValidatePlugin>();
            this.prioPlugins = new ArrayList();
        }
        this.plugins.put(p.getID(), p);
        this.prioPlugins.add(p);
        this.reOrderPluginPriority();
        p.configure(this);
    }

    public void reOrderPluginPriority() {
        Collections.sort(this.prioPlugins, PRIO_COMPARATOR);
    }

    public ValidatePlugin getPlugin(String id) {
        if (this.plugins == null) {
            return null;
        }
        return this.plugins.get(id);
    }

    public AlgorithmManager getAlgorithmManager() {
        return this.algorithmManager;
    }

    public void setAlgorithmManager(AlgorithmManager algorithmManager) {
        this.algorithmManager = algorithmManager;
    }

    public AlgorithmCatalogManager getAlgorithmCatalog() {
        return this.algorithmCatalog;
    }

    public void setAlgorithmCatalog(AlgorithmCatalogManager algorithmCatalog) {
        this.algorithmCatalog = algorithmCatalog;
    }

    public List<ObjectValidationCriterion<? super ObjectToValidate<?>, ? super ObjectValidationResult>> getBasicObjectValidationCriteria() {
        return this.basicObjectValidationCriteria;
    }

    public void setBasicObjectValidationCriteria(List<ObjectValidationCriterion<? super ObjectToValidate<?>, ? super ObjectValidationResult>> basicObjectValidationCriteria) {
        this.basicObjectValidationCriteria = basicObjectValidationCriteria;
    }

    public int getSwapFileThreshold() {
        if (!this.swapFileThresholdPercent) {
            return (int)this.swapFileThresholdValue;
        }
        return (int)Math.min((double)Runtime.getRuntime().freeMemory() * this.swapFileThresholdValue / 100.0, 2.147483647E9);
    }

    public void setSwapFileThreshold(String threshold) throws NumberFormatException {
        Pattern p = Pattern.compile("^([0-9]*\\.?[0-9]*)(%)?$");
        Matcher m = p.matcher(threshold);
        if (!m.matches()) {
            throw new NumberFormatException("Cannot parse '" + threshold + "' as an absolute or percentage swap file threshold value!");
        }
        this.setSwapFileThreshold(Double.parseDouble(m.group(1)), m.group(2) != null);
    }

    public void setSwapFileThreshold(double threshold, boolean isPercent) throws NumberFormatException {
        if (threshold < 0.0) {
            throw new NumberFormatException("swap file threshold may not be smaller than 0 or 0.0%!");
        }
        if (isPercent && threshold > 100.0) {
            throw new NumberFormatException("swap file threshold may not be bigger than 100.0%!");
        }
        this.swapFileThresholdValue = threshold;
        this.swapFileThresholdPercent = isPercent;
    }

    public DynamicCVSClient getCertificateValidationService() {
        return this.certificateValidationService;
    }

    public void setCertificateValidationService(DynamicCVSClient certificateValidationService) {
        this.certificateValidationService = certificateValidationService;
    }

    public int getMaxIncludedFileRecursions() {
        return this.maxIncludedFileRecursions;
    }

    public void setMaxIncludedFileRecursions(int maxIncludedFileRecursions) {
        this.maxIncludedFileRecursions = maxIncludedFileRecursions;
    }

    public CertificateValidator getCertValidator() {
        return this.certValidator;
    }

    public void setCertValidator(CertificateValidator certValidator) {
        this.certValidator = certValidator;
    }

    public PolicyProviderManager getPolicyProviderManager() {
        return this.policyProviderManager;
    }

    public void setPolicyProviderManager(PolicyProviderManager policyProviderManager) {
        this.policyProviderManager = policyProviderManager;
    }

    public static ConfigurationBuilder builder() {
        return new ConfigurationBuilder();
    }
}

