/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.governikus.csl.uom.validate.commons.CertificateReference;
import de.governikus.csl.utils.CryptoProviderUtil;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateReferenceImpl
implements CertificateReference {
    private byte[] digestValue;
    private String issuerName;
    private BigInteger issuerSerial;
    private DigestAlgorithm digestAlgorithm;
    private String uri;
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateReferenceImpl.class);

    public CertificateReferenceImpl(DigestAlgorithm digestAlgorithm, byte[] digestValue, String issuerName, BigInteger issuerSerial, String uri) {
        this.digestAlgorithm = digestAlgorithm;
        this.digestValue = digestValue;
        this.issuerName = issuerName;
        this.issuerSerial = issuerSerial;
        this.uri = uri;
    }

    public boolean isReferenced(Certificate cert) {
        try {
            if (cert instanceof X509Certificate) {
                X509Certificate x509 = (X509Certificate)cert;
                byte[] toDigest = x509.getEncoded();
                MessageDigest md = CryptoProviderUtil.getMessageDigestInstance((String)this.digestAlgorithm.getJCAName());
                md.update(toDigest);
                byte[] digest = md.digest();
                return MessageDigest.isEqual(this.digestValue, digest);
            }
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | CertificateEncodingException e) {
            LOGGER.error("Can't process certificate. False is returned.", (Throwable)e);
        }
        return false;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public byte[] getDigestValue() {
        return this.digestValue;
    }

    public void setDigestValue(byte[] digestValue) {
        this.digestValue = digestValue;
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public BigInteger getIssuerSerial() {
        return this.issuerSerial;
    }
}

