/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation;

import de.governikus.csl.core.impl.BaseObjectToValidate;
import de.governikus.csl.request.ValidationOptions;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.uom.validate.ValidatePolicy;
import de.governikus.csl.uom.validate.commons.ObjectToValidate;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.validate.svp.AttributeCertificateValidationResult;
import de.governikus.csl.validate.svp.CertificateValidationResult;
import de.governikus.csl.validate.svp.ObjectValidationResult;
import de.governikus.csl.validate.svp.PublicKeyCertificateValidationResult;
import de.governikus.csl.validate.svp.TypedDate;
import de.governikus.csl.validation.AbstractDocumentPlugin;
import de.governikus.csl.validation.ObjectValidator;
import de.governikus.csl.validation.attributecert.AttributeCertificateSignature;
import de.governikus.csl.validation.context.CertificateValidationContext;
import de.governikus.csl.validation.context.DocumentValidationContext;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.dataExtractor.DataExtractor;
import de.governikus.csl.validation.policy.EvaluatingPolicyReferenceManager;
import de.governikus.csl.validation.policy.PolicyProviderManager;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import de.governikus.csl.validation.x509.CertChainResult;
import de.governikus.csl.validation.x509.CertificateProcessor;
import de.governikus.csl.validation.x509.CertificateValidator;
import de.governikus.csl.validation.x509.X509Data;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CertificateDocumentValidator<SIG extends BaseCertificateSignature<?>, RESULT extends CertificateValidationResult>
implements ObjectValidator {
    private AbstractDocumentPlugin<BaseObjectToValidate<SIG>, SIG, ObjectValidationResult, RESULT, CertificateValidationContext> plugin;
    private BaseObjectToValidate<SIG> document;
    private CertificateValidator validator;

    public BaseObjectToValidate<SIG> getObjectToValidate() {
        return this.document;
    }

    public CertificateDocumentValidator(AbstractDocumentPlugin<BaseObjectToValidate<SIG>, SIG, ObjectValidationResult, RESULT, CertificateValidationContext> plugin, BaseObjectToValidate<SIG> document, CertificateValidator validator) {
        this.plugin = plugin;
        this.document = document;
        this.validator = validator;
    }

    @Override
    public ObjectValidationResult validate(DocumentValidationContext documentValidationContext) {
        ValidationOptions options = documentValidationContext.getOptions();
        List signatures = this.document.getSignatures();
        BaseCertificateSignature signature = (BaseCertificateSignature)((Object)signatures.get(0));
        ValidationPolicyType policy = null;
        Date validationDate = null;
        Date selectedValidationDate = null;
        if (options != null) {
            policy = options.getPolicy();
            validationDate = options.getValidationDate();
            selectedValidationDate = options.getSelectedValidationDate();
        }
        CertificateValidationContext context = this.plugin.createContext((SIG)((Object)signature), policy);
        context.setConfiguration(this.plugin.getConfiguration());
        context.extendContext((Signature)signature, validationDate, (ValidatePolicy)policy);
        context.setSelectedValidationDate(selectedValidationDate);
        context.setDocumentValidationContext(documentValidationContext);
        ObjectValidationResult result = this.plugin.getResultInitializer().createResultStructure((ObjectToValidate<?>)this.document);
        ValidatingCertProcessor processor = new ValidatingCertProcessor(this.validator, context);
        CertChainResult process = (CertChainResult)signature.process(processor);
        Object certResult = process.getCertificateValidationResult();
        EvaluatingPolicyReferenceManager policyManager = documentValidationContext.getPolicyManager();
        boolean addPoliciesToResult = false;
        if (policyManager == null) {
            PolicyProviderManager policyProviderManager = this.plugin.getConfiguration().getPolicyProviderManager();
            policyManager = new EvaluatingPolicyReferenceManager(policyProviderManager);
            addPoliciesToResult = true;
        }
        if (process.getPolicy() != null) {
            int policyReference = policyManager.addPolicy(process.getPolicy());
            certResult.setPolicyReference(policyReference);
            if (addPoliciesToResult) {
                result.getPolicyEntries().addAll(policyManager.getPolicyEntries());
            }
        }
        List signatureValidationResults = result.getSignatureValidationResults();
        signatureValidationResults.add(certResult);
        DataExtractor<BaseObjectToValidate<SIG>, ObjectValidationResult> docDataExtractor = this.plugin.getDocumentDataExtractor();
        docDataExtractor.extractData(this.document, result);
        return result;
    }

    private class ValidatingCertProcessor
    implements CertificateProcessor<CertChainResult<?>> {
        private CertificateValidator validator;
        private CertificateValidationContext context;

        public ValidatingCertProcessor(CertificateValidator validator, CertificateValidationContext context) {
            this.validator = validator;
            this.context = context;
        }

        @Override
        public CertChainResult<AttributeCertificateValidationResult> process(AttributeCertificateSignature attributeCert) {
            return this.validator.validate(attributeCert, this.context, this.listPossiblePOEs(this.context), this.listPossibleAlgValidationTimes(this.context));
        }

        @Override
        public CertChainResult<PublicKeyCertificateValidationResult> process(X509Data cert) {
            return this.validator.validate(cert, this.context, this.listPossiblePOEs(this.context), this.listPossibleAlgValidationTimes(this.context));
        }

        private List<TypedDate> listPossiblePOEs(SignatureValidationContext context) {
            Date validationDate;
            ArrayList<TypedDate> possiblePOEs = new ArrayList<TypedDate>();
            TypedDate bestSigningTime = context.getBestSigningTime();
            if (bestSigningTime != null) {
                possiblePOEs.add(bestSigningTime);
            }
            if ((validationDate = context.getValidationDate()) != null) {
                Date selectedValidationDate = context.getSelectedValidationDate();
                if (selectedValidationDate == null) {
                    possiblePOEs.add(SVPFactory.createTypedDate((Date)validationDate, (DateType)DateType.EXISTENCE));
                } else {
                    possiblePOEs.add(SVPFactory.createTypedDate((Date)selectedValidationDate, (DateType)DateType.SELECTED_TIME));
                }
            }
            return possiblePOEs;
        }

        private List<TypedDate> listPossibleAlgValidationTimes(SignatureValidationContext context) {
            Date validationDate;
            ArrayList<TypedDate> possiblePOEs = new ArrayList<TypedDate>();
            TypedDate bestSigningTime = context.getBestAlgValidationTime();
            if (bestSigningTime != null) {
                possiblePOEs.add(bestSigningTime);
            }
            if ((validationDate = context.getValidationDate()) != null) {
                possiblePOEs.add(SVPFactory.createTypedDate((Date)validationDate, (DateType)DateType.EXISTENCE));
            }
            return possiblePOEs;
        }
    }
}

