/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.governikus.csl.uom.validate.commons.CRLReference;
import de.governikus.csl.utils.CryptoProviderUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLReferenceImpl
implements CRLReference {
    private DigestAlgorithm digestAlgorithm;
    private byte[] digestValue;
    private static final Logger LOGGER = LoggerFactory.getLogger(CRLReferenceImpl.class);

    public CRLReferenceImpl(DigestAlgorithm algorithm, byte[] digestValue) {
        this.digestAlgorithm = algorithm;
        this.digestValue = digestValue;
    }

    public boolean isReferenced(CRL crl) {
        X509CRL x509 = (X509CRL)crl;
        DigestAlgorithm da = this.digestAlgorithm;
        try {
            byte[] toDigest = x509.getEncoded();
            MessageDigest md = CryptoProviderUtil.getMessageDigestInstance((String)da.getJCAName());
            md.update(toDigest);
            byte[] digest = md.digest();
            return MessageDigest.isEqual(this.digestValue, digest);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | CRLException e) {
            LOGGER.error("Can't process CRL. false is returned.", (Throwable)e);
            return false;
        }
    }
}

