/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.uom.validate.TimestampQuality;
import de.governikus.csl.uom.validate.ValidatePolicy;
import de.governikus.csl.uom.validate.commons.CumulatedValidationResult;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.uom.validate.commons.SignedObjectType;
import de.governikus.csl.validate.svp.TimestampValidationResult;
import de.governikus.csl.validate.svp.TypedDate;
import de.governikus.csl.validation.revocation.RevocationValueData;
import java.util.Date;
import java.util.List;

public final class BestPOEDeterminator {
    private BestPOEDeterminator() {
    }

    public static TypedDate getBestPOE(Signature signature, List<TimestampValidationResult> signatureTimestampValidationResults, Date validationDate, ValidatePolicy policy) {
        boolean allow;
        DateType minimalRequiredPOELevel = policy.getMinimalRequiredPOELevel();
        TypedDate signingTime = signature.getSigningTime();
        boolean bl = allow = signature instanceof RevocationValueData && (signature.getType() == SignedObjectType.OCSP || signature.getType() == SignedObjectType.CRL);
        if (signingTime != null && (allow || signingTime.getType().compareTo((Enum)minimalRequiredPOELevel) >= 0)) {
            return signingTime;
        }
        TypedDate bestPOE = new TypedDate();
        bestPOE.setDate(validationDate);
        bestPOE.setType(DateType.EXISTENCE);
        if (signatureTimestampValidationResults != null) {
            for (TimestampValidationResult vr : signatureTimestampValidationResults) {
                DateType poeLevel;
                Date time;
                CumulatedValidationResult overallResult = vr.getOverallResult(true);
                if (overallResult.getMajor() != MajorTotalResult.TOTAL_PASSED || !(time = vr.getGenerationTime()).before(bestPOE.getDate()) || minimalRequiredPOELevel.compareTo((Enum)(poeLevel = DateType.fromTimestampQuality((TimestampQuality)vr.getTimestampQuality()))) > 0) continue;
                bestPOE = SVPFactory.createTypedDate((Date)time, (DateType)poeLevel);
            }
        }
        return bestPOE;
    }

    public static TypedDate getBestPOE(List<TypedDate> poes, ValidatePolicy policy) {
        return BestPOEDeterminator.getBestPOE(poes, policy, false);
    }

    public static TypedDate getBestPOE(List<TypedDate> poes, ValidatePolicy policy, boolean isTimestampOrOcspOrCrlCert) {
        DateType minimalRequiredPOELevel = policy.getMinimalRequiredPOELevel();
        return BestPOEDeterminator.getBestPOE(poes, minimalRequiredPOELevel, isTimestampOrOcspOrCrlCert);
    }

    private static TypedDate getBestPOE(List<TypedDate> poes, DateType minimalRequiredPOELevel) {
        return BestPOEDeterminator.getBestPOE(poes, minimalRequiredPOELevel, false);
    }

    public static TypedDate getBestPOEForAlgorithmValidity(List<TypedDate> possibleAlgValidationTimes, ValidatePolicy policy) {
        DateType minimalRequiredAlgPOELevel = policy.getMinimalRequiredAlgPOELevel();
        return BestPOEDeterminator.getBestPOE(possibleAlgValidationTimes, minimalRequiredAlgPOELevel);
    }

    private static TypedDate getBestPOE(List<TypedDate> poes, DateType minimalRequiredPOELevel, boolean isTimestampOrOcspOrCrlCert) {
        TypedDate bestPOE = null;
        if (poes != null) {
            for (TypedDate vr : poes) {
                Date time = vr.getDate();
                if (bestPOE == null) {
                    if ((!isTimestampOrOcspOrCrlCert || !DateType.CLAIMED_SIGNING_TIME.equals((Object)vr.getType())) && minimalRequiredPOELevel.compareTo((Enum)vr.getType()) > 0) continue;
                    bestPOE = vr;
                    continue;
                }
                if (!time.before(bestPOE.getDate()) || (!isTimestampOrOcspOrCrlCert || !DateType.CLAIMED_SIGNING_TIME.equals((Object)vr.getType())) && minimalRequiredPOELevel.compareTo((Enum)vr.getType()) > 0) continue;
                bestPOE = vr;
            }
        }
        if (bestPOE == null) {
            bestPOE = new TypedDate();
            bestPOE.setDate(new Date());
            bestPOE.setType(DateType.EXISTENCE);
        }
        return bestPOE;
    }

    public static TypedDate getBestPOEForAlgorithmValidity(List<TypedDate> poes, Date validationDate, ValidatePolicy policy) {
        DateType minimalRequiredAlgPOELevel = policy.getMinimalRequiredAlgPOELevel();
        return BestPOEDeterminator.getBestPOE(poes, validationDate, minimalRequiredAlgPOELevel);
    }

    private static TypedDate getBestPOE(List<TypedDate> poes, Date validationDate, DateType minimalRequiredPOELevel) {
        TypedDate bestPOE = new TypedDate();
        bestPOE.setDate(validationDate);
        bestPOE.setType(DateType.EXISTENCE);
        if (poes != null) {
            for (TypedDate vr : poes) {
                Date time = vr.getDate();
                if (!time.before(bestPOE.getDate()) || minimalRequiredPOELevel.compareTo((Enum)vr.getType()) > 0) continue;
                bestPOE = vr;
            }
        }
        return bestPOE;
    }
}

