/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.commons.CumulatedValidationResult;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.validate.svp.AlgorithmValidityResult;
import de.governikus.csl.validate.svp.CertificateValidationResult;
import de.governikus.csl.validate.svp.PublicKeyCertificateValidationResult;
import de.governikus.csl.validate.svp.RevocationValueValidationResult;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.csl.validate.svp.ValidationMessageCode;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.ResultInitializer;
import de.governikus.csl.validation.ValidationCriterion;
import de.governikus.csl.validation.context.CertificateValidationContext;
import de.governikus.csl.validation.context.ContextUtil;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.revocation.service.AttachedRevocationValueService;
import de.governikus.csl.validation.revocation.service.ListRevocationValueService;
import de.governikus.csl.validation.revocation.service.RevocationValueService;
import de.governikus.csl.validation.x509.X509Data;
import de.governikus.csl.validation.x509.criteria.RevocationStatusChecker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;

public class AttachedRevocationValueValidator<SOTYPE extends Signature, SORESULT extends SignatureValidationResult, CONTEXT extends SignatureValidationContext> {
    private ValidationCriterion<? super X509Data, ? super PublicKeyCertificateValidationResult, ? super CertificateValidationContext> revocationStatusChecker = new RevocationStatusChecker();
    private List<ValidationCriterion<? super SOTYPE, ? super SORESULT, ? super CONTEXT>> criteria;
    private ResultInitializer<?, SORESULT> initializer;
    private List<Pair<CertificateValidationContext, CertificateValidationResult>> revoked = new ArrayList<Pair<CertificateValidationContext, CertificateValidationResult>>();
    private List<Pair<CertificateValidationContext, CertificateValidationResult>> notRevoked = new ArrayList<Pair<CertificateValidationContext, CertificateValidationResult>>();
    private Set<ValidationMessageCode> ignoreReasons = new HashSet<ValidationMessageCode>();
    private CertificateValidationResult preprocessedRevocationResult = null;

    public AttachedRevocationValueValidator(List<ValidationCriterion<? super SOTYPE, ? super SORESULT, ? super CONTEXT>> criteria, ResultInitializer<?, SORESULT> initializer) {
        this.criteria = criteria;
        this.initializer = initializer;
    }

    public void initPreprocessedRevoactionResult(X509Data signature, CertificateValidationContext context) {
        this.initRevocationResultLists(signature, context);
        this.selectResult(signature, context);
    }

    public void selectResult(X509Data signature, CertificateValidationContext context) {
        if (this.hasSameResults()) {
            Pair<CertificateValidationContext, CertificateValidationResult> resultPair = null;
            resultPair = this.revoked.size() == 1 ? this.revoked.get(0) : this.notRevoked.get(0);
            CertificateValidationContext contextWithOnlyOneOfflineRquester = (CertificateValidationContext)resultPair.getLeft();
            ListRevocationValueService offlineService = ContextUtil.getOfflineService((CertificateValidationContext)CertificateValidationContext.class.cast(contextWithOnlyOneOfflineRquester));
            RevocationValueService onlineService = ContextUtil.getOnlineService((CertificateValidationContext)CertificateValidationContext.class.cast(context));
            AttachedRevocationValueService offlineAndOnlineService = new AttachedRevocationValueService(offlineService, onlineService, false, context.getConfiguration().getAlgorithmManager());
            context.setRevocationValueRequester(offlineAndOnlineService);
            this.preprocessedRevocationResult = (CertificateValidationResult)resultPair.getRight();
        } else if (this.hasDifferingResults()) {
            RevocationValueService onlineService = ContextUtil.getOnlineService((CertificateValidationContext)CertificateValidationContext.class.cast(context));
            context.setRevocationValueRequester(onlineService);
            this.preprocessedRevocationResult = new PublicKeyCertificateValidationResult();
            this.preprocessedRevocationResult.setRevocationStatusCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (String)"revocation_values_attached_contradicting"));
            this.preprocessedRevocationResult.setRevocationValueValidationResult(null);
        } else {
            RevocationValueService onlineService = ContextUtil.getOnlineService((CertificateValidationContext)CertificateValidationContext.class.cast(context));
            context.setRevocationValueRequester(onlineService);
        }
        ContextUtil.extendContextWithAttachedCertificates((Signature)signature, context);
        if (this.preprocessedRevocationResult != null && !this.ignoreReasons.isEmpty()) {
            this.ignoreReasons.stream().forEach(this.preprocessedRevocationResult.getRevocationStatusCheck().getMessages()::add);
        }
    }

    public void initRevocationResultLists(X509Data signature, CertificateValidationContext context) {
        Map<byte[], CertificateValidationContext> tmpContexts = ContextUtil.getTmpContextByRevocationValue((CertificateValidationContext)CertificateValidationContext.class.cast(context));
        for (Map.Entry<byte[], CertificateValidationContext> entry : tmpContexts.entrySet()) {
            CertificateValidationResult certResult = (CertificateValidationResult)CertificateValidationResult.class.cast(this.initializer.createSignatureResultStructure());
            if (!this.revocationStatusChecker.isApplicable(signature, (PublicKeyCertificateValidationResult)PublicKeyCertificateValidationResult.class.cast(certResult), context)) continue;
            this.revocationStatusChecker.verify(signature, (PublicKeyCertificateValidationResult)PublicKeyCertificateValidationResult.class.cast(certResult), context);
            CertificateValidationContext certContext = entry.getValue();
            this.checkResult(certContext, certResult);
        }
    }

    public void checkResult(CertificateValidationContext certContext, CertificateValidationResult certResult) {
        RevocationValueValidationResult revocationResult = certResult.getRevocationValueValidationResult();
        if (!this.hasIgnoreReason(revocationResult)) {
            MinorResult minor;
            CumulatedValidationResult overallResult = certResult.getOverallResult(true);
            MajorTotalResult major = overallResult.getMajor();
            if (this.addResult(certContext, certResult, major, minor = overallResult.getMinor())) {
                return;
            }
            this.ignoreReasons.add(SVPFactory.createMessageCode((String)"revocation_values_attached_no_trust"));
        }
    }

    public boolean addResult(CertificateValidationContext certContext, CertificateValidationResult certResult, MajorTotalResult major, MinorResult minor) {
        if (MajorTotalResult.TOTAL_FAILED.equals((Object)major) && (MinorResult.REVOKED.equals((Object)minor) || MinorResult.REVOKED_NO_POE.equals((Object)minor))) {
            this.revoked.add((Pair<CertificateValidationContext, CertificateValidationResult>)Pair.of((Object)certContext, (Object)certResult));
            return true;
        }
        if (MajorTotalResult.TOTAL_PASSED.equals((Object)major)) {
            this.notRevoked.add((Pair<CertificateValidationContext, CertificateValidationResult>)Pair.of((Object)certContext, (Object)certResult));
            return true;
        }
        return false;
    }

    public boolean hasIgnoreReason(RevocationValueValidationResult revocationResult) {
        ValidationResult revocationTrustCheckResult;
        if (revocationResult == null) {
            return false;
        }
        boolean hasIgnoreReason = false;
        hasIgnoreReason |= this.ignoreResult(revocationResult.getFreshnessCheckResult(), "revocation_values_attached_too_old");
        hasIgnoreReason |= this.ignoreResult(revocationResult.getSignatureMathCheck(), "revocation_values_attached_invalid_signature");
        hasIgnoreReason |= this.ignoreAlgorithmResult(revocationResult.getSignatureAlgorithmValidityAtBestPOE());
        hasIgnoreReason |= this.ignoreAlgorithmResult(revocationResult.getSignatureAlgorithmValidityAtClaimedSigningTime());
        hasIgnoreReason |= this.ignoreAlgorithmResult(revocationResult.getSignatureAlgorithmValidityAtValidationDate());
        PublicKeyCertificateValidationResult signCertResult = revocationResult.getSigningCertificateValidationResult();
        if (signCertResult != null && (revocationTrustCheckResult = signCertResult.getRevocationTrustCheckResult()) != null && MajorTotalResult.INDETERMINATE.equals((Object)revocationTrustCheckResult.getMajor())) {
            this.ignoreReasons.add(SVPFactory.createMessageCode((String)"revocation_values_attached_no_trust"));
            hasIgnoreReason |= true;
        }
        return hasIgnoreReason;
    }

    public boolean ignoreResult(ValidationResult result, String msgCode) {
        if (result == null) {
            return false;
        }
        MajorTotalResult major = result.getMajor();
        if (!MajorTotalResult.TOTAL_PASSED.equals((Object)major) && !MajorTotalResult.NOT_VALIDATED.equals((Object)major)) {
            this.ignoreReasons.add(SVPFactory.createMessageCode((String)msgCode));
            return true;
        }
        return false;
    }

    public boolean ignoreAlgorithmResult(AlgorithmValidityResult algorithmResult) {
        if (algorithmResult == null) {
            return false;
        }
        MajorTotalResult algorithmResultMajor = algorithmResult.getOverallResult(true).getMajor();
        if (!MajorTotalResult.TOTAL_PASSED.equals((Object)algorithmResultMajor) && !MajorTotalResult.NOT_VALIDATED.equals((Object)algorithmResultMajor)) {
            this.ignoreReasons.add(SVPFactory.createMessageCode((String)"revocation_values_attached_untrusted_algorithm"));
            return true;
        }
        return false;
    }

    public boolean hasSameResults() {
        return this.revoked.size() >= 1 && this.notRevoked.size() == 0 || this.notRevoked.size() >= 1 && this.revoked.size() == 0;
    }

    public boolean hasDifferingResults() {
        return this.revoked.size() >= 1 && this.notRevoked.size() >= 1;
    }

    public boolean isEnabled(SOTYPE signature, CONTEXT context) {
        return X509Data.class.isInstance(signature) && Optional.ofNullable(this.criteria).orElse(Collections.emptyList()).stream().anyMatch(c -> RevocationStatusChecker.class.isInstance(c));
    }

    public void insertResult(SORESULT result, List<ValidationCriterion<? super SOTYPE, ? super SORESULT, ? super CONTEXT>> criteriaToProcess) {
        if (criteriaToProcess == null || criteriaToProcess.isEmpty()) {
            return;
        }
        if (this.preprocessedRevocationResult != null && CertificateValidationResult.class.isInstance(result)) {
            CertificateValidationResult certResult = (CertificateValidationResult)result;
            ListIterator<ValidationCriterion<SOTYPE, SORESULT, CONTEXT>> critIterator = criteriaToProcess.listIterator();
            while (critIterator.hasNext()) {
                ValidationCriterion<? super SOTYPE, ? super SORESULT, ? super CONTEXT> validationCriterion = critIterator.next();
                if (!RevocationStatusChecker.class.isInstance(validationCriterion)) continue;
                critIterator.remove();
                certResult.setRevocationStatusCheck(this.preprocessedRevocationResult.getRevocationStatusCheck());
                certResult.setRevocationValueValidationResult(this.preprocessedRevocationResult.getRevocationValueValidationResult());
                return;
            }
        }
    }

    @Generated
    public ValidationCriterion<? super X509Data, ? super PublicKeyCertificateValidationResult, ? super CertificateValidationContext> getRevocationStatusChecker() {
        return this.revocationStatusChecker;
    }

    @Generated
    public List<ValidationCriterion<? super SOTYPE, ? super SORESULT, ? super CONTEXT>> getCriteria() {
        return this.criteria;
    }

    @Generated
    public ResultInitializer<?, SORESULT> getInitializer() {
        return this.initializer;
    }

    @Generated
    public List<Pair<CertificateValidationContext, CertificateValidationResult>> getRevoked() {
        return this.revoked;
    }

    @Generated
    public List<Pair<CertificateValidationContext, CertificateValidationResult>> getNotRevoked() {
        return this.notRevoked;
    }

    @Generated
    public Set<ValidationMessageCode> getIgnoreReasons() {
        return this.ignoreReasons;
    }

    @Generated
    public CertificateValidationResult getPreprocessedRevocationResult() {
        return this.preprocessedRevocationResult;
    }
}

