/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation;

import de.governikus.csl.uom.InstanceProvider;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.impl.AbstractPlugin;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.validate.ValidatePolicy;
import de.governikus.csl.uom.validate.commons.ObjectToValidate;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.utils.MagicBytes;
import de.governikus.csl.validate.svp.ObjectValidationResult;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.csl.validation.Configuration;
import de.governikus.csl.validation.IncludedFileValidator;
import de.governikus.csl.validation.IssuerCertificateResolver;
import de.governikus.csl.validation.MultipleSignedObjectValidator;
import de.governikus.csl.validation.ObjectValidationCriterion;
import de.governikus.csl.validation.ObjectValidator;
import de.governikus.csl.validation.PluginPriority;
import de.governikus.csl.validation.ResultInitializer;
import de.governikus.csl.validation.SignatureValidationInitializer;
import de.governikus.csl.validation.SignatureValidator;
import de.governikus.csl.validation.SignatureValidatorImpl;
import de.governikus.csl.validation.TypedValidatePlugin;
import de.governikus.csl.validation.ValidatePluginException;
import de.governikus.csl.validation.ValidationCriterion;
import de.governikus.csl.validation.context.DocumentValidationContext;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.dataExtractor.DataExtractor;
import de.governikus.csl.validation.dataExtractor.DefaultDocumentDataExtractor;
import de.governikus.csl.validation.dataExtractor.DefaultSignatureDataExtractor;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDocumentPlugin<DOCTYPE extends ObjectToValidate<SOTYPE>, SOTYPE extends Signature, RESULT extends ObjectValidationResult, SORESULT extends SignatureValidationResult, CONTEXT extends SignatureValidationContext>
extends AbstractPlugin
implements TypedValidatePlugin<DOCTYPE, SOTYPE, RESULT, SORESULT, CONTEXT>,
SignatureValidationInitializer<SOTYPE, SORESULT> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected List<ValidationCriterion<? super SOTYPE, ? super SORESULT, ? super CONTEXT>> customSignatureValidationCriteria;
    protected List<ObjectValidationCriterion<? super DOCTYPE, ? super RESULT>> documentValidationCriteria;
    protected IssuerCertificateResolver<SOTYPE> certificateResolver;
    protected List<String> supportedMimeTypes = new ArrayList<String>();
    protected Configuration configuration;
    protected Class<SOTYPE> signatureClazz;
    protected Class<CONTEXT> contextClazz;
    protected InstanceProvider instanceProvider;
    private long priorityValue;

    public AbstractDocumentPlugin(Class<SOTYPE> signatureClazz, Class<CONTEXT> contextClazz) {
        this.signatureClazz = signatureClazz;
        this.contextClazz = contextClazz;
        PluginPriority pp = this.getClass().getAnnotation(PluginPriority.class);
        this.priorityValue = pp != null ? pp.priority() : 0L;
    }

    @Override
    public long getPriority() {
        return this.priorityValue;
    }

    @Override
    public void setPriority(long id) {
        this.priorityValue = id;
    }

    @Override
    public IssuerCertificateResolver<SOTYPE> getCertificateResolver() {
        return this.certificateResolver;
    }

    @Override
    public boolean supportsMimeType(String mimeType) {
        for (String mt : this.supportedMimeTypes) {
            if (!mt.equalsIgnoreCase(mimeType)) continue;
            return true;
        }
        return false;
    }

    public List<ValidationCriterion<? super SOTYPE, ? super SORESULT, ? super CONTEXT>> getCustomSignatureValidationCriteria() {
        return this.customSignatureValidationCriteria;
    }

    public void setCustomSignatureValidationCriteria(List<ValidationCriterion<? super SOTYPE, ? super SORESULT, ? super CONTEXT>> customCriteria) {
        this.customSignatureValidationCriteria = customCriteria;
    }

    public void addCustomSignatureValidationCriterion(ValidationCriterion<? super SOTYPE, ? super SORESULT, ? super CONTEXT> customCriteria) {
        if (this.customSignatureValidationCriteria == null) {
            this.customSignatureValidationCriteria = new ArrayList<ValidationCriterion<? super SOTYPE, ? super SORESULT, ? super CONTEXT>>();
        }
        this.customSignatureValidationCriteria.add(customCriteria);
    }

    public void addDocumentValidationCriterion(ObjectValidationCriterion<? super DOCTYPE, ? super RESULT> criterion) {
        if (this.documentValidationCriteria == null) {
            this.documentValidationCriteria = new ArrayList<ObjectValidationCriterion<? super DOCTYPE, ? super RESULT>>();
        }
        this.documentValidationCriteria.add(criterion);
    }

    @Override
    public ObjectValidator getObjectValidator(SignedData doc, TempDataManager tempDataManager, IncludedFileValidator requestProcessor) throws ValidatePluginException {
        DOCTYPE parsedDocument = this.parseDocument(doc, tempDataManager);
        return this.getDocumentValidator(parsedDocument, requestProcessor);
    }

    public ObjectValidator getDocumentValidator(DOCTYPE parsedDocument, IncludedFileValidator requestProcessor) {
        if (parsedDocument == null) {
            return null;
        }
        MultipleSignedObjectValidator validator = new MultipleSignedObjectValidator(this, parsedDocument, this.configuration, requestProcessor);
        ArrayList crits = new ArrayList();
        List<ObjectValidationCriterion<? super ObjectToValidate<?>, ? super de.governikus.csl.uom.validate.ObjectValidationResult>> basicObjectValidationCriteria = this.configuration.getBasicObjectValidationCriteria();
        if (basicObjectValidationCriteria != null) {
            crits.addAll(basicObjectValidationCriteria);
        }
        if (this.documentValidationCriteria != null) {
            crits.addAll(this.documentValidationCriteria);
        }
        validator.setDocumentValidators(crits);
        return validator;
    }

    public SignatureValidator<?, ? extends SORESULT, ? extends CONTEXT> createSignatureValidator(SOTYPE signature, CONTEXT context, List<ValidationCriterion<? super SOTYPE, ? super SORESULT, ? super CONTEXT>> customCriteria) {
        SignatureValidatorImpl<Object, Object, Object> signatureValidator = new SignatureValidatorImpl<Object, Object, Object>(this, signature, context);
        if (customCriteria != null) {
            signatureValidator.setCustomCriteria(customCriteria);
        } else if (this.customSignatureValidationCriteria != null) {
            signatureValidator.setCustomCriteria(this.customSignatureValidationCriteria);
        }
        return signatureValidator;
    }

    public SignatureValidator<?, ? extends SORESULT, ?> createSignatureValidator(Signature signature, SignatureValidationContext context) {
        try {
            if (this.signatureClazz.equals(signature.getClass()) && this.contextClazz.equals(context.getClass())) {
                Signature se = (Signature)this.signatureClazz.cast(signature);
                SignatureValidationContext c = (SignatureValidationContext)this.contextClazz.cast(context);
                return this.createSignatureValidator(se, c, null);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public SignatureValidator<?, ? extends SORESULT, ? extends CONTEXT> createSignatureValidator(SOTYPE signature, Date validationDate, ValidationPolicyType policy, DocumentValidationContext documentContext) {
        CONTEXT context = this.createContext(signature, policy);
        ((SignatureValidationContext)context).setConfiguration(this.configuration);
        ((SignatureValidationContext)context).extendContext((Signature)signature, validationDate, (ValidatePolicy)policy);
        ((SignatureValidationContext)context).setDocumentValidationContext(documentContext);
        return this.createSignatureValidator(signature, context, null);
    }

    public abstract DOCTYPE parseDocument(SignedData var1, TempDataManager var2) throws ValidatePluginException;

    @Override
    public DataExtractor<? super SOTYPE, ? super SORESULT> getSignatureDataExtractor() {
        return new DefaultSignatureDataExtractor();
    }

    @Override
    public DataExtractor<? super DOCTYPE, ? super RESULT> getDocumentDataExtractor() {
        return new DefaultDocumentDataExtractor();
    }

    @Override
    public ResultInitializer<RESULT, SORESULT> getResultInitializer() {
        return new ResultInitializer<RESULT, SORESULT>(){

            @Override
            public RESULT createResultStructure(ObjectToValidate<?> objectToValidate) {
                Object result = AbstractDocumentPlugin.this.createResultStructure(objectToValidate);
                result.setValidationStartTime(new Date());
                return result;
            }

            @Override
            public SORESULT createSignatureResultStructure() {
                Object soresult = AbstractDocumentPlugin.this.createSignatureValidationResultStructure();
                soresult.setValidationStartTime(new Date());
                return soresult;
            }
        };
    }

    protected abstract RESULT createResultStructure(ObjectToValidate<?> var1);

    protected abstract SORESULT createSignatureValidationResultStructure();

    @Override
    public void configure(Configuration config) {
        this.configuration = config;
    }

    public abstract CONTEXT createContext(SOTYPE var1, ValidationPolicyType var2);

    public CONTEXT createContext(SOTYPE signature, SignatureValidationContext context) {
        CONTEXT clone = this.createContext(signature, context.getPolicy());
        ((SignatureValidationContext)clone).copyValuesFrom(context);
        return clone;
    }

    public List<ObjectValidationCriterion<? super DOCTYPE, ? super RESULT>> getDocumentValidationCriteria() {
        return this.documentValidationCriteria;
    }

    public void setDocumentValidationCriteria(List<ObjectValidationCriterion<? super DOCTYPE, ? super RESULT>> criteria) {
        this.documentValidationCriteria = criteria;
    }

    @Override
    public MagicBytes getMagicBytesOfDocumentFormat() {
        return null;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public String[] getSupportedFileExtensions() {
        return null;
    }

    public synchronized void initialize(InstanceProvider instanceProvider) throws Exception {
        this.instanceProvider = instanceProvider;
    }
}

