/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.tsp.ESSCertID;
import de.bos_bremen.ci.asn1.tsp.SigningCertificate;
import de.bos_bremen.ci.asn1.x509.IssuerSerial;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.CertificateReference;
import de.governikus.csl.validation.CertificateReferenceImpl;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class ASN1Util {
    public static List<CertificateReference> createCertificateReferences(SigningCertificate signingCertificateAttribute, AlgorithmManager algorithmManager) {
        List certIDs;
        ArrayList<CertificateReference> references = null;
        if (signingCertificateAttribute != null && (certIDs = signingCertificateAttribute.getCertIDs()) != null) {
            for (ESSCertID certID : certIDs) {
                CertificateReference ref = ASN1Util.createCertificateReference(certID, algorithmManager);
                if (ref == null) continue;
                if (references == null) {
                    references = new ArrayList<CertificateReference>();
                }
                references.add(ref);
            }
        }
        return references;
    }

    public static CertificateReference createCertificateReference(ESSCertID cert, AlgorithmManager algorithmManager) {
        AlgorithmIdentifier algorithm = cert.getAlgorithmIdentifier();
        byte[] data = cert.getCertHash().getOctets();
        IssuerSerial issuer = cert.getIssuerSerial();
        String issuerName = null;
        BigInteger issuerSerial = null;
        if (issuer != null) {
            issuerName = issuer.getName().getName();
            issuerSerial = issuer.getSerialnumber().getValue();
        }
        if (data != null && algorithm != null) {
            DigestAlgorithm digestAlgorithm = algorithmManager.getDigestAlgorithmByJcaOidOrUrl(algorithm.getJCAName(), algorithm.getOID().getOID(), null);
            return new CertificateReferenceImpl(digestAlgorithm, data, issuerName, issuerSerial, null);
        }
        return null;
    }
}

