/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.ades;

import de.governikus.csl.core.impl.BaseSignature;
import de.governikus.csl.uom.validate.commons.CertificateReference;
import de.governikus.csl.uom.validate.commons.SignatureClass;
import de.governikus.csl.uom.validate.commons.SignatureWithCertReferences;
import de.governikus.csl.uom.validate.commons.WritableSignature;
import de.governikus.csl.validate.svp.SignatureAttributesType;
import de.governikus.csl.validation.er.EvidenceRecord;
import de.governikus.csl.validation.tsp.ArchiveTimestamp;
import java.util.List;

public class AdESSignature
extends BaseSignature
implements SignatureWithCertReferences {
    private List<CertificateReference> signingCertificateReferences;
    private List<CertificateReference> completeCertificateReferences;
    private List<AdESSignature> counterSignatures;
    private SignatureAttributesType signatureAttributes;
    private List<EvidenceRecord> evidenceRecords;
    private List<? extends ArchiveTimestamp> archiveTimestamps;

    public List<CertificateReference> getSigningCertificateReferences() {
        return this.signingCertificateReferences;
    }

    public void setSigningCertificateReferences(List<CertificateReference> references) {
        this.signingCertificateReferences = references;
    }

    public List<CertificateReference> getCompleteCertificateReferences() {
        return this.completeCertificateReferences;
    }

    public void setCompleteCertificateReferences(List<CertificateReference> references) {
        this.completeCertificateReferences = references;
    }

    public void copyValues(AdESSignature so) {
        super.copyValues((WritableSignature)so);
        this.signingCertificateReferences = so.getSigningCertificateReferences();
        this.completeCertificateReferences = so.getCompleteCertificateReferences();
        this.signatureAttributes = so.getSignatureAttributes();
    }

    public List<AdESSignature> getCounterSignatures() {
        return this.counterSignatures;
    }

    public void setCounterSignatures(List<AdESSignature> counterSignatures) {
        this.counterSignatures = counterSignatures;
    }

    public SignatureAttributesType getSignatureAttributes() {
        return this.signatureAttributes;
    }

    public void setSignatureAttributes(SignatureAttributesType signatureAttributes) {
        this.signatureAttributes = signatureAttributes;
    }

    public List<EvidenceRecord> getEvidenceRecords() {
        return this.evidenceRecords;
    }

    public void setEvidenceRecords(List<EvidenceRecord> evidenceRecords) {
        this.evidenceRecords = evidenceRecords;
    }

    public List<? extends ArchiveTimestamp> getArchiveTimestamps() {
        return this.archiveTimestamps;
    }

    public void setArchiveTimestamps(List<? extends ArchiveTimestamp> archiveTimestamps) {
        this.archiveTimestamps = archiveTimestamps;
    }

    public SignatureClass getSignatureClass() {
        if (this.isCollectionNotEmpty(this.evidenceRecords)) {
            return SignatureClass.SIG_ERS;
        }
        if (this.isCollectionNotEmpty(this.archiveTimestamps)) {
            return SignatureClass.SIG_A;
        }
        return super.getSignatureClass();
    }
}

