/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.utils.secutils;

import de.governikus.utils.secutils.SaxParserHandler;
import de.governikus.utils.secutils.SecurityUtilsTransparentErrorHandler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.CodeSource;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.SchemaFactoryConfigurationError;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SecurityUtils {
    private static final Logger LOGGER;
    private static final XMLInputFactory XML_INPUT_FACTORY;
    private static final Map<String, Boolean> DOCUMENT_BUILDER_FACTORY_FEATURES;
    private static final Map<String, Boolean> SAX_PARSER_FACTORY_FEATURES;
    private static final Map<String, Boolean> SAX_TRANSFORMER_FACTORY_FEATURES;
    private static final Map<String, Object> SAX_TRANSFORMER_FACTORY_ATTRIBUTES;
    private static final Map<String, Boolean> TRANSFORMER_FACTORY_FEATURES;
    private static final Map<String, Object> TRANSFORMER_FACTORY_ATTRIBUTES;
    private static final Map<String, Object> SCHEMA_FACTORY_PROPERTIES;
    private static final Map<String, Boolean> SCHEMA_FACTORY_FEATURES;
    private static final Map<String, Object> XML_INPUT_FACTORY_PROPERTIES;
    private static final Map<String, Boolean> XML_READER_FEATURES;
    private static final Map<String, Object> VALIDATOR_PROPERTIES;
    private static final String ORCALE_RUNTIME_ENTITY_EXPANSION_LIMIT_KEY = "jdk.xml.entityExpansionLimit";
    private static final int DEFAULT_ORACLE_JDK_ENTITY_EXPANSION_LIMIT = 64000;
    private static final String DISALLOW_DOCTYPE_DECL_FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final String EXTERNAL_GENERAL_ENTITIES_FEATURE = "http://xml.org/sax/features/external-general-entities";
    private static final String EXTERNAL_PARAMETER_ENTITIES_FEATURE = "http://xml.org/sax/features/external-parameter-entities";
    private static final String LOAD_EXTERNAL_DTD_FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static int entityExpansionLimit;

    private SecurityUtils() {
        throw new IllegalStateException("SecurityUtils is a static utility class!");
    }

    private static void logCheckResult(String checkText, boolean result) {
        if (result) {
            LOGGER.info("{}: passed.", (Object)checkText);
        } else {
            LOGGER.error("{}: failed!", (Object)checkText);
        }
    }

    public static XMLStreamReader protectFileAgainstXXE(File file) throws IOException, XMLStreamException {
        if (file == null) {
            return null;
        }
        return XML_INPUT_FACTORY.createXMLStreamReader(new FileInputStream(file));
    }

    public static File createSecurePathname(String relativeFilename) throws IOException {
        if (relativeFilename == null) {
            return null;
        }
        return SecurityUtils.createSecurePathname(new File("."), relativeFilename);
    }

    public static File createSecurePathname(File rootPathEntry, String relativeFilename) throws IOException {
        if (rootPathEntry == null || relativeFilename == null) {
            return null;
        }
        File newPathname = new File(rootPathEntry, relativeFilename).getCanonicalFile();
        if (!SecurityUtils.isChildFileEntryOf(rootPathEntry, newPathname)) {
            throw new IOException("Potential path-slip attack detected");
        }
        return newPathname;
    }

    public static boolean isChildFileEntryOf(File rootPathEntry, File childFileEntry) throws IOException {
        if (rootPathEntry == null || childFileEntry == null) {
            return false;
        }
        File tempDir = childFileEntry.getCanonicalFile();
        File canonicalPathname = rootPathEntry.getCanonicalFile();
        while ((tempDir = tempDir.getParentFile()) != null) {
            if (!tempDir.equals(canonicalPathname)) continue;
            return true;
        }
        return false;
    }

    public static void protectFactoryAgainstXXE(XMLInputFactory factory) {
        SecurityUtils.protectXmlInputFactory(null, factory);
    }

    private static void protectXmlInputFactory(StringBuilder sb, XMLInputFactory xmlInputFactory) {
        if (xmlInputFactory == null) {
            return;
        }
        for (Map.Entry<String, Object> property : XML_INPUT_FACTORY_PROPERTIES.entrySet()) {
            try {
                xmlInputFactory.setProperty(property.getKey(), property.getValue());
            }
            catch (IllegalArgumentException e) {
                if (sb == null) continue;
                sb.append("Cannot set property '" + property.getKey() + "' on XMLInputFactory '" + SecurityUtils.getJaxpImplementationInfo(xmlInputFactory.getClass()) + "'!\n");
            }
        }
    }

    public static void protectFactoryAgainstXXE(Validator validator) {
        SecurityUtils.protectValidator(null, validator);
    }

    private static void protectValidator(StringBuilder sb, Validator validator) {
        if (validator == null) {
            return;
        }
        for (Map.Entry<String, Object> property : VALIDATOR_PROPERTIES.entrySet()) {
            try {
                validator.setProperty(property.getKey(), property.getValue());
            }
            catch (IllegalArgumentException | SAXNotRecognizedException | SAXNotSupportedException e) {
                if (sb == null) continue;
                sb.append("Cannot set property '" + property.getKey() + "' on Validator '" + SecurityUtils.getJaxpImplementationInfo(validator.getClass()) + "'!\n");
            }
        }
    }

    public static void protectFactoryAgainstXXE(SchemaFactory factory) {
        SecurityUtils.protectSchemaFactory(null, factory);
    }

    private static void protectSchemaFactory(StringBuilder sb, SchemaFactory schemaFactory) {
        if (schemaFactory == null) {
            return;
        }
        for (Map.Entry<String, Boolean> feature : SCHEMA_FACTORY_FEATURES.entrySet()) {
            try {
                schemaFactory.setFeature(feature.getKey(), feature.getValue());
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException e) {
                if (sb == null) continue;
                sb.append("Cannot set feature '" + feature.getKey() + "' on SchemaFactory '" + SecurityUtils.getJaxpImplementationInfo(schemaFactory.getClass()) + "'!\n");
            }
        }
        for (Map.Entry<String, Object> property : SCHEMA_FACTORY_PROPERTIES.entrySet()) {
            try {
                schemaFactory.setProperty(property.getKey(), property.getValue());
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException e) {
                if (sb == null) continue;
                sb.append("Cannot set property '" + property.getKey() + "' on SchemaFactory '" + SecurityUtils.getJaxpImplementationInfo(schemaFactory.getClass()) + "'!\n");
            }
        }
    }

    public static void protectFactoryAgainstXXE(TransformerFactory factory) {
        SecurityUtils.protectTransformerFactory(null, factory);
    }

    private static void protectTransformerFactory(StringBuilder sb, TransformerFactory transformerFactory) {
        if (transformerFactory == null) {
            return;
        }
        for (Map.Entry<String, Boolean> feature : TRANSFORMER_FACTORY_FEATURES.entrySet()) {
            try {
                transformerFactory.setFeature(feature.getKey(), feature.getValue());
            }
            catch (TransformerConfigurationException e) {
                if (sb == null) continue;
                sb.append("Cannot set feature '" + feature.getKey() + "' on TransformerFactory '" + SecurityUtils.getJaxpImplementationInfo(transformerFactory.getClass()) + "'!\n");
            }
        }
        for (Map.Entry<String, Object> attribute : TRANSFORMER_FACTORY_ATTRIBUTES.entrySet()) {
            try {
                transformerFactory.setAttribute(attribute.getKey(), attribute.getValue());
            }
            catch (IllegalArgumentException e) {
                if (sb == null) continue;
                sb.append("Cannot set attribute '" + attribute.getKey() + "' on TransformerFactory '" + SecurityUtils.getJaxpImplementationInfo(transformerFactory.getClass()) + "'!\n");
            }
        }
    }

    public static void protectFactoryAgainstXXE(SAXTransformerFactory factory) {
        SecurityUtils.protectSaxTransformerFactory(null, factory);
    }

    private static void protectSaxTransformerFactory(StringBuilder sb, SAXTransformerFactory saxTransformerFactory) {
        if (saxTransformerFactory == null) {
            return;
        }
        for (Map.Entry<String, Boolean> feature : SAX_TRANSFORMER_FACTORY_FEATURES.entrySet()) {
            try {
                saxTransformerFactory.setFeature(feature.getKey(), feature.getValue());
            }
            catch (TransformerConfigurationException e) {
                if (sb == null) continue;
                sb.append("Cannot set feature '" + feature.getKey() + "' on SAXTransformerFactory '" + SecurityUtils.getJaxpImplementationInfo(saxTransformerFactory.getClass()) + "'!\n");
            }
        }
        for (Map.Entry<String, Object> attribute : SAX_TRANSFORMER_FACTORY_ATTRIBUTES.entrySet()) {
            try {
                saxTransformerFactory.setAttribute(attribute.getKey(), attribute.getValue());
            }
            catch (IllegalArgumentException e) {
                if (sb == null) continue;
                sb.append("Cannot set attribute '" + attribute.getKey() + "' on SAXTransformerFactory '" + SecurityUtils.getJaxpImplementationInfo(saxTransformerFactory.getClass()) + "'!\n");
            }
        }
    }

    public static void protectFactoryAgainstXXE(SAXParserFactory factory) {
        SecurityUtils.protectSaxParserFactory(null, factory);
    }

    private static void protectSaxParserFactory(StringBuilder sb, SAXParserFactory saxParserFactory) {
        if (saxParserFactory == null) {
            return;
        }
        for (Map.Entry<String, Boolean> feature : SAX_PARSER_FACTORY_FEATURES.entrySet()) {
            try {
                saxParserFactory.setFeature(feature.getKey(), feature.getValue());
            }
            catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e) {
                if (sb == null) continue;
                sb.append("Cannot set feature '" + feature.getKey() + "' on SAXParserFactory '" + SecurityUtils.getJaxpImplementationInfo(saxParserFactory.getClass()) + "'!\n");
            }
        }
        saxParserFactory.setXIncludeAware(false);
    }

    public static void protectReaderAgainstXXE(XMLReader reader) {
        SecurityUtils.protectXMLReader(null, reader);
    }

    private static void protectXMLReader(StringBuilder sb, XMLReader xmlReader) {
        if (xmlReader == null) {
            return;
        }
        for (Map.Entry<String, Boolean> feature : XML_READER_FEATURES.entrySet()) {
            try {
                xmlReader.setFeature(feature.getKey(), feature.getValue());
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException e) {
                if (sb == null) continue;
                sb.append("Cannot set feature '" + feature.getKey() + "' on XMLReader '" + SecurityUtils.getJaxpImplementationInfo(xmlReader.getClass()) + "'!\n");
            }
        }
    }

    public static void protectFactoryAgainstXXE(DocumentBuilderFactory factory) {
        SecurityUtils.protectDocumentBuilderFactory(null, factory);
    }

    private static void protectDocumentBuilderFactory(StringBuilder sb, DocumentBuilderFactory documentBuilderFactory) {
        block6: {
            if (documentBuilderFactory == null) {
                return;
            }
            for (Map.Entry<String, Boolean> feature : DOCUMENT_BUILDER_FACTORY_FEATURES.entrySet()) {
                try {
                    documentBuilderFactory.setFeature(feature.getKey(), feature.getValue());
                }
                catch (ParserConfigurationException e) {
                    if (sb == null) continue;
                    sb.append("Cannot set feature '" + feature.getKey() + "' on DocumentBuilderFactory '" + SecurityUtils.getJaxpImplementationInfo(documentBuilderFactory.getClass()) + "'!\n");
                }
            }
            try {
                documentBuilderFactory.setXIncludeAware(false);
            }
            catch (UnsupportedOperationException e) {
                if (sb == null) break block6;
                sb.append("Setting of 'XIncludeAwareness' is not supported for DocumentBuilderFactory '" + SecurityUtils.getJaxpImplementationInfo(documentBuilderFactory.getClass()) + "'!\n");
            }
        }
        documentBuilderFactory.setExpandEntityReferences(false);
    }

    public static boolean isDoctypeDeclarationAllowed(DocumentBuilderFactory factory) throws ParserConfigurationException {
        return !factory.getFeature(DISALLOW_DOCTYPE_DECL_FEATURE);
    }

    public static void enableDoctypeDeclarations(DocumentBuilderFactory factory) {
        SecurityUtils.enableDoctypeDeclarations(null, factory);
    }

    private static void enableDoctypeDeclarations(StringBuilder sb, DocumentBuilderFactory documentBuilderFactory) {
        block2: {
            try {
                documentBuilderFactory.setFeature(DISALLOW_DOCTYPE_DECL_FEATURE, false);
            }
            catch (ParserConfigurationException e) {
                if (sb == null) break block2;
                sb.append("Cannot set feature 'http://apache.org/xml/features/disallow-doctype-decl' on DocumentBuilderFactory '" + SecurityUtils.getJaxpImplementationInfo(documentBuilderFactory.getClass()) + "'!\n");
            }
        }
    }

    public static int getJAXPEntityExpansionLimit() {
        return entityExpansionLimit;
    }

    private static String getJaxpImplementationInfo(Class<?> componentClass) {
        try {
            CodeSource source = componentClass.getProtectionDomain().getCodeSource();
            if (source == null) {
                return MessageFormat.format("{0} [no code source]", componentClass.getName());
            }
            return MessageFormat.format("{0} [loaded from {1}]", componentClass.getName(), source.getLocation());
        }
        catch (SecurityException ex) {
            return MessageFormat.format("{0} [loaded from <UNAVAILABLE>]", componentClass.getName());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean checkForExternalEntityExpansionPrevention(DocumentBuilderFactory factory) throws IOException {
        try {
            if (SecurityUtils.isDoctypeDeclarationAllowed(factory)) {
                return SecurityUtils.checkForExternalEntityExpansionPreventionDocDeclAllowed(factory);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try (InputStream is = SecurityUtils.class.getResourceAsStream("/xxe.xml");){
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new SecurityUtilsTransparentErrorHandler());
            documentBuilder.parse(is);
            boolean bl = false;
            return bl;
        }
        catch (FileNotFoundException ex) {
            return false;
        }
        catch (ParserConfigurationException | SAXException ex) {
            if (!(ex instanceof SAXParseException)) throw new IOException("checkForExternalEntityExpansionPrevention(DocumentBuilderFactory) does not work!", ex);
            if (!ex.getMessage().contains(DISALLOW_DOCTYPE_DECL_FEATURE)) throw new IOException("checkForExternalEntityExpansionPrevention(DocumentBuilderFactory) does not work!", ex);
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean checkForExternalEntityExpansionPreventionDocDeclAllowed(DocumentBuilderFactory factory) throws IOException {
        try (InputStream is = SecurityUtils.class.getResourceAsStream("/xxe.xml");){
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(is);
            String content = doc.getElementsByTagName("foo").item(0).getTextContent();
            boolean bl = "".equals(content);
            return bl;
        }
        catch (FileNotFoundException ex) {
            return false;
        }
        catch (ParserConfigurationException | DOMException | SAXException ex) {
            throw new IOException("checkForExternalEntityExpansionPreventionDocDeclAllowed(DocumentBuilderFactory) does not work!", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean checkForExternalEntityExpansionPrevention(SAXParserFactory factory) throws IOException {
        try (InputStream is = SecurityUtils.class.getResourceAsStream("/xxe.xml");){
            SaxParserHandler handler = new SaxParserHandler();
            factory.newSAXParser().parse(is, (DefaultHandler)handler);
            if ("foo".equals(handler.getLastTagName())) {
                boolean bl = !"xxe".equals(handler.getLastTagValue());
                return bl;
            }
            throw new IOException("checkForExternalEntityExpansionPrevention(SAXParserFactory) does not work!");
        }
        catch (FileNotFoundException ex) {
            return false;
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            if (!(ex instanceof SAXException)) throw new IOException("checkForExternalEntityExpansionPrevention(SAXParserFactory) does not work!", ex);
            if (!ex.getMessage().contains(DISALLOW_DOCTYPE_DECL_FEATURE)) throw new IOException("checkForExternalEntityExpansionPrevention(SAXParserFactory) does not work!", ex);
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean checkForExternalEntityExpansionPrevention(XMLReader reader) throws IOException {
        try (InputStream is = SecurityUtils.class.getResourceAsStream("/xxe.xml");){
            SaxParserHandler handler = new SaxParserHandler();
            reader.setContentHandler(handler);
            reader.setErrorHandler(handler);
            reader.parse(new InputSource(is));
            if ("foo".equals(handler.getLastTagName())) {
                boolean bl = !"xxe".equals(handler.getLastTagValue());
                return bl;
            }
            throw new IOException("checkForExternalEntityExpansionPrevention(SAXParserFactory) check does not work!");
        }
        catch (FileNotFoundException ex) {
            return false;
        }
        catch (SAXException ex) {
            if (!(ex instanceof SAXException)) throw new IOException("checkForExternalEntityExpansionPrevention(SAXParserFactory) check does not work!", ex);
            if (!ex.getMessage().contains(DISALLOW_DOCTYPE_DECL_FEATURE)) throw new IOException("checkForExternalEntityExpansionPrevention(SAXParserFactory) check does not work!", ex);
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean checkForExternalEntityExpansionPrevention(XMLInputFactory factory) throws IOException {
        try (InputStream xxeStream = SecurityUtils.class.getResourceAsStream("/xxe.xml");){
            XMLStreamReader reader = factory.createXMLStreamReader(xxeStream);
            boolean bl = SecurityUtils.checkForExternalEntityExpansionPrevention(reader);
            return bl;
        }
        catch (XMLStreamException ex) {
            throw new IOException("checkForExternalEntityExpansionPrevention(XMLInputFactory) check does not work!", ex);
        }
    }

    protected static boolean checkForExternalEntityExpansionPrevention(XMLStreamReader reader) throws IOException {
        String tagName = "";
        String content = "";
        try {
            while (reader.hasNext()) {
                int eventType = reader.next();
                if (eventType != 1) continue;
                tagName = reader.getName().getLocalPart();
                content = reader.getElementText();
                if (!"foo".equals(tagName)) continue;
                return !"xxe".equals(content);
            }
            throw new IOException("checkForExternalEntityExpansionPrevention(XMLStreamReader) check does not work!");
        }
        catch (XMLStreamException ex) {
            if (ex.getNestedException() instanceof FileNotFoundException && ex.getMessage().contains("xxe")) {
                return false;
            }
            if (ex instanceof XMLStreamException && ex.getMessage().contains("xxe")) {
                return true;
            }
            throw new IOException("checkForExternalEntityExpansionPrevention(XMLStreamReader) check does not work!", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkForExternalSchemaAccessPrevention(SchemaFactory factory) throws IOException {
        try (InputStream is = SecurityUtils.class.getResourceAsStream("/externalSchema.xsd");){
            factory.newSchema(new StreamSource(is));
            boolean bl = false;
            return bl;
        }
        catch (SAXException ex) {
            if (ex.getMessage().contains("accessExternal")) {
                return true;
            }
            if (ex.getMessage().contains("xml:lang")) {
                return false;
            }
            if (ex.getMessage().contains("pol:EvaluatedValidationPolicyType")) {
                return false;
            }
            if (!ex.getMessage().contains("xxe:ExternalSchemaElementType")) throw new IOException("checkForExternalSchemaAccess(SchemaFactory) check does not work!", ex);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean checkForEntityExpansionLimit(DocumentBuilderFactory factory) throws IOException {
        String entiyExpansionLimitExceedingXML = SecurityUtils.createEntityExpansionLimitExceedingXML(entityExpansionLimit);
        try (ByteArrayInputStream is = new ByteArrayInputStream(entiyExpansionLimitExceedingXML.getBytes(StandardCharsets.UTF_8));){
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.parse(is);
            boolean bl = false;
            return bl;
        }
        catch (ParserConfigurationException | SAXException ex) {
            if (!(ex instanceof SAXException)) throw new IOException("checkForEntityExpansionLimit(DocumentBuilderFactory) check does not work!", ex);
            if (ex.getMessage().contains("limit")) return true;
            if (!ex.getMessage().contains("Grenzwert")) throw new IOException("checkForEntityExpansionLimit(DocumentBuilderFactory) check does not work!", ex);
            return true;
        }
    }

    private static String createEntityExpansionLimitExceedingXML(int limit) {
        StringBuilder sb = new StringBuilder("<?xml version=\"1.0\"?>\n<!DOCTYPE lolz [\n <!ENTITY lol \"a\">\n <!ELEMENT lolz (#PCDATA)>\n <!ENTITY lol1 \"&lol;&lol;\">");
        int maxRows = (int)Math.ceil(Math.log(limit) / Math.log(2.0));
        for (int rows = 2; rows <= maxRows; ++rows) {
            sb.append("\n <!ENTITY lol");
            sb.append((Object)rows);
            sb.append(" \"");
            for (int cnt = 1; cnt <= 2; ++cnt) {
                sb.append("&lol");
                sb.append((Object)(rows - 1));
                sb.append(";");
            }
            sb.append("\">");
        }
        sb.append("\n]>\n<lolz>&lol");
        sb.append((Object)maxRows);
        sb.append(";</lolz>");
        return sb.toString();
    }

    static {
        StringBuilder sb;
        LOGGER = LoggerFactory.getLogger(SecurityUtils.class);
        XML_INPUT_FACTORY = XMLInputFactory.newInstance();
        DOCUMENT_BUILDER_FACTORY_FEATURES = new HashMap<String, Boolean>();
        SAX_PARSER_FACTORY_FEATURES = new HashMap<String, Boolean>();
        SAX_TRANSFORMER_FACTORY_FEATURES = new HashMap<String, Boolean>();
        SAX_TRANSFORMER_FACTORY_ATTRIBUTES = new HashMap<String, Object>();
        TRANSFORMER_FACTORY_FEATURES = new HashMap<String, Boolean>();
        TRANSFORMER_FACTORY_ATTRIBUTES = new HashMap<String, Object>();
        SCHEMA_FACTORY_PROPERTIES = new HashMap<String, Object>();
        SCHEMA_FACTORY_FEATURES = new HashMap<String, Boolean>();
        XML_INPUT_FACTORY_PROPERTIES = new HashMap<String, Object>();
        XML_READER_FEATURES = new HashMap<String, Boolean>();
        VALIDATOR_PROPERTIES = new HashMap<String, Object>();
        if (LOGGER.isDebugEnabled()) {
            sb = new StringBuilder("JAXP implementing classes in use:");
            try {
                sb.append("\n  javax.xml.parsers.DocumentBuilderFactory: ");
                sb.append(DocumentBuilderFactory.newInstance().getClass().getName());
            }
            catch (javax.xml.parsers.FactoryConfigurationError ex) {
                sb.append("<FactoryConfigurationError>");
            }
            try {
                sb.append("\n  javax.xml.parsers.SAXParserFactory: ");
                sb.append(SAXParserFactory.newInstance().getClass().getName());
            }
            catch (javax.xml.parsers.FactoryConfigurationError ex) {
                sb.append("<FactoryConfigurationError>");
            }
            try {
                sb.append("\n  javax.xml.stream.XMLEventFactory: ");
                sb.append(XMLEventFactory.newInstance().getClass().getName());
            }
            catch (FactoryConfigurationError ex) {
                sb.append("<FactoryConfigurationError>");
            }
            try {
                sb.append("\n  javax.xml.stream.XMLInputFactory: ");
                sb.append(XMLInputFactory.newInstance().getClass().getName());
            }
            catch (FactoryConfigurationError ex) {
                sb.append("<FactoryConfigurationError>");
            }
            try {
                sb.append("\n  javax.xml.stream.XMLOutputFactory: ");
                sb.append(XMLOutputFactory.newInstance().getClass().getName());
            }
            catch (FactoryConfigurationError ex) {
                sb.append("<FactoryConfigurationError>");
            }
            try {
                sb.append("\n  javax.xml.transform.TransformerFactory: ");
                sb.append(TransformerFactory.newInstance().getClass().getName());
            }
            catch (TransformerFactoryConfigurationError ex) {
                sb.append("<TransformerFactoryConfigurationError>");
            }
            try {
                sb.append("\n  javax.xml.validation.SchemaFactory: ");
                sb.append(SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").getClass().getName());
            }
            catch (IllegalArgumentException ex) {
                sb.append("<IllegalArgumentException>");
            }
            catch (SchemaFactoryConfigurationError ex) {
                sb.append("<SchemaFactoryConfigurationError>");
            }
            try {
                sb.append("\n  javax.xml.xpath.XPathFactory: ");
                sb.append(XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom").getClass().getName());
            }
            catch (XPathFactoryConfigurationException ex) {
                sb.append("<XPathFactoryConfigurationException>");
            }
            LOGGER.debug(sb.toString());
        }
        DOCUMENT_BUILDER_FACTORY_FEATURES.put("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        DOCUMENT_BUILDER_FACTORY_FEATURES.put(DISALLOW_DOCTYPE_DECL_FEATURE, Boolean.TRUE);
        DOCUMENT_BUILDER_FACTORY_FEATURES.put(EXTERNAL_GENERAL_ENTITIES_FEATURE, Boolean.FALSE);
        DOCUMENT_BUILDER_FACTORY_FEATURES.put(EXTERNAL_PARAMETER_ENTITIES_FEATURE, Boolean.FALSE);
        DOCUMENT_BUILDER_FACTORY_FEATURES.put(LOAD_EXTERNAL_DTD_FEATURE, Boolean.FALSE);
        SAX_PARSER_FACTORY_FEATURES.put("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        SAX_PARSER_FACTORY_FEATURES.put(DISALLOW_DOCTYPE_DECL_FEATURE, Boolean.TRUE);
        SAX_PARSER_FACTORY_FEATURES.put(EXTERNAL_GENERAL_ENTITIES_FEATURE, Boolean.FALSE);
        SAX_PARSER_FACTORY_FEATURES.put(EXTERNAL_PARAMETER_ENTITIES_FEATURE, Boolean.FALSE);
        SAX_PARSER_FACTORY_FEATURES.put(LOAD_EXTERNAL_DTD_FEATURE, Boolean.FALSE);
        SAX_TRANSFORMER_FACTORY_FEATURES.put("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        SAX_TRANSFORMER_FACTORY_ATTRIBUTES.put("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        SAX_TRANSFORMER_FACTORY_ATTRIBUTES.put("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        TRANSFORMER_FACTORY_FEATURES.put("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        TRANSFORMER_FACTORY_ATTRIBUTES.put("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        TRANSFORMER_FACTORY_ATTRIBUTES.put("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        SCHEMA_FACTORY_FEATURES.put("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        SCHEMA_FACTORY_PROPERTIES.put("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        SCHEMA_FACTORY_PROPERTIES.put("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        VALIDATOR_PROPERTIES.put("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        VALIDATOR_PROPERTIES.put("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        XML_INPUT_FACTORY_PROPERTIES.put("javax.xml.stream.supportDTD", Boolean.FALSE);
        XML_INPUT_FACTORY_PROPERTIES.put("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        XML_READER_FEATURES.put("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        XML_READER_FEATURES.put(DISALLOW_DOCTYPE_DECL_FEATURE, Boolean.TRUE);
        XML_READER_FEATURES.put(EXTERNAL_GENERAL_ENTITIES_FEATURE, Boolean.FALSE);
        XML_READER_FEATURES.put(EXTERNAL_PARAMETER_ENTITIES_FEATURE, Boolean.FALSE);
        XML_READER_FEATURES.put(LOAD_EXTERNAL_DTD_FEATURE, Boolean.FALSE);
        SecurityUtils.protectFactoryAgainstXXE(XML_INPUT_FACTORY);
        try {
            entityExpansionLimit = Integer.parseInt(System.getProperty(ORCALE_RUNTIME_ENTITY_EXPANSION_LIMIT_KEY));
        }
        catch (NumberFormatException ex) {
            entityExpansionLimit = 64000;
        }
        sb = new StringBuilder();
        Object factory = DocumentBuilderFactory.newInstance();
        SecurityUtils.protectDocumentBuilderFactory(sb, (DocumentBuilderFactory)factory);
        try {
            SecurityUtils.logCheckResult("Checking DocumentBuilderFactory for XXE prevention", SecurityUtils.checkForExternalEntityExpansionPrevention((DocumentBuilderFactory)factory));
        }
        catch (IOException ex) {
            LOGGER.error("Checking DocumentBuilderFactory for XXE prevention failed!", (Throwable)ex);
        }
        factory = SAXParserFactory.newInstance();
        SecurityUtils.protectSaxParserFactory(sb, (SAXParserFactory)factory);
        try {
            SecurityUtils.logCheckResult("Checking SAXParserFactory for XXE prevention", SecurityUtils.checkForExternalEntityExpansionPrevention((SAXParserFactory)factory));
        }
        catch (IOException ex) {
            LOGGER.error("Checking SAXParserFactory for XXE prevention failed!", (Throwable)ex);
        }
        try {
            factory = SAXParserFactory.newInstance();
            SAXParser parser = ((SAXParserFactory)factory).newSAXParser();
            XMLReader reader = parser.getXMLReader();
            SecurityUtils.protectXMLReader(sb, reader);
            SecurityUtils.logCheckResult("Checking XMLReader for XXE prevention", SecurityUtils.checkForExternalEntityExpansionPrevention(reader));
        }
        catch (Exception ex) {
            LOGGER.error("Checking XMLReader for XXE prevention failed!", (Throwable)ex);
        }
        try {
            factory = XMLInputFactory.newInstance();
            SecurityUtils.protectXmlInputFactory(sb, (XMLInputFactory)factory);
            XMLStreamReader reader = ((XMLInputFactory)factory).createXMLStreamReader(SecurityUtils.class.getResourceAsStream("/xxe.xml"));
            SecurityUtils.logCheckResult("Checking XMLInputFactory for XXE prevention", SecurityUtils.checkForExternalEntityExpansionPrevention(reader));
        }
        catch (Exception ex) {
            LOGGER.error("Checking XMLInputFactory for XXE prevention failed!", (Throwable)ex);
        }
        factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        SecurityUtils.protectSchemaFactory(sb, (SchemaFactory)factory);
        try {
            SecurityUtils.logCheckResult("Checking SchemaFactory for external schema access prevention", SecurityUtils.checkForExternalSchemaAccessPrevention((SchemaFactory)factory));
        }
        catch (IOException ex) {
            LOGGER.error("Checking SchemaFactory for external schema access prevention failed!", (Throwable)ex);
        }
        if (sb.length() > 0) {
            sb.insert(0, "JAXP features/attributes settings, that failed (this is not necessarly an error):\n");
            LOGGER.warn(sb.toString());
        }
    }
}

