/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.setup.validation.plugin;

import de.governikus.csl.demail.DeMailMimePlugin;
import de.governikus.csl.demail.confirmation.DeMailConfirmationPlugin;
import de.governikus.csl.setup.validation.ValidationProcessorSetup;
import de.governikus.csl.setup.validation.plugin.DeMailMimePluginBuilder;
import de.governikus.csl.setup.validation.plugin.PluginBuilder;
import de.governikus.csl.setup.validation.plugin.XAdESPluginBuilder;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.validation.ValidatePlugin;
import de.governikus.csl.xades.XAdESPlugin;

public class DeMailPluginBuilder
implements PluginBuilder {
    @Override
    public ValidatePlugin build(ValidationProcessorSetup setup) {
        DeMailMimePluginBuilder dmBuilder = new DeMailMimePluginBuilder();
        String deMailMimePluginID = dmBuilder.getID();
        DeMailMimePlugin deMailMimePlugin = (DeMailMimePlugin)setup.getConfiguredPlugin(deMailMimePluginID);
        deMailMimePlugin.setDocumentValidationCriteria(DeMailMimePlugin.getAllKnownDocumentValidationCriteria());
        deMailMimePlugin.setCustomSignatureValidationCriteria(DeMailMimePlugin.getAllKnownSignatureValidationCriteria());
        XAdESPluginBuilder pBuilder = new XAdESPluginBuilder();
        String xadesPluginID = pBuilder.getID();
        XAdESPlugin xadesPlugin = (XAdESPlugin)setup.getConfiguredPlugin(xadesPluginID);
        if (xadesPlugin == null) {
            setup.addXAdESPlugin();
        }
        xadesPlugin = (XAdESPlugin)setup.getConfiguredPlugin(xadesPluginID);
        DeMailConfirmationPlugin dmVerifier = new DeMailConfirmationPlugin(xadesPlugin, deMailMimePlugin);
        dmVerifier.setDocumentValidationCriteria(DeMailConfirmationPlugin.getAllKnownDocumentValidationCriteria());
        dmVerifier.setCustomSignatureValidationCriteria(DeMailConfirmationPlugin.getAllKnownSignatureValidationCriteria());
        return dmVerifier;
    }

    @Override
    public String getID() {
        return Plugin.PluginID.VALIDATE_DEMAIL.getID();
    }
}

