/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.setup.validation.plugin;

import de.governikus.csl.asic.AsicPlugin;
import de.governikus.csl.cades.CAdESPlugin;
import de.governikus.csl.ers.ERSPlugin;
import de.governikus.csl.setup.validation.ValidationProcessorSetup;
import de.governikus.csl.setup.validation.plugin.CAdESPluginBuilder;
import de.governikus.csl.setup.validation.plugin.ERSPluginBuilder;
import de.governikus.csl.setup.validation.plugin.PluginBuilder;
import de.governikus.csl.setup.validation.plugin.TSPPluginBuilder;
import de.governikus.csl.setup.validation.plugin.XAdESPluginBuilder;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.validation.ValidatePlugin;
import de.governikus.csl.validation.tsp.TSPPlugin;
import de.governikus.csl.xades.XAdESPlugin;

public class ASiCPluginBuilder
implements PluginBuilder {
    @Override
    public ValidatePlugin build(ValidationProcessorSetup setup) {
        XAdESPluginBuilder pBuilder = new XAdESPluginBuilder();
        String xadesPluginID = pBuilder.getID();
        XAdESPlugin xadesPlugin = (XAdESPlugin)setup.getConfiguredPlugin(xadesPluginID);
        if (xadesPlugin == null) {
            setup.addXAdESPlugin();
        }
        xadesPlugin = (XAdESPlugin)setup.getConfiguredPlugin(xadesPluginID);
        CAdESPluginBuilder cBuilder = new CAdESPluginBuilder();
        String cadesPluginID = cBuilder.getID();
        CAdESPlugin cadesPlugin = (CAdESPlugin)setup.getConfiguredPlugin(cadesPluginID);
        if (cadesPlugin == null) {
            setup.addCAdESPlugin();
        }
        cadesPlugin = (CAdESPlugin)setup.getConfiguredPlugin(cadesPluginID);
        ERSPluginBuilder eBuilder = new ERSPluginBuilder();
        String ersPluginID = eBuilder.getID();
        ERSPlugin ersPlugin = (ERSPlugin)setup.getConfiguredPlugin(ersPluginID);
        if (ersPlugin == null) {
            setup.addERSPlugin();
        }
        ersPlugin = (ERSPlugin)setup.getConfiguredPlugin(ersPluginID);
        TSPPluginBuilder tBuilder = new TSPPluginBuilder();
        String tspPluginID = tBuilder.getID();
        TSPPlugin tspPlugin = (TSPPlugin)setup.getConfiguredPlugin(tspPluginID);
        if (tspPlugin == null) {
            setup.addTSPPlugin();
        }
        tspPlugin = (TSPPlugin)setup.getConfiguredPlugin(tspPluginID);
        AsicPlugin aVerifier = new AsicPlugin(xadesPlugin, cadesPlugin, ersPlugin, tspPlugin);
        return aVerifier;
    }

    @Override
    public String getID() {
        return Plugin.PluginID.VALIDATE_ASIC.getID();
    }
}

