/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.setup.validation;

import de.governikus.CompInfo.ComponentInfo;
import de.governikus.csl.algorithm_catalog.AlgorithmCatalog;
import de.governikus.csl.algorithm_catalog.AlgorithmCatalogException;
import de.governikus.csl.algorithm_catalog.AlgorithmCatalogManager;
import de.governikus.csl.core.impl.RevocationValue;
import de.governikus.csl.cvs.client.DynamicCVSClient;
import de.governikus.csl.cvs.client.HttpRelayClient;
import de.governikus.csl.cvs.client.model.CertificateValidationRequest;
import de.governikus.csl.setup.validation.AlgorithmCatalogData;
import de.governikus.csl.setup.validation.SetupException;
import de.governikus.csl.setup.validation.TLDescriptor;
import de.governikus.csl.setup.validation.plugin.ASiCPluginBuilder;
import de.governikus.csl.setup.validation.plugin.AttributeCertificatePluginBuilder;
import de.governikus.csl.setup.validation.plugin.CAdESPluginBuilder;
import de.governikus.csl.setup.validation.plugin.CRLPluginBuilder;
import de.governikus.csl.setup.validation.plugin.DeMailMimePluginBuilder;
import de.governikus.csl.setup.validation.plugin.DeMailPluginBuilder;
import de.governikus.csl.setup.validation.plugin.ERSPluginBuilder;
import de.governikus.csl.setup.validation.plugin.JAdESPluginBuilder;
import de.governikus.csl.setup.validation.plugin.OCSPPluginBuilder;
import de.governikus.csl.setup.validation.plugin.OSCIPluginBuilder;
import de.governikus.csl.setup.validation.plugin.PAdESPluginBuilder;
import de.governikus.csl.setup.validation.plugin.PluginBuilder;
import de.governikus.csl.setup.validation.plugin.SMIMEPluginBuilder;
import de.governikus.csl.setup.validation.plugin.TSPPluginBuilder;
import de.governikus.csl.setup.validation.plugin.X509PluginBuilder;
import de.governikus.csl.setup.validation.plugin.XAIPPluginBuilder;
import de.governikus.csl.setup.validation.plugin.XAdESPluginBuilder;
import de.governikus.csl.setup.validation.plugin.ZipPluginBuilder;
import de.governikus.csl.transport.HttpClient;
import de.governikus.csl.transport.TransportFactoryInitializer;
import de.governikus.csl.tsl.InvalidTLSignatureHandlingApproach;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.configuration.ProxyConfiguration;
import de.governikus.csl.uom.configuration.ProxyConfigurationImpl;
import de.governikus.csl.uom.core.AlgorithmServiceFacade;
import de.governikus.csl.uom.impl.FileDocumentImpl;
import de.governikus.csl.uom.impl.ResourceDocument;
import de.governikus.csl.uom.jcebase.CertificateBase;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.util.TempDataManagerImpl;
import de.governikus.csl.uom.validate.TLType;
import de.governikus.csl.uom.validate.ValidateProcessor;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.csl.validation.Configuration;
import de.governikus.csl.validation.ForwardingCertificateValidator;
import de.governikus.csl.validation.ValidatePlugin;
import de.governikus.csl.validation.ValidationCriterion;
import de.governikus.csl.validation.ValidationRequestProcessor;
import de.governikus.csl.validation.algorithm.SecuredAlgorithmCatalog;
import de.governikus.csl.validation.circuitbreaker.CircuitBreakerOptions;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.CriteriaFactory;
import de.governikus.csl.validation.policy.PolicyProviderManager;
import de.governikus.csl.validation.revocation.crl.CRLRequester;
import de.governikus.csl.validation.x509.CertificateValidator;
import de.governikus.csl.validation.x509.NonValidatingCertValidator;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import javax.cache.Cache;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationProcessorSetup {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidationProcessorSetup.class);
    private static final String DEFAULT_ALGO_CAT_RESOURCE = "algo_cat_sogis_plus.xml-signed.xml";
    private static final String DEFAULT_ALGO_CAT_JAR = "csl_algo_catalog_files.jar";
    private static final ComponentInfo componentInfo = new ComponentInfo("csl_setup.version");
    protected boolean buildCalled = false;
    protected Configuration config = new Configuration();
    protected CRLRequester crlRequester;
    protected boolean sendNoCacheHeader = false;
    protected Map<String, String> ldapEnv;
    protected CircuitBreakerOptions circuitBreakerOptions;
    protected int cacheTime = 1800000;
    protected Cache<CertificateBase, RevocationValue> cache;
    protected TempDataManager tempDataManager;
    protected List<TLDescriptor> tlFiles;
    protected Map<String, ValidatePlugin> configuredPlugins = new HashMap<String, ValidatePlugin>();
    protected boolean createExecutorService = false;
    protected ExecutorService executorService;
    protected String relayURL;
    protected boolean checkSigningCertificates = true;
    protected DynamicCVSClient cvsClient;
    private Supplier<String> tokenProvider;
    private AlgorithmManager algorithmManager;
    private Map<String, AlgorithmCatalogData> algoCatalogFiles;
    private List<? extends Certificate> trustedAlgoCatalogSigningCertificates;
    private AlgorithmCatalogData defaultAlgorithmCatalogFile;
    private List<? extends Certificate> relaySigningCertificates;
    private HttpClient transportFactory;
    private PolicyProviderManager policyProviderManager;

    public static ComponentInfo getComponentInfo() {
        return componentInfo;
    }

    public ValidateProcessor buildValidationProcessor() throws SetupException {
        if (this.buildCalled) {
            throw new SetupException("Build method was already called before!");
        }
        CryptoProviderUtil.registerBouncyCastleIfNotAvailable();
        if (this.tempDataManager == null) {
            this.tempDataManager = new TempDataManagerImpl("csl_validation_service");
        }
        if (this.policyProviderManager == null) {
            this.policyProviderManager = new PolicyProviderManager();
        }
        this.config.setPolicyProviderManager(this.policyProviderManager);
        if (this.algorithmManager == null) {
            this.algorithmManager = new AlgorithmServiceFacade();
        }
        this.config.setAlgorithmManager(this.algorithmManager);
        SecuredAlgorithmCatalog catalogManager = new SecuredAlgorithmCatalog();
        catalogManager.setAllowedCertificates(this.trustedAlgoCatalogSigningCertificates);
        catalogManager.setBrokenSignatureHandlingInstruction(InvalidTLSignatureHandlingApproach.USE_TL_BUT_INVALIDATE_RESULTS);
        this.addAlgorithmCatalogsToManager(catalogManager);
        this.setDefaultAlgorithmCatalog(catalogManager);
        this.config.setAlgorithmCatalog((AlgorithmCatalogManager)catalogManager);
        List signatureCriterias = null;
        signatureCriterias = CriteriaFactory.getAllBasicCritieria((boolean)true);
        this.configureRelay();
        this.config.setBasicCriterias(signatureCriterias);
        this.buildCalled = true;
        return new ValidationRequestProcessor(this.config, this.tempDataManager);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void configureRelay() throws SetupException {
        if (this.checkSigningCertificates) {
            if (this.cvsClient != null) {
                this.configureExternalRelayFromCvsClient();
                return;
            } else {
                if (this.relayURL == null) throw new SetupException("Not enough information provided to create basic validation criteria. A relayURL or cvsClient must be set.");
                this.configureExternalRelayFromUrl();
            }
            return;
        } else {
            this.configureNoCertificateValidation();
        }
    }

    private void addAlgorithmCatalogsToManager(SecuredAlgorithmCatalog catalogManager) throws SetupException {
        if (this.algoCatalogFiles != null) {
            for (Map.Entry<String, AlgorithmCatalogData> entry : this.algoCatalogFiles.entrySet()) {
                String algoCatKey = "";
                try {
                    AlgorithmCatalogData algoData;
                    algoCatKey = entry.getKey();
                    AlgorithmCatalog catalog = catalogManager.addCatalog(algoCatKey, (algoData = entry.getValue()).getCatalog());
                    if (catalog == null || algoData.getUrl() == null || algoData.getUrl().trim().isEmpty()) continue;
                    catalog.getCatalogMetaData().setDownloadURL(algoData.getUrl().trim());
                }
                catch (AlgorithmCatalogException | IOException | JAXBException e) {
                    throw new SetupException(String.format("Unable to load algorithm catalog for key '%s'!", algoCatKey), e);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setDefaultAlgorithmCatalog(SecuredAlgorithmCatalog catalogManager) throws SetupException {
        if (this.defaultAlgorithmCatalogFile != null) {
            try {
                AlgorithmCatalog defaultCat = catalogManager.setDefaultCatalog(this.defaultAlgorithmCatalogFile.getCatalog());
                if (defaultCat == null) return;
                defaultCat.getCatalogMetaData().setDownloadURL(this.defaultAlgorithmCatalogFile.getUrl());
                return;
            }
            catch (AlgorithmCatalogException | IOException | IllegalArgumentException | JAXBException e) {
                String msg = String.format("Unable load default algorithm catalog '%s'!", this.defaultAlgorithmCatalogFile.getUrl());
                throw new SetupException(msg, e);
            }
        }
        if (this.algoCatalogFiles != null && !this.algoCatalogFiles.isEmpty()) return;
        LOGGER.warn("Neither a default nor a vendor specific algorithm catalog was set. Trying to load an possibly outdated fallback default catalog from '{}'", (Object)DEFAULT_ALGO_CAT_JAR);
        try {
            catalogManager.setDefaultCatalog(DEFAULT_ALGO_CAT_RESOURCE);
            return;
        }
        catch (AlgorithmCatalogException | IOException | IllegalArgumentException | JAXBException e) {
            String msg = "Unable to load default algorithm catalog resource '{}' from '{}'.";
            msg = String.format(msg, DEFAULT_ALGO_CAT_RESOURCE, DEFAULT_ALGO_CAT_JAR);
            throw new SetupException(msg, e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public ValidateProcessor build() {
        if (this.buildCalled) {
            throw new IllegalStateException("Build method was already called before!");
        }
        CryptoProviderUtil.registerBouncyCastleIfNotAvailable();
        if (this.tempDataManager == null) {
            this.tempDataManager = new TempDataManagerImpl("csl_validation_service");
        }
        if (this.policyProviderManager == null) {
            this.policyProviderManager = new PolicyProviderManager();
        }
        this.config.setPolicyProviderManager(this.policyProviderManager);
        if (this.algorithmManager == null) {
            this.algorithmManager = new AlgorithmServiceFacade();
        }
        this.config.setAlgorithmManager(this.algorithmManager);
        SecuredAlgorithmCatalog catalogManager = new SecuredAlgorithmCatalog();
        catalogManager.setAllowedCertificates(this.trustedAlgoCatalogSigningCertificates);
        catalogManager.setBrokenSignatureHandlingInstruction(InvalidTLSignatureHandlingApproach.USE_TL_BUT_INVALIDATE_RESULTS);
        if (this.algoCatalogFiles != null) {
            for (Map.Entry<String, AlgorithmCatalogData> entry : this.algoCatalogFiles.entrySet()) {
                String algoCatKey = "";
                try {
                    AlgorithmCatalogData algoData;
                    algoCatKey = entry.getKey();
                    AlgorithmCatalog catalog = catalogManager.addCatalog(algoCatKey, (algoData = entry.getValue()).getCatalog());
                    if (catalog == null || algoData.getUrl() == null || algoData.getUrl().trim().isEmpty()) continue;
                    catalog.getCatalogMetaData().setDownloadURL(algoData.getUrl().trim());
                }
                catch (AlgorithmCatalogException | IOException | JAXBException e) {
                    LOGGER.error("Cannot load algorithm catalog for key '{}'!", (Object)algoCatKey, (Object)e);
                }
            }
        }
        if (this.defaultAlgorithmCatalogFile != null) {
            try {
                AlgorithmCatalog defaultCat = catalogManager.setDefaultCatalog(this.defaultAlgorithmCatalogFile.getCatalog());
                if (defaultCat != null) {
                    defaultCat.getCatalogMetaData().setDownloadURL(this.defaultAlgorithmCatalogFile.getUrl());
                }
            }
            catch (AlgorithmCatalogException | IOException | IllegalArgumentException | JAXBException e) {
                LOGGER.error("Cannot load default algorithm catalog '{}'!", (Object)this.defaultAlgorithmCatalogFile.getUrl(), (Object)e);
            }
        } else if (this.algoCatalogFiles == null || this.algoCatalogFiles.isEmpty()) {
            LOGGER.warn("Neither a default nor a vendor specific algorithm catalog was set. Trying to load an evtl. outdated fallback default catalog from '{}'...", (Object)DEFAULT_ALGO_CAT_JAR);
            try {
                catalogManager.setDefaultCatalog(DEFAULT_ALGO_CAT_RESOURCE);
            }
            catch (AlgorithmCatalogException | IOException | IllegalArgumentException | JAXBException e) {
                LOGGER.error("Cannot load default algorithm catalog resource '{}' from '{}'!", new Object[]{DEFAULT_ALGO_CAT_RESOURCE, DEFAULT_ALGO_CAT_JAR, e});
            }
        }
        this.config.setAlgorithmCatalog((AlgorithmCatalogManager)catalogManager);
        List<ValidationCriterion<? super Signature, ? super SignatureValidationResult, ? super SignatureValidationContext>> signatureCriterias = null;
        if (this.checkSigningCertificates) {
            if (this.cvsClient != null) {
                signatureCriterias = this.configureExternalRelayFromCvsClient();
            } else {
                if (this.relayURL == null) throw new IllegalArgumentException("Not enough information provided to create basic validation criteria. A relayURL or cvsClient must be set.");
                signatureCriterias = this.configureExternalRelayFromUrl();
            }
        } else {
            signatureCriterias = this.configureNoCertificateValidation();
        }
        this.config.setBasicCriterias(signatureCriterias);
        this.buildCalled = true;
        return new ValidationRequestProcessor(this.config, this.tempDataManager);
    }

    protected List<ValidationCriterion<? super Signature, ? super SignatureValidationResult, ? super SignatureValidationContext>> configureExternalRelayFromUrl() {
        LOGGER.info("External relay service '{}' is configured, initializing the validation criteria.", (Object)this.relayURL);
        List signatureCriterias = CriteriaFactory.getAllBasicCritieria((boolean)true);
        try {
            HttpRelayClient relay = new HttpRelayClient(this.relayURL, this.getHttpClient(), this.sendNoCacheHeader, CertificateValidationRequest.class.getClassLoader());
            relay.setBearerTokenSupplier(this.tokenProvider);
            if (this.relaySigningCertificates != null && !this.relaySigningCertificates.isEmpty()) {
                relay.setTrustedCertificates(this.relaySigningCertificates);
            }
            this.cvsClient = relay;
            this.config.setCertificateValidationService((DynamicCVSClient)relay);
            this.config.setCertValidator((CertificateValidator)new ForwardingCertificateValidator((DynamicCVSClient)relay));
        }
        catch (URISyntaxException | JAXBException e) {
            LOGGER.error("Cannot instantiate external relay service '{}'!", (Object)this.relayURL, (Object)e);
        }
        return signatureCriterias;
    }

    protected List<ValidationCriterion<? super Signature, ? super SignatureValidationResult, ? super SignatureValidationContext>> configureExternalRelayFromCvsClient() {
        List signatureCriterias = CriteriaFactory.getAllBasicCritieria((boolean)true);
        this.config.setCertificateValidationService(this.cvsClient);
        this.config.setCertValidator((CertificateValidator)new ForwardingCertificateValidator(this.cvsClient));
        return signatureCriterias;
    }

    protected HttpClient getHttpClient() {
        if (this.transportFactory == null) {
            this.transportFactory = TransportFactoryInitializer.initialiseTransportFactory((ProxyConfiguration)new ProxyConfigurationImpl());
        }
        return this.transportFactory;
    }

    protected List<ValidationCriterion<? super Signature, ? super SignatureValidationResult, ? super SignatureValidationContext>> configureNoCertificateValidation() {
        LOGGER.warn("!!!! Validation of signing certificates is DISABLED !!!!");
        List signatureCriterias = CriteriaFactory.getAllBasicCritieria((boolean)true);
        this.config.setCertValidator((CertificateValidator)new NonValidatingCertValidator(this.policyProviderManager));
        return signatureCriterias;
    }

    public ValidationProcessorSetup addPAdESPlugin() {
        this.instantiatePlugin(new PAdESPluginBuilder());
        return this;
    }

    public ValidationProcessorSetup addAttributeCertificatePlugin() {
        this.instantiatePlugin(new AttributeCertificatePluginBuilder());
        return this;
    }

    public ValidationProcessorSetup addOSCIPlugin() {
        this.instantiatePlugin(new OSCIPluginBuilder());
        return this;
    }

    public ValidationProcessorSetup addSMIMEPlugin() {
        this.instantiatePlugin(new SMIMEPluginBuilder());
        return this;
    }

    public ValidationProcessorSetup addCAdESPlugin() {
        this.instantiatePlugin(new CAdESPluginBuilder());
        return this;
    }

    public ValidationProcessorSetup addJAdESPlugin() {
        this.instantiatePlugin(new JAdESPluginBuilder());
        return this;
    }

    public ValidationProcessorSetup addXAdESPlugin() {
        this.instantiatePlugin(new XAdESPluginBuilder());
        return this;
    }

    public ValidationProcessorSetup addXAIPPlugin() {
        this.instantiatePlugin(new XAIPPluginBuilder());
        return this;
    }

    public ValidationProcessorSetup addTSPPlugin() {
        this.instantiatePlugin(new TSPPluginBuilder());
        return this;
    }

    public ValidationProcessorSetup addASiCPlugin() {
        this.instantiatePlugin(new ASiCPluginBuilder());
        return this;
    }

    public ValidationProcessorSetup addDeMailPlugin() {
        this.instantiatePlugin(new DeMailMimePluginBuilder());
        this.instantiatePlugin(new DeMailPluginBuilder());
        return this;
    }

    public ValidationProcessorSetup addX509Plugin() {
        this.instantiatePlugin(new X509PluginBuilder());
        return this;
    }

    public ValidationProcessorSetup addOCSPPlugin() {
        this.instantiatePlugin(new OCSPPluginBuilder());
        return this;
    }

    public ValidationProcessorSetup addZipPlugin() {
        this.instantiatePlugin(new ZipPluginBuilder());
        return this;
    }

    public ValidationProcessorSetup addCRLPlugin() {
        this.instantiatePlugin(new CRLPluginBuilder());
        return this;
    }

    public ValidationProcessorSetup addERSPlugin() {
        this.instantiatePlugin(new ERSPluginBuilder());
        return this;
    }

    public ValidationProcessorSetup addCustomPluginBuilder(PluginBuilder pb) {
        this.instantiatePlugin(pb);
        return this;
    }

    public ValidatePlugin getConfiguredPlugin(String id) {
        return this.configuredPlugins.get(id);
    }

    public ValidationProcessorSetup setRelayURL(String url) {
        this.relayURL = url;
        return this;
    }

    public ValidationProcessorSetup setRelayURL(String url, List<? extends Certificate> trustedRelayCertificates) {
        this.relayURL = url;
        this.relaySigningCertificates = trustedRelayCertificates;
        return this;
    }

    public ValidationProcessorSetup setRelay(DynamicCVSClient cvsClient) {
        this.cvsClient = cvsClient;
        return this;
    }

    private void instantiatePlugin(PluginBuilder pb) {
        String pluginID = pb.getID();
        if (this.configuredPlugins.containsKey(pluginID)) {
            return;
        }
        try {
            ValidatePlugin plugin = pb.build(this);
            this.addConfiguredPlugin(plugin);
            this.configuredPlugins.put(pluginID, plugin);
        }
        catch (NoClassDefFoundError e) {
            LOGGER.error("A requested CSL validation plugin is not available on the classpath: '{}'!", (Object)pluginID, (Object)e);
        }
    }

    private void addConfiguredPlugin(ValidatePlugin pVerifier) {
        LOGGER.info("Adding CSL validation plugin to configuration: {}", (Object)pVerifier.getID());
        this.config.addPlugin(pVerifier);
    }

    public Configuration getConfig() {
        return this.config;
    }

    public ValidationProcessorSetup setCache(Cache<CertificateBase, RevocationValue> cache) {
        this.cache = cache;
        return this;
    }

    public ValidationProcessorSetup setCacheTime(int cacheTime) {
        this.cacheTime = cacheTime;
        return this;
    }

    public TempDataManager getTempDataManager() {
        return this.tempDataManager;
    }

    public ValidationProcessorSetup setTempDataManager(TempDataManager tempDataManager) {
        this.tempDataManager = tempDataManager;
        return this;
    }

    public ValidationProcessorSetup setTempDataFolder(File tempDataFolder) {
        if (tempDataFolder != null) {
            this.tempDataManager = new TempDataManagerImpl(tempDataFolder);
        }
        return this;
    }

    public ValidationProcessorSetup setTempDataFolder(String tempDataFolder) {
        if (tempDataFolder != null) {
            this.tempDataManager = new TempDataManagerImpl(tempDataFolder);
        }
        return this;
    }

    public ValidationProcessorSetup setCreateExecutorService(boolean createExecutorService) {
        this.createExecutorService = createExecutorService;
        return this;
    }

    public ValidationProcessorSetup setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public ValidationProcessorSetup setAlgorithmManager(AlgorithmManager algorithmManager) {
        this.algorithmManager = algorithmManager;
        return this;
    }

    public AlgorithmManager getAlgorithmManager() {
        return this.algorithmManager;
    }

    public ValidationProcessorSetup addTSL(String tl, String tlExtension, TLType tlType) {
        URL tlURL = this.getClass().getClassLoader().getResource(tl);
        if (tlURL == null) {
            LOGGER.error("Cannot resolve provided resource path of trusted list '{}'!", (Object)tl);
            return this;
        }
        LOGGER.info("Adding trusted list from '{}'", (Object)tlURL);
        URL tlExtensionURL = null;
        if (tlExtension != null) {
            tlExtensionURL = this.getClass().getClassLoader().getResource(tlExtension);
            if (tlExtensionURL == null) {
                LOGGER.error("Cannot resolve provided resource path of trusted list extension '{}'!", (Object)tlExtension);
                return this;
            }
            LOGGER.info("Adding trusted list extension from '{}'", (Object)tlExtensionURL);
        }
        return this.addTSL(tlURL, tlExtensionURL, tlType);
    }

    public ValidationProcessorSetup addTSL(URL tlURL, URL tlExtensionURL, TLType tlType) {
        if (this.tlFiles == null) {
            this.tlFiles = new ArrayList<TLDescriptor>();
        }
        this.tlFiles.add(new TLDescriptor(tlURL, tlExtensionURL, tlType));
        return this;
    }

    public ValidationProcessorSetup addTSL(Document tlURL, Document tlExtensionURL, TLType tlType) {
        if (this.tlFiles == null) {
            this.tlFiles = new ArrayList<TLDescriptor>();
        }
        this.tlFiles.add(new TLDescriptor(tlURL, tlExtensionURL, tlType));
        return this;
    }

    public ValidationProcessorSetup addAlgorithmCatalog(String key, String catalog) {
        URL resource = this.getClass().getClassLoader().getResource(catalog);
        if (resource == null) {
            LOGGER.error("Cannot resolve provided algorithm catalog resource name '{}'!", (Object)catalog);
            return this;
        }
        return this.addAlgorithmCatalog(key, (Document)new ResourceDocument(catalog), resource.getPath());
    }

    public ValidationProcessorSetup addAlgorithmCatalog(String key, Document catalog) {
        if (catalog == null) {
            return this;
        }
        if (this.algoCatalogFiles == null) {
            this.algoCatalogFiles = new HashMap<String, AlgorithmCatalogData>();
        }
        this.algoCatalogFiles.put(key, new AlgorithmCatalogData(catalog, null));
        return this;
    }

    public ValidationProcessorSetup addAlgorithmCatalog(String key, Document catalog, String downloadUrl) {
        if (catalog == null) {
            return this;
        }
        if (this.algoCatalogFiles == null) {
            this.algoCatalogFiles = new HashMap<String, AlgorithmCatalogData>();
        }
        this.algoCatalogFiles.put(key, new AlgorithmCatalogData(catalog, downloadUrl));
        return this;
    }

    public ValidationProcessorSetup addAlgorithmCatalog(String key, File catalogFile) {
        if (!catalogFile.exists()) {
            LOGGER.error("Provided algorithm catalog file '{}' does not exist!", (Object)catalogFile.getAbsolutePath());
            return this;
        }
        return this.addAlgorithmCatalog(key, (Document)new FileDocumentImpl(catalogFile, null), catalogFile.getAbsolutePath());
    }

    public ValidationProcessorSetup setDefaultAlgorithmCatalog(String catalog) {
        URL resource = this.getClass().getClassLoader().getResource(catalog);
        if (resource == null) {
            LOGGER.warn("Cannot resolve the given default algorithm catalog resource path '{}'!", (Object)catalog);
            return this;
        }
        return this.setDefaultAlgorithmCatalog((Document)new ResourceDocument(catalog));
    }

    public ValidationProcessorSetup setDefaultAlgorithmCatalog(Document catalog) {
        this.defaultAlgorithmCatalogFile = new AlgorithmCatalogData(catalog, null);
        return this;
    }

    public ValidationProcessorSetup setDefaultAlgorithmCatalog(Document catalog, String downloadUrl) {
        this.defaultAlgorithmCatalogFile = new AlgorithmCatalogData(catalog, downloadUrl);
        return this;
    }

    public ValidationProcessorSetup setDefaultAlgorithmCatalog(File catalogFile) {
        if (!catalogFile.exists()) {
            LOGGER.error("Provided default algorithm catalog file '{}' does not exist!", (Object)catalogFile);
            return this;
        }
        return this.setDefaultAlgorithmCatalog((Document)new FileDocumentImpl(catalogFile, null));
    }

    @Deprecated
    public ValidationProcessorSetup setTransportConfiguration(HttpClient httpClient, boolean sendNoCacheHeader, Map<String, String> ldapEnv) {
        return this.setHttpClient(httpClient, sendNoCacheHeader, ldapEnv);
    }

    public ValidationProcessorSetup setTransportConfiguration(String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword, String byPassedHostsString, boolean sendNoCacheHeader, Map<String, String> ldapEnv) {
        this.transportFactory = TransportFactoryInitializer.initialiseTransportFactory((String)proxyHost, (Integer)proxyPort, (String)proxyUser, (String)proxyPassword, (String)byPassedHostsString);
        this.sendNoCacheHeader = sendNoCacheHeader;
        this.ldapEnv = ldapEnv;
        return this;
    }

    public ValidationProcessorSetup setTransportConfiguration(String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword, List<String> byPassedHosts, boolean sendNoCacheHeader, Map<String, String> ldapEnv) {
        this.transportFactory = TransportFactoryInitializer.initialiseTransportFactory((String)proxyHost, (Integer)proxyPort, (String)proxyUser, (String)proxyPassword, byPassedHosts);
        this.sendNoCacheHeader = sendNoCacheHeader;
        this.ldapEnv = ldapEnv;
        return this;
    }

    public ValidationProcessorSetup setTransportConfiguration(String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword, boolean sendNoCacheHeader, Map<String, String> ldapEnv, String ... byPassedHosts) {
        this.transportFactory = TransportFactoryInitializer.initialiseTransportFactory((String)proxyHost, (Integer)proxyPort, (String)proxyUser, (String)proxyPassword, (String[])byPassedHosts);
        this.sendNoCacheHeader = sendNoCacheHeader;
        this.ldapEnv = ldapEnv;
        return this;
    }

    public ValidationProcessorSetup setCrlRequester(CRLRequester crlRequester) {
        this.crlRequester = crlRequester;
        return this;
    }

    public ValidationProcessorSetup setTrustedAlgoCatalogSigningCertificates(List<? extends Certificate> trustedAlgoCatalogSigningCertificates) {
        this.trustedAlgoCatalogSigningCertificates = trustedAlgoCatalogSigningCertificates;
        return this;
    }

    public List<? extends Certificate> getRelaySigningCertificates() {
        return this.relaySigningCertificates;
    }

    public ValidationProcessorSetup setRelaySigningCertificates(List<? extends Certificate> relaySigningCertificates) {
        this.relaySigningCertificates = relaySigningCertificates;
        return this;
    }

    public ValidationProcessorSetup disableSigningCertificateValidation() {
        this.checkSigningCertificates = false;
        return this;
    }

    @Deprecated
    public ValidationProcessorSetup disableSigningCertificateValidaiton() {
        return this.disableSigningCertificateValidation();
    }

    public void setHttpClient(HttpClient httpClient) {
        this.transportFactory = httpClient;
    }

    public ValidationProcessorSetup setHttpClient(HttpClient httpClient, boolean sendNoCacheHeader, Map<String, String> ldapEnv) {
        this.transportFactory = httpClient;
        this.sendNoCacheHeader = sendNoCacheHeader;
        this.ldapEnv = ldapEnv;
        return this;
    }

    public ValidationProcessorSetup setCircuitBreakerOptions(CircuitBreakerOptions circuitBreakerOptions) {
        this.circuitBreakerOptions = circuitBreakerOptions;
        return this;
    }

    public ValidationProcessorSetup setPolicyProviderManager(PolicyProviderManager policyProviderManager) {
        this.policyProviderManager = policyProviderManager;
        return this;
    }

    public ValidationProcessorSetup setTokenProvider(Supplier<String> tokenProvider) {
        this.tokenProvider = tokenProvider;
        return this;
    }
}

