/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.setup.validation;

import de.governikus.csc.keycloak.client.AccessTokenClient;
import de.governikus.csl.cvs.client.DynamicCVSClient;
import de.governikus.csl.filemanager.CategoryNotFoundException;
import de.governikus.csl.filemanager.FileHandler;
import de.governikus.csl.filemanager.FilemanagerException;
import de.governikus.csl.filemanager.client.FileManagerClient;
import de.governikus.csl.filemanager.client.FileManagerClientImplREST;
import de.governikus.csl.filemanager.client.FileManagerClientOIDCBuilder;
import de.governikus.csl.filemanager.client.FilemanagerClientOIDC;
import de.governikus.csl.filemanager.fileinfo.FileInfo;
import de.governikus.csl.setup.validation.AlgoCatEntry;
import de.governikus.csl.setup.validation.FileManagerDataDocument;
import de.governikus.csl.setup.validation.SetupException;
import de.governikus.csl.setup.validation.TrustedListEntry;
import de.governikus.csl.setup.validation.ValidateProcessorBuilderException;
import de.governikus.csl.setup.validation.ValidationProcessorSetup;
import de.governikus.csl.transport.HttpClient;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.validate.AlgorithmCatalog;
import de.governikus.csl.uom.validate.TLType;
import de.governikus.csl.uom.validate.ValidateProcessor;
import de.governikus.csl.validation.policy.PolicyProviderManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateProcessorBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidateProcessorBuilder.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidateProcessorBuilder.class);
    public static final String OFFICIAL_TL_DE = "OFFICIAL_TL_DE";
    public static final String OFFICIAL_TL_DE_EXTENSION = "OFFICIAL_TL_DE_EXTENSION";
    public static final String GOVERNIKUS_TL_DE = "GOVERNIKUS_TL_DE";
    public static final String GOVERNIKUS_TL_DE_EXTENSION = "GOVERNIKUS_TL_DE_EXTENSION";
    public static final String ALGORITHM_CATALOG_SOGIS_ETSI = "ALGORITHM_CATALOG_SOGIS_ETSI";
    public static final String ALGORITHM_CATALOG_SOGIS_PLUS = "ALGORITHM_CATALOG_SOGIS_PLUS";
    public static final String REST_RESOURCES = "/rest/resources/";
    private ValidationProcessorSetup setup = new ValidationProcessorSetup();
    public static final String DEFAULT_FILEMANAGERMASTER = "https://filemaster.itplr.governikus-asp.de/Filemanager";
    public static final String REST = "/rest";
    private String fileManagerMasterUrl = "https://filemaster.itplr.governikus-asp.de/Filemanager";
    private FileManagerClient fileManagerClient;
    private List<TrustedListEntry> trustedListEntryList = new ArrayList<TrustedListEntry>();
    private List<AlgoCatEntry> algoCatEntryList = new ArrayList<AlgoCatEntry>();
    private AccessTokenClient keycloakClient;
    private String jsonConfigFile;
    private FileHandler<byte[]> fileHandler;
    private boolean useDefaultValidationPlugins = true;
    public static final List<Plugin.PluginID> DEFAULT_PLUGIN_LIST = Collections.unmodifiableList(Arrays.asList(Plugin.PluginID.VALIDATE_XADES, Plugin.PluginID.VALIDATE_JADES, Plugin.PluginID.VALIDATE_SMIME, Plugin.PluginID.VALIDATE_XAIP, Plugin.PluginID.VALIDATE_CADES, Plugin.PluginID.VALIDATE_PADES, Plugin.PluginID.VALIDATE_TSP, Plugin.PluginID.VALIDATE_OSCI, Plugin.PluginID.VALIDATE_ZIP, Plugin.PluginID.VALIDATE_X509, Plugin.PluginID.VALIDATE_ASIC, Plugin.PluginID.VALIDATE_CRL, Plugin.PluginID.VALIDATE_DEMAIL_MIME, Plugin.PluginID.VALIDATE_DEMAIL, Plugin.PluginID.VALIDATE_OCSP, Plugin.PluginID.VALIDATE_ATTRIBUTECERT, Plugin.PluginID.VALIDATE_ERS));

    private ValidateProcessorBuilder() {
        this.initFileHandler();
    }

    @NonNull
    public static ValidateProcessorBuilder newBlancInstance() {
        return new ValidateProcessorBuilder().withDefaultPlugins(false);
    }

    @NonNull
    public static ValidateProcessorBuilder newInstance(@NonNull String cvsUrl) {
        if (cvsUrl == null) {
            throw new NullPointerException("cvsUrl is marked non-null but is null");
        }
        return new ValidateProcessorBuilder().cvsUrl(cvsUrl).addAlgocatSogisEtsi().addAlgocatSogisPlus();
    }

    @NonNull
    public static ValidateProcessorBuilder newInstanceWithOutPlugins(@NonNull String cvsUrl) {
        if (cvsUrl == null) {
            throw new NullPointerException("cvsUrl is marked non-null but is null");
        }
        return ValidateProcessorBuilder.newInstance(cvsUrl).withDefaultPlugins(false);
    }

    public ValidationProcessorSetup getValidationProcessorSetup() {
        return this.getSetup();
    }

    @NonNull
    public ValidateProcessorBuilder cvsUrl(@NonNull String cvsUrl) {
        if (cvsUrl == null) {
            throw new NullPointerException("cvsUrl is marked non-null but is null");
        }
        this.getSetup().setRelayURL(cvsUrl);
        return this;
    }

    @NonNull
    private ValidateProcessorBuilder withDefaultPlugins(boolean withDefaultPlugins) {
        this.setUseDefaultValidationPlugins(withDefaultPlugins);
        return this;
    }

    @NonNull
    public ValidateProcessorBuilder cvsUrlWithTrustedCerts(@NonNull String cvsUrl, @NonNull List<? extends Certificate> trustedRelayCertificates) {
        if (cvsUrl == null) {
            throw new NullPointerException("cvsUrl is marked non-null but is null");
        }
        if (trustedRelayCertificates == null) {
            throw new NullPointerException("trustedRelayCertificates is marked non-null but is null");
        }
        this.getSetup().setRelayURL(cvsUrl, trustedRelayCertificates);
        return this;
    }

    @NonNull
    public ValidateProcessorBuilder cvsClient(@NonNull DynamicCVSClient cvsClient) {
        if (cvsClient == null) {
            throw new NullPointerException("cvsClient is marked non-null but is null");
        }
        this.getSetup().setRelay(cvsClient);
        return this;
    }

    @NonNull
    public ValidateProcessorBuilder httpClient(HttpClient httpClient) {
        this.getSetup().setHttpClient(httpClient);
        return this;
    }

    @NonNull
    public ValidateProcessorBuilder fileHandler(FileHandler<byte[]> fileHandler) {
        this.fileHandler = fileHandler;
        return this;
    }

    @NonNull
    public ValidateProcessorBuilder addDefaultValidatePlugins() {
        DEFAULT_PLUGIN_LIST.forEach(pluginID -> this.addValidationPlugin((Plugin.PluginID)pluginID, true));
        return this;
    }

    public ValidateProcessorBuilder addValidationPlugin(@NonNull Plugin.PluginID pluginID) {
        if (pluginID == null) {
            throw new NullPointerException("pluginID is marked non-null but is null");
        }
        this.addValidationPlugin(pluginID, false);
        return this;
    }

    public void addValidationPlugin(@NonNull Plugin.PluginID pluginID, boolean isDefaultSet) {
        if (pluginID == null) {
            throw new NullPointerException("pluginID is marked non-null but is null");
        }
        switch (pluginID) {
            case VALIDATE_XADES: {
                this.getSetup().addXAdESPlugin();
                this.setUseDefaultValidationPlugins(isDefaultSet);
                break;
            }
            case VALIDATE_JADES: {
                this.getSetup().addJAdESPlugin();
                this.setUseDefaultValidationPlugins(isDefaultSet);
                break;
            }
            case VALIDATE_SMIME: {
                this.getSetup().addSMIMEPlugin();
                this.setUseDefaultValidationPlugins(isDefaultSet);
                break;
            }
            case VALIDATE_XAIP: {
                this.getSetup().addXAIPPlugin();
                this.setUseDefaultValidationPlugins(isDefaultSet);
                break;
            }
            case VALIDATE_CADES: {
                this.getSetup().addCAdESPlugin();
                this.setUseDefaultValidationPlugins(isDefaultSet);
                break;
            }
            case VALIDATE_PADES: {
                this.getSetup().addPAdESPlugin();
                this.setUseDefaultValidationPlugins(isDefaultSet);
                break;
            }
            case VALIDATE_TSP: {
                this.getSetup().addTSPPlugin();
                this.setUseDefaultValidationPlugins(isDefaultSet);
                break;
            }
            case VALIDATE_OSCI: {
                this.getSetup().addOSCIPlugin();
                this.setUseDefaultValidationPlugins(isDefaultSet);
                break;
            }
            case VALIDATE_ZIP: {
                this.getSetup().addZipPlugin();
                this.setUseDefaultValidationPlugins(isDefaultSet);
                break;
            }
            case VALIDATE_X509: {
                this.getSetup().addX509Plugin();
                this.setUseDefaultValidationPlugins(isDefaultSet);
                break;
            }
            case VALIDATE_ASIC: {
                this.getSetup().addASiCPlugin();
                this.setUseDefaultValidationPlugins(isDefaultSet);
                break;
            }
            case VALIDATE_CRL: {
                this.getSetup().addCRLPlugin();
                this.setUseDefaultValidationPlugins(isDefaultSet);
                break;
            }
            case VALIDATE_DEMAIL_MIME: 
            case VALIDATE_DEMAIL: {
                this.getSetup().addDeMailPlugin();
                this.setUseDefaultValidationPlugins(isDefaultSet);
                break;
            }
            case VALIDATE_OCSP: {
                this.getSetup().addOCSPPlugin();
                this.setUseDefaultValidationPlugins(isDefaultSet);
                break;
            }
            case VALIDATE_ATTRIBUTECERT: {
                this.getSetup().addAttributeCertificatePlugin();
                this.setUseDefaultValidationPlugins(isDefaultSet);
                break;
            }
            case VALIDATE_ERS: {
                this.getSetup().addERSPlugin();
                this.setUseDefaultValidationPlugins(isDefaultSet);
                break;
            }
            default: {
                throw new ValidateProcessorBuilderException("Unknown Plugin: " + pluginID.getID());
            }
        }
    }

    @NonNull
    public ValidateProcessorBuilder fileManagerClient(@NonNull FileManagerClient fileManagerClient) {
        if (fileManagerClient == null) {
            throw new NullPointerException("fileManagerClient is marked non-null but is null");
        }
        this.fileManagerClient = fileManagerClient;
        return this;
    }

    @NonNull
    public ValidateProcessorBuilder fileManagerUrl(@NonNull String fileManagerUrl) {
        if (fileManagerUrl == null) {
            throw new NullPointerException("fileManagerUrl is marked non-null but is null");
        }
        this.fileManagerMasterUrl = fileManagerUrl;
        return this;
    }

    @NonNull
    public ValidateProcessorBuilder policyProviderManager(@NonNull PolicyProviderManager policyProviderManager) {
        if (policyProviderManager == null) {
            throw new NullPointerException("policyProviderManager is marked non-null but is null");
        }
        this.getSetup().setPolicyProviderManager(policyProviderManager);
        return this;
    }

    @NonNull
    public ValidateProcessorBuilder keycloakClient(@NonNull AccessTokenClient keycloakClient) {
        if (keycloakClient == null) {
            throw new NullPointerException("keycloakClient is marked non-null but is null");
        }
        this.keycloakClient = keycloakClient;
        return this;
    }

    @NonNull
    public ValidateProcessorBuilder keycloakClient(@NonNull String jsonConfigFile) {
        if (jsonConfigFile == null) {
            throw new NullPointerException("jsonConfigFile is marked non-null but is null");
        }
        this.jsonConfigFile = jsonConfigFile;
        return this;
    }

    @NonNull
    private ValidateProcessorBuilder addOfficialTrustedListDe() {
        return this.addTrustedList(OFFICIAL_TL_DE, OFFICIAL_TL_DE_EXTENSION, TLType.OFFICIAL);
    }

    @NonNull
    private ValidateProcessorBuilder addGovernikusTrustedListDe() {
        return this.addTrustedList(GOVERNIKUS_TL_DE, GOVERNIKUS_TL_DE_EXTENSION, TLType.GOVERNIKUS);
    }

    @NonNull
    private ValidateProcessorBuilder addTrustedList(@NonNull String trustedList, @NonNull String trustedListExtension, @NonNull TLType trustedListType) {
        if (trustedList == null) {
            throw new NullPointerException("trustedList is marked non-null but is null");
        }
        if (trustedListExtension == null) {
            throw new NullPointerException("trustedListExtension is marked non-null but is null");
        }
        if (trustedListType == null) {
            throw new NullPointerException("trustedListType is marked non-null but is null");
        }
        TrustedListEntry trustedListEntry = new TrustedListEntry(trustedList, trustedListExtension, trustedListType);
        if (this.trustedListEntryList.contains(trustedListEntry)) {
            throw new ValidateProcessorBuilderException("TrustedList already added: " + trustedList + ", " + trustedListExtension + ", " + trustedListType);
        }
        this.trustedListEntryList.add(trustedListEntry);
        return this;
    }

    @NonNull
    public ValidateProcessorBuilder addAlgocatSogisPlus() {
        return this.addAlgoCatalog(AlgorithmCatalog.SOGIS_PLUS, ALGORITHM_CATALOG_SOGIS_PLUS);
    }

    @NonNull
    public ValidateProcessorBuilder addAlgocatSogisEtsi() {
        return this.addAlgoCatalog(AlgorithmCatalog.SOGIS_ETSI, ALGORITHM_CATALOG_SOGIS_ETSI);
    }

    @NonNull
    public ValidateProcessorBuilder addAlgoCatalog(@NonNull AlgorithmCatalog algorithmCatalog, @NonNull String fileName) {
        if (algorithmCatalog == null) {
            throw new NullPointerException("algorithmCatalog is marked non-null but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        AlgoCatEntry algoCatEntry = new AlgoCatEntry(algorithmCatalog, fileName);
        boolean alreadyPresent = this.algoCatEntryList.stream().map(AlgoCatEntry::getAlgorithmCatalog).anyMatch(arg_0 -> algorithmCatalog.equals(arg_0));
        if (alreadyPresent) {
            throw new ValidateProcessorBuilderException("AlgorithmCatalog already added: " + algorithmCatalog.name() + ", " + fileName);
        }
        this.algoCatEntryList.add(algoCatEntry);
        return this;
    }

    @NonNull
    public ValidateProcessorBuilder cvsSigningCert(List<? extends Certificate> relaySigningCertificates) {
        this.getSetup().setRelaySigningCertificates(relaySigningCertificates);
        return this;
    }

    @NonNull
    private void retrieveAlgorithmCatalogFromFileManager(AlgorithmCatalog algorithmCatalog, String name) {
        FileManagerDataDocument algoCat = Optional.ofNullable(name).map(this::downloadViaLatestFileInfo).map(t -> new FileManagerDataDocument((byte[])t, this.fileManagerMasterUrl + REST_RESOURCES + name)).orElse(null);
        if (algoCat == null) {
            throw new ValidateProcessorBuilderException("AlgorithmCatalog " + algorithmCatalog + ", " + name + " could not be retrieved from FileManager.");
        }
        this.getSetup().addAlgorithmCatalog(algorithmCatalog.name(), algoCat, algoCat.getUrl());
    }

    private void getAndAddTrustedList(@NonNull TrustedListEntry trustedListEntry) {
        if (trustedListEntry == null) {
            throw new NullPointerException("trustedListEntry is marked non-null but is null");
        }
        this.retrieveTrustedListFromFileManager(trustedListEntry.getTrustedList(), trustedListEntry.getTrustedListExtension(), trustedListEntry.getTrustedListType());
    }

    private void getAndAddAlgoCatalogs(@NonNull AlgoCatEntry algoCatEntry) {
        if (algoCatEntry == null) {
            throw new NullPointerException("algoCatEntry is marked non-null but is null");
        }
        this.retrieveAlgorithmCatalogFromFileManager(algoCatEntry.getAlgorithmCatalog(), algoCatEntry.getName());
    }

    @NonNull
    private ValidateProcessorBuilder retrieveTrustedListFromFileManager(String trustedList, String trustedListExtension, TLType trustedListType) {
        FileManagerDataDocument tl = Optional.ofNullable(trustedList).map(this::downloadViaLatestFileInfo).map(t -> new FileManagerDataDocument((byte[])t, this.fileManagerMasterUrl + REST_RESOURCES + trustedList)).orElse(null);
        FileManagerDataDocument tlExt = Optional.ofNullable(trustedListExtension).map(this::downloadViaLatestFileInfo).map(t -> new FileManagerDataDocument((byte[])t, this.fileManagerMasterUrl + REST_RESOURCES + trustedListExtension)).orElse(null);
        this.getSetup().addTSL(tl, tlExt, trustedListType);
        return this;
    }

    private byte[] downloadViaLatestFileInfo(String category) throws ValidateProcessorBuilderException {
        StopWatch stopWatch = new StopWatch("Getting category " + category);
        stopWatch.start();
        FileInfo fileInfo = this.getLatestFileInfo(category);
        byte[] fileContent = this.download(category, fileInfo);
        stopWatch.stop();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("%s took: %s", stopWatch.getMessage(), stopWatch.formatTime()));
        }
        return fileContent;
    }

    private byte[] download(String category, FileInfo fileInfo) {
        try {
            return (byte[])this.getOrCreateFileManagerClient().getFile(category, fileInfo.getName(), this.fileHandler);
        }
        catch (Exception e) {
            throw new ValidateProcessorBuilderException(e);
        }
    }

    private byte[] getContentAsByteArray(InputStream is) {
        if (is == null) {
            return new byte[0];
        }
        try {
            return Optional.of(IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8).getBytes(StandardCharsets.UTF_8)).orElse(null);
        }
        catch (IOException e) {
            throw new ValidateProcessorBuilderException(e);
        }
    }

    private FileInfo getLatestFileInfo(String category) throws ValidateProcessorBuilderException {
        try {
            return this.getOrCreateFileManagerClient().getMetadata(category, this.getDefaultIdOFCategory(category));
        }
        catch (FilemanagerException | IOException | URISyntaxException | NoSuchProviderException | CertificateException e) {
            throw new ValidateProcessorBuilderException(e);
        }
    }

    private String getDefaultIdOFCategory(@NonNull String category) throws CertificateException, URISyntaxException, IOException, NoSuchProviderException {
        if (category == null) {
            throw new NullPointerException("category is marked non-null but is null");
        }
        try {
            return this.getOrCreateFileManagerClient().getDefault(category);
        }
        catch (CategoryNotFoundException e) {
            throw new ValidateProcessorBuilderException(e.getMessage() + "  (" + this.getOrCreateFileManagerClient().getFileURLBase() + ")", e);
        }
        catch (FilemanagerException | IOException | URISyntaxException | NoSuchProviderException | CertificateException e) {
            throw new ValidateProcessorBuilderException(e);
        }
    }

    @NonNull
    private FileManagerClient getOrCreateFileManagerClient() throws CertificateException, URISyntaxException, IOException, NoSuchProviderException {
        if (this.fileManagerClient == null) {
            this.fileManagerClient = this.isKeyCloakInvolved() ? this.createFileManagerClientOIDC() : this.createFileManagerClientREST();
        }
        return this.fileManagerClient;
    }

    private boolean isKeyCloakInvolved() {
        return this.keycloakClient != null || this.jsonConfigFile != null;
    }

    @NonNull
    private FileManagerClient createFileManagerClientREST() throws URISyntaxException, CertificateException, IOException, NoSuchProviderException {
        return FileManagerClientImplREST.builder().url(this.getFileManagerRestUrl()).build();
    }

    @NonNull
    private FileManagerClient createFileManagerClientOIDC() throws URISyntaxException, CertificateException, IOException, NoSuchProviderException {
        FileManagerClientOIDCBuilder builder = (FileManagerClientOIDCBuilder)FilemanagerClientOIDC.builder().url(this.getFileManagerRestUrl());
        if (this.jsonConfigFile != null) {
            builder = builder.jsonConfig(this.jsonConfigFile);
        }
        if (this.keycloakClient != null) {
            builder = builder.keycloakClient(this.keycloakClient);
        }
        return builder.build();
    }

    private String getFileManagerRestUrl() {
        return this.fileManagerMasterUrl + REST;
    }

    @NonNull
    public ValidateProcessor build() {
        this.initFileManagerClient();
        this.checkValidatePlugins();
        this.initTrustedLists();
        this.initAlgorithmCatalogs();
        try {
            LOGGER.debug("Build processor");
            return this.getSetup().buildValidationProcessor();
        }
        catch (SetupException e) {
            throw new ValidateProcessorBuilderException(e);
        }
    }

    private void checkValidatePlugins() {
        if (this.useDefaultValidationPlugins) {
            this.addDefaultValidatePlugins();
        }
    }

    private void initFileHandler() {
        if (this.fileHandler == null) {
            this.fileHandler = this::getContentAsByteArray;
        }
    }

    private void initFileManagerClient() {
        try {
            this.getOrCreateFileManagerClient();
        }
        catch (IOException | URISyntaxException | NoSuchProviderException | CertificateException exception) {
            throw new ValidateProcessorBuilderException("Error while building FileMangerClient.", exception);
        }
    }

    private void initTrustedLists() {
        if (this.isNotEmpty(this.trustedListEntryList)) {
            LOGGER.debug("Downloading TLs from FileManager.");
            this.trustedListEntryList.forEach(this::getAndAddTrustedList);
        }
    }

    private void initAlgorithmCatalogs() {
        if (this.isNotEmpty(this.algoCatEntryList)) {
            LOGGER.debug("Downloading TLs from FileManager.");
            this.algoCatEntryList.forEach(this::getAndAddAlgoCatalogs);
        }
    }

    private boolean isNotEmpty(Collection<?> col) {
        return col != null && !col.isEmpty();
    }

    @Generated
    private ValidationProcessorSetup getSetup() {
        return this.setup;
    }

    @Generated
    private boolean isUseDefaultValidationPlugins() {
        return this.useDefaultValidationPlugins;
    }

    @Generated
    private void setUseDefaultValidationPlugins(boolean useDefaultValidationPlugins) {
        this.useDefaultValidationPlugins = useDefaultValidationPlugins;
    }
}

