/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.setup.validation;

import de.governikus.csl.core.impl.RevocationValue;
import de.governikus.csl.setup.validation.ExternalComponentInitializer;
import de.governikus.csl.uom.jcebase.CertificateBase;
import de.governikus.csl.uom.util.TempDataManager;
import java.io.Closeable;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.jsr107.Eh107Configuration;

public class LocalCacheInitializer
implements ExternalComponentInitializer {
    private Cache<CertificateBase, RevocationValue> cache;
    private TempDataManager tempDataManager;

    public LocalCacheInitializer(TempDataManager tempDataManager) {
        this.tempDataManager = tempDataManager;
    }

    @Override
    public void initialize() {
        String cacheName = "revocationValueCache";
        CachingProvider cachingProvider = Caching.getCachingProvider();
        CacheManager cacheManager = cachingProvider.getCacheManager();
        this.cache = cacheManager.getCache(cacheName, CertificateBase.class, RevocationValue.class);
        if (this.cache == null) {
            CacheConfiguration cacheConfiguration = CacheConfigurationBuilder.newCacheConfigurationBuilder(CertificateBase.class, RevocationValue.class, (Builder)ResourcePoolsBuilder.heap((long)150L)).build();
            this.cache = cacheManager.createCache(cacheName, Eh107Configuration.fromEhcacheCacheConfiguration((CacheConfiguration)cacheConfiguration));
        }
        this.tempDataManager.add((Closeable)cachingProvider);
        this.tempDataManager.add((Closeable)cacheManager);
        this.tempDataManager.add(this.cache);
    }

    public Cache<CertificateBase, RevocationValue> getCache() {
        return this.cache;
    }
}

