/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.CompInfo;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ComponentInfo {
    private static final String COMP_VERSION = "componentVersion";
    private static final String COMP_NAME = "componentName";
    private static final String COMP_REVISION = "componentRevision";
    private static final String COMP_BUILDTIME = "componentBuildTime";
    private static final String MAVEN_VERSION = "version";
    private static final String MAVEN_NAME = "artifactId";
    public static final String UNKNOWN_COMP_VERSION = "unknownComponentVersion";
    public static final String UNKNOWN_COMP_NAME = "unknownComponentName";
    public static final String UNKNOWN_COMP_REVISION = "unknownComponentRevision";
    public static final String UNKNOWN_COMP_BUILDTIME = "unknownComponentBuildTime";
    private Properties prop = new Properties();

    @Deprecated
    public ComponentInfo() {
    }

    public ComponentInfo(String fileName) {
        this.loadComponentInfo(fileName);
    }

    public ComponentInfo(String fileName, String groupId, String artifactId) {
        this.loadComponentInfo(fileName);
        this.loadMavenProperties(groupId, artifactId);
    }

    private void loadComponentInfo(String fileName) {
        this.loadResourceIntoProperies(fileName);
    }

    private void loadMavenProperties(String groupId, String artifactId) {
        this.loadResourceIntoProperies("META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties");
    }

    private void loadResourceIntoProperies(String fileName) {
        try (InputStream inputStream = this.getResourceAsStream(fileName);){
            if (inputStream != null) {
                this.prop.load(inputStream);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getComponentVersion() {
        return this.prop.getProperty(COMP_VERSION, this.prop.getProperty(MAVEN_VERSION, UNKNOWN_COMP_VERSION));
    }

    public boolean hasComponentVersion() {
        return !UNKNOWN_COMP_VERSION.equalsIgnoreCase(this.getComponentVersion());
    }

    public String getComponentName() {
        return this.prop.getProperty(COMP_NAME, this.prop.getProperty(MAVEN_NAME, UNKNOWN_COMP_NAME));
    }

    public String getComponentRevision() {
        return this.prop.getProperty(COMP_REVISION, UNKNOWN_COMP_REVISION);
    }

    public String getComponentBuildTime() {
        return this.prop.getProperty(COMP_BUILDTIME, UNKNOWN_COMP_BUILDTIME);
    }

    private InputStream getResourceAsStream(String resourcePath) {
        InputStream resourceStream = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            resourceStream = classLoader.getResourceAsStream(resourcePath);
        }
        if (resourceStream == null) {
            resourceStream = this.getClass().getClassLoader().getResourceAsStream(resourcePath);
        }
        return resourceStream;
    }
}

