/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.algorithm_identifier.impl;

import de.bos_bremen.algorithm_identifier.Filter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FilterUtil {
    public static <E> List<E> filter(List<E> list, Filter<E> ... filters) {
        ArrayList<E> filteredList = new ArrayList<E>();
        for (E item : list) {
            if (!FilterUtil.matchAllFilters(item, filters)) continue;
            filteredList.add(item);
        }
        return Collections.unmodifiableList(filteredList);
    }

    private static <E> boolean matchAllFilters(E item, Filter<E> ... filters) {
        for (Filter<E> filter : filters) {
            if (filter.match(item)) continue;
            return false;
        }
        return true;
    }
}

