/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.algorithm_identifier.impl;

import de.bos_bremen.algorithm_identifier.Algorithm;
import de.bos_bremen.algorithm_identifier.CipherAlgorithm;
import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.algorithm_identifier.PaddingAlgorithm;
import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.bos_bremen.algorithm_identifier.gen.AliasImpl;
import de.bos_bremen.algorithm_identifier.impl.CipherAlgorithmAlias;
import de.bos_bremen.algorithm_identifier.impl.DigestAlgorithmAlias;
import de.bos_bremen.algorithm_identifier.impl.PaddingAlgorithmAlias;
import de.bos_bremen.algorithm_identifier.impl.SignatureAlgorithmAlias;

public class AlgorithmAliasFactory {
    public static Algorithm create(AliasImpl alias) throws IllegalArgumentException {
        if (alias.getRef() instanceof CipherAlgorithm) {
            return new CipherAlgorithmAlias(alias);
        }
        if (alias.getRef() instanceof DigestAlgorithm) {
            return new DigestAlgorithmAlias(alias);
        }
        if (alias.getRef() instanceof PaddingAlgorithm) {
            return new PaddingAlgorithmAlias(alias);
        }
        if (alias.getRef() instanceof SignatureAlgorithm) {
            return new SignatureAlgorithmAlias(alias);
        }
        throw new IllegalArgumentException("Algorithm type unknown");
    }
}

