/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.algorithm_identifier;

import de.bos_bremen.algorithm_identifier.Algorithm;
import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.algorithm_identifier.Filter;
import de.bos_bremen.algorithm_identifier.PaddingAlgorithm;
import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.bos_bremen.algorithm_identifier.gen.SignatureAlgorithmBase;

public class FilterFactory {
    public static <T extends Algorithm> Filter<Algorithm> createTypeFilter(final Class<T> type) {
        return new Filter<Algorithm>(){

            @Override
            public boolean match(Algorithm algo) {
                return type.isInstance(algo);
            }
        };
    }

    public static Filter<Algorithm> createNameFilter(final String name) {
        return new Filter<Algorithm>(){

            @Override
            public boolean match(Algorithm algo) {
                return name.equalsIgnoreCase(algo.getName());
            }
        };
    }

    public static Filter<Algorithm> createOIDFilter(final String oid) {
        return new Filter<Algorithm>(){

            @Override
            public boolean match(Algorithm algo) {
                return oid.equalsIgnoreCase(algo.getOID());
            }
        };
    }

    public static Filter<Algorithm> createJCANameFilter(final String jcaName) {
        return new Filter<Algorithm>(){

            @Override
            public boolean match(Algorithm algo) {
                return jcaName.equalsIgnoreCase(algo.getJCAName());
            }
        };
    }

    public static Filter<Algorithm> createURIFilter(final String uri) {
        return new Filter<Algorithm>(){

            @Override
            public boolean match(Algorithm algo) {
                return uri.equalsIgnoreCase(algo.getURI());
            }
        };
    }

    public static Filter<Algorithm> createAnyIdentifierFilter(final String anyIdentifier) {
        return new Filter<Algorithm>(){

            @Override
            public boolean match(Algorithm algo) {
                return anyIdentifier.equalsIgnoreCase(algo.getJCAName()) || anyIdentifier.equalsIgnoreCase(algo.getName()) || anyIdentifier.equalsIgnoreCase(algo.getOID()) || anyIdentifier.equalsIgnoreCase(algo.getURI());
            }
        };
    }

    public static Filter<Algorithm> createDigestFilter(final int digestSize) {
        return new Filter<Algorithm>(){

            @Override
            public boolean match(Algorithm algo) {
                if (algo instanceof DigestAlgorithm) {
                    return ((DigestAlgorithm)algo).getDigestSize() == digestSize;
                }
                return false;
            }
        };
    }

    public static Filter<Algorithm> createSignatureFilter(final DigestAlgorithm digest) {
        return new Filter<Algorithm>(){

            @Override
            public boolean match(Algorithm algo) {
                if (algo instanceof SignatureAlgorithm) {
                    String sigDigName = ((SignatureAlgorithm)algo).getDigestAlgorithm().getName();
                    return digest.getName().equals(sigDigName);
                }
                return false;
            }
        };
    }

    public static Filter<Algorithm> createSignatureFilter(final PaddingAlgorithm padding) {
        return new Filter<Algorithm>(){

            @Override
            public boolean match(Algorithm algo) {
                if (algo instanceof SignatureAlgorithm) {
                    SignatureAlgorithm sigAlgo = (SignatureAlgorithm)algo;
                    if (padding == null) {
                        return sigAlgo.getPaddingAlgorithm() == null;
                    }
                    if (sigAlgo.getPaddingAlgorithm() != null) {
                        String sigPadName = sigAlgo.getPaddingAlgorithm().getName();
                        return padding.getName().equals(sigPadName);
                    }
                }
                return false;
            }
        };
    }

    public static Filter<Algorithm> createSignatureFilter(final SignatureAlgorithmBase base) {
        return new Filter<Algorithm>(){

            @Override
            public boolean match(Algorithm algo) {
                if (algo instanceof SignatureAlgorithm) {
                    return base.equals((Object)((SignatureAlgorithm)algo).getBaseAlgorithm());
                }
                return false;
            }
        };
    }
}

