/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.algorithm_identifier;

import de.bos_bremen.algorithm_identifier.Algorithm;
import de.bos_bremen.algorithm_identifier.CipherAlgorithm;
import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.algorithm_identifier.Filter;
import de.bos_bremen.algorithm_identifier.FilterFactory;
import de.bos_bremen.algorithm_identifier.PaddingAlgorithm;
import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.bos_bremen.algorithm_identifier.gen.AlgorithmListImpl;
import de.bos_bremen.algorithm_identifier.gen.AliasImpl;
import de.bos_bremen.algorithm_identifier.gen.FormatAlgorithm;
import de.bos_bremen.algorithm_identifier.gen.ObjectFactory;
import de.bos_bremen.algorithm_identifier.gen.SignatureAlgorithmBase;
import de.bos_bremen.algorithm_identifier.impl.AlgorithmAliasFactory;
import de.bos_bremen.algorithm_identifier.impl.FilterUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class AlgorithmService {
    private static List<Algorithm> algorithms;

    public static List<CipherAlgorithm> getAllCipher() {
        Filter<Algorithm> typeFilter = FilterFactory.createTypeFilter(CipherAlgorithm.class);
        return FilterUtil.filter(algorithms, typeFilter);
    }

    public static List<DigestAlgorithm> getAllDigest() {
        Filter<Algorithm> typeFilter = FilterFactory.createTypeFilter(DigestAlgorithm.class);
        return FilterUtil.filter(algorithms, typeFilter);
    }

    public static List<PaddingAlgorithm> getAllPadding() {
        Filter<Algorithm> typeFilter = FilterFactory.createTypeFilter(PaddingAlgorithm.class);
        return FilterUtil.filter(algorithms, typeFilter);
    }

    public static List<SignatureAlgorithm> getAllSignature() {
        Filter<Algorithm> typeFilter = FilterFactory.createTypeFilter(SignatureAlgorithm.class);
        return FilterUtil.filter(algorithms, typeFilter);
    }

    public static List<Algorithm> getForFilter(Filter<Algorithm> ... filters) {
        return FilterUtil.filter(algorithms, filters);
    }

    public static List<Algorithm> getForOID(String oid) {
        Filter<Algorithm> oidFilter = FilterFactory.createOIDFilter(oid);
        return AlgorithmService.getForFilter(oidFilter);
    }

    public static CipherAlgorithm getCipherForOID(String oid) {
        return AlgorithmService.getForOID(oid, CipherAlgorithm.class);
    }

    public static DigestAlgorithm getDigestForOID(String oid) {
        return AlgorithmService.getForOID(oid, DigestAlgorithm.class);
    }

    public static PaddingAlgorithm getPaddingForOID(String oid) {
        return AlgorithmService.getForOID(oid, PaddingAlgorithm.class);
    }

    public static List<SignatureAlgorithm> getSignatureForOID(String oid) {
        if (oid == null) {
            return Collections.emptyList();
        }
        Filter<Algorithm> typeFilter = FilterFactory.createTypeFilter(SignatureAlgorithm.class);
        Filter<Algorithm> oidFilter = FilterFactory.createOIDFilter(oid);
        return AlgorithmService.getForFilter(typeFilter, oidFilter);
    }

    private static <T extends Algorithm> T getForOID(String oid, Class<T> type) {
        Filter<Algorithm> typeFilter = FilterFactory.createTypeFilter(type);
        Filter<Algorithm> oidFilter = FilterFactory.createOIDFilter(oid);
        return (T)((Algorithm)AlgorithmService.getFirstForFilter(type, typeFilter, oidFilter));
    }

    private static <T> T getFirstForFilter(Class<T> type, Filter<Algorithm> ... filters) {
        List<Algorithm> filteredList = AlgorithmService.getForFilter(filters);
        if (filteredList.isEmpty()) {
            return null;
        }
        return type.cast(filteredList.get(0));
    }

    private static SignatureAlgorithm getFirstForFilterWithFormat(FormatAlgorithm formatAlgorithm, Filter<Algorithm> ... filters) {
        List<Algorithm> filteredList = AlgorithmService.getForFilter(filters);
        for (Algorithm algorithm : filteredList) {
            SignatureAlgorithm sa = (SignatureAlgorithm)algorithm;
            if (sa.getFormatAlgorithm() != formatAlgorithm) continue;
            return sa;
        }
        return null;
    }

    public static CipherAlgorithm getCipherForName(String name) {
        return AlgorithmService.getForName(name, CipherAlgorithm.class);
    }

    public static DigestAlgorithm getDigestForName(String name) {
        return AlgorithmService.getForName(name, DigestAlgorithm.class);
    }

    public static PaddingAlgorithm getPaddingForName(String name) {
        return AlgorithmService.getForName(name, PaddingAlgorithm.class);
    }

    public static SignatureAlgorithm getSignatureForName(String name) {
        return AlgorithmService.getForName(name, SignatureAlgorithm.class);
    }

    private static <T extends Algorithm> T getForName(String name, Class<T> type) {
        Filter<Algorithm> typeFilter = FilterFactory.createTypeFilter(type);
        Filter<Algorithm> nameFilter = FilterFactory.createNameFilter(name);
        return (T)((Algorithm)AlgorithmService.getFirstForFilter(type, typeFilter, nameFilter));
    }

    public static CipherAlgorithm getCipherForJCAName(String jcaName) {
        return AlgorithmService.getForJCAName(jcaName, CipherAlgorithm.class);
    }

    public static DigestAlgorithm getDigestForJCAName(String jcaName) {
        return AlgorithmService.getForJCAName(jcaName, DigestAlgorithm.class);
    }

    public static PaddingAlgorithm getPaddingForJCAName(String jcaName) {
        return AlgorithmService.getForJCAName(jcaName, PaddingAlgorithm.class);
    }

    public static SignatureAlgorithm getSignatureForJCAName(String jcaName) {
        return AlgorithmService.getForJCAName(jcaName, SignatureAlgorithm.class);
    }

    private static <T extends Algorithm> T getForJCAName(String jcaName, Class<T> type) {
        Filter<Algorithm> typeFilter = FilterFactory.createTypeFilter(type);
        Filter<Algorithm> jcaNameFilter = FilterFactory.createJCANameFilter(jcaName);
        return (T)((Algorithm)AlgorithmService.getFirstForFilter(type, typeFilter, jcaNameFilter));
    }

    public static CipherAlgorithm getCipherForURI(String uri) {
        return AlgorithmService.getForURI(uri, CipherAlgorithm.class);
    }

    public static DigestAlgorithm getDigestForURI(String uri) {
        return AlgorithmService.getForURI(uri, DigestAlgorithm.class);
    }

    public static PaddingAlgorithm getPaddingForURI(String uri) {
        return AlgorithmService.getForURI(uri, PaddingAlgorithm.class);
    }

    public static SignatureAlgorithm getSignatureForURI(String uri) {
        return AlgorithmService.getForURI(uri, SignatureAlgorithm.class);
    }

    private static <T extends Algorithm> T getForURI(String uri, Class<T> type) {
        Filter<Algorithm> typeFilter = FilterFactory.createTypeFilter(type);
        Filter<Algorithm> uriFilter = FilterFactory.createURIFilter(uri);
        return (T)((Algorithm)AlgorithmService.getFirstForFilter(type, typeFilter, uriFilter));
    }

    public static CipherAlgorithm getCipherForAny(String any) {
        return AlgorithmService.getForAny(any, CipherAlgorithm.class);
    }

    public static DigestAlgorithm getDigestForAny(String any) {
        return AlgorithmService.getForAny(any, DigestAlgorithm.class);
    }

    public static PaddingAlgorithm getPaddingForAny(String any) {
        return AlgorithmService.getForAny(any, PaddingAlgorithm.class);
    }

    public static List<SignatureAlgorithm> getSignatureForAny(String any) {
        Filter<Algorithm> typeFilter = FilterFactory.createTypeFilter(SignatureAlgorithm.class);
        Filter<Algorithm> anyFilter = FilterFactory.createAnyIdentifierFilter(any);
        return AlgorithmService.getForFilter(typeFilter, anyFilter);
    }

    private static <T extends Algorithm> T getForAny(String any, Class<T> type) {
        Filter<Algorithm> typeFilter = FilterFactory.createTypeFilter(type);
        Filter<Algorithm> anyFilter = FilterFactory.createAnyIdentifierFilter(any);
        return (T)((Algorithm)AlgorithmService.getFirstForFilter(type, typeFilter, anyFilter));
    }

    public static SignatureAlgorithm getSignature(SignatureAlgorithmBase base, DigestAlgorithm digest, PaddingAlgorithm padding, FormatAlgorithm format) {
        Filter<Algorithm> baseFilter = FilterFactory.createSignatureFilter(base);
        Filter<Algorithm> digestFilter = FilterFactory.createSignatureFilter(digest);
        Filter<Algorithm> paddingFilter = FilterFactory.createSignatureFilter(padding);
        return AlgorithmService.getFirstForFilterWithFormat(format, baseFilter, digestFilter, paddingFilter);
    }

    static {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            URL url = AlgorithmService.class.getClassLoader().getResource("AlgorithmIdentifier.xml");
            StreamSource source = new StreamSource(url.openStream());
            source.setSystemId(url.toString());
            AlgorithmListImpl jaxbElem = (AlgorithmListImpl)unmarshaller.unmarshal((Source)source, AlgorithmListImpl.class).getValue();
            ArrayList<Algorithm> algoList = new ArrayList<Algorithm>();
            algoList.addAll(jaxbElem.getPaddingAlgorithm());
            algoList.addAll(jaxbElem.getDigestAlgorithm());
            algoList.addAll(jaxbElem.getCipherAlgorithm());
            algoList.addAll(jaxbElem.getSignatureAlgorithm());
            for (AliasImpl alias : jaxbElem.getAlias()) {
                algoList.add(AlgorithmAliasFactory.create(alias));
            }
            algorithms = Collections.unmodifiableList(algoList);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Cannot initialize AlgorithmService", e);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Cannot initialize AlgorithmService", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot initialize AlgorithmService", e);
        }
    }
}

