/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cvs.client.rss;

import de.governikus.csl.cvs.client.rss.ResponseValidator;
import de.governikus.csl.cvs.client.rss.ResponseValidatorResult;
import de.governikus.csl.simple.xml.EnvelopedXMLSignatureValidationResult;
import de.governikus.csl.simple.xml.EnvelopedXMLSignatureValidator;
import de.governikus.csl.utils.CryptoProviderUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLSignatureResponseValidator
implements ResponseValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLSignatureResponseValidator.class);
    private CertStore certStore;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResponseValidatorResult checkSignature(byte[] signedData, Map<String, String> header) {
        EnvelopedXMLSignatureValidator envelopedXMLSignatureValidator = new EnvelopedXMLSignatureValidator(this.certStore);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(signedData);){
            EnvelopedXMLSignatureValidationResult resp = envelopedXMLSignatureValidator.validate((InputStream)bais);
            ResponseValidatorResult responseValidatorResult = new ResponseValidatorResult(resp.isSignatureValid(), resp.isWholeDocumentSigned(), resp.isCertificateMatching(), resp.getCvsSignerCn(), resp.getError());
            return responseValidatorResult;
        }
        catch (IOException e1) {
            LOGGER.error("Can't read byte stream");
            return new ResponseValidatorResult();
        }
    }

    @Override
    public void setTrustedCertificates(CertStore certStore) {
        this.certStore = certStore;
    }

    public void setTrustedCertificates(Collection<? extends Certificate> trustedCertificates) {
        try {
            this.certStore = CryptoProviderUtil.createCertStore(trustedCertificates);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException e) {
            LOGGER.error(" The trustAnchors parameter is empty ", (Throwable)e);
        }
    }
}

