/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cvs.client.rss;

import de.governikus.csl.cvp.CVPContextHolder;
import de.governikus.csl.cvs.client.model.AttributeCertificateValidationResponse;
import de.governikus.csl.cvs.client.model.CertificateValidationResponse;
import de.governikus.csl.cvs.client.model.CompoundCertificateValidationResponse;
import de.governikus.csl.cvs.client.model.ObjectFactory;
import de.governikus.csl.cvs.client.rss.RSSResponse;
import de.governikus.csl.cvs.client.rss.ResponseValidator;
import de.governikus.csl.cvs.client.rss.ResponseValidatorResult;
import de.governikus.csl.cvs.client.rss.XMLSignatureResponseValidator;
import de.governikus.csl.transport.HttpClient;
import de.governikus.csl.transport.ResponseData;
import de.governikus.utils.secutils.SecurityUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseSigningServletClient<INPUT, OUTPUT> {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseSigningServletClient.class);
    static final int MAX_ERROR_PAGE_LENGTH = 80;
    protected URI defaultURL;
    private final Class<OUTPUT> outputClass;
    private final XMLSignatureResponseValidator defaultValidator = new XMLSignatureResponseValidator();
    private final JAXBContext contextInput;
    private final JAXBContext contextOutput;
    private final JAXBContext cvpContext;
    private final ObjectFactory cvpObjectFactory;
    protected HttpClient transportFactory;
    private final boolean sendNoCacheHeader;
    private Supplier<String> bearerTokenSupplier;

    public ResponseSigningServletClient(String defaultURL, Class<?>[] inputObjectFactories, Class<OUTPUT> outputClass, Class<?>[] outputObjectFactories, HttpClient transportFactory, boolean sendNoCacheHeader) throws JAXBException, URISyntaxException {
        this.transportFactory = transportFactory;
        this.outputClass = outputClass;
        this.sendNoCacheHeader = sendNoCacheHeader;
        if (defaultURL != null) {
            this.defaultURL = new URI(defaultURL);
        }
        this.contextInput = JAXBContext.newInstance((Class[])inputObjectFactories);
        this.contextOutput = JAXBContext.newInstance((Class[])outputObjectFactories);
        this.cvpContext = CVPContextHolder.getInstance().getContext();
        this.cvpObjectFactory = CVPContextHolder.getInstance().getObjectFactory();
    }

    public ResponseSigningServletClient(String defaultURL, Class<?>[] inputObjectFactories, Class<OUTPUT> outputClass, Class<?>[] outputObjectFactories, HttpClient transportFactory, boolean sendNoCacheHeader, ClassLoader cl) throws URISyntaxException, JAXBException {
        this.transportFactory = transportFactory;
        this.outputClass = outputClass;
        this.sendNoCacheHeader = sendNoCacheHeader;
        if (defaultURL != null) {
            this.defaultURL = new URI(defaultURL);
        }
        this.contextInput = JAXBContext.newInstance((String)this.getPackageString(inputObjectFactories), (ClassLoader)cl);
        this.contextOutput = JAXBContext.newInstance((String)this.getPackageString(outputObjectFactories), (ClassLoader)cl);
        this.cvpContext = CVPContextHolder.getInstance().getContext();
        this.cvpObjectFactory = CVPContextHolder.getInstance().getObjectFactory();
    }

    private String getPackageString(Class<?>[] classes) {
        HashSet<String> packages = new HashSet<String>();
        for (Class<?> c : classes) {
            packages.add(c.getPackage().getName());
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : packages) {
            if (!first) {
                sb.append(":");
            } else {
                first = false;
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public RSSResponse<OUTPUT> getValidatedResult(INPUT input) throws IOException, JAXBException, XMLStreamException {
        return this.getValidatedResult(input, this.defaultURL, this.defaultValidator);
    }

    public RSSResponse<OUTPUT> getValidatedResult(INPUT input, URI url, ResponseValidator validator) throws IOException, JAXBException, XMLStreamException {
        LOG.trace("getValidatedResult(INPUT)");
        ResponseValidator validatorToUse = validator;
        if (validatorToUse == null) {
            validatorToUse = this.defaultValidator;
        }
        ResponseData responseData = this.sendHTTPRequest(input, url);
        this.logPlainCVSResponseData(url != null ? url : this.defaultURL, responseData);
        this.checkHttpResponse(responseData);
        Object unmarshalledObject = null;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(responseData.getResponse());){
            Unmarshaller outputUnmarshaller = this.contextOutput.createUnmarshaller();
            XMLInputFactory xif = XMLInputFactory.newInstance();
            SecurityUtils.protectFactoryAgainstXXE((XMLInputFactory)xif);
            XMLStreamReader xsr = xif.createXMLStreamReader(bais);
            unmarshalledObject = outputUnmarshaller.unmarshal(xsr);
        }
        if (unmarshalledObject instanceof JAXBElement) {
            JAXBElement elem = (JAXBElement)unmarshalledObject;
            unmarshalledObject = elem.getValue();
        }
        if (!this.outputClass.isInstance(unmarshalledObject)) {
            return null;
        }
        this.logMarshalledUnmarshalledCVSResponse(url != null ? url : this.defaultURL, unmarshalledObject);
        ResponseValidatorResult validatorResponse = validatorToUse.checkSignature(responseData.getResponse(), responseData.getResponseHeader());
        OUTPUT resp = this.outputClass.cast(unmarshalledObject);
        RSSResponse<OUTPUT> result = new RSSResponse<OUTPUT>();
        result.setResult(resp);
        result.setSignatureValid(validatorResponse.isSignatureValid());
        result.setWholeDocumentSigned(validatorResponse.isWholeDocumentSigned());
        result.setCertificateMatching(validatorResponse.isCertificateMatching());
        result.setCvsSignerCn(validatorResponse.getCvsSignerCn());
        result.setError(validatorResponse.getError());
        LOG.trace("finished getValidatedResult(INPUT)");
        return result;
    }

    private void logPlainCVSResponseData(URI url, ResponseData responseData) {
        if (!LOG.isTraceEnabled()) {
            return;
        }
        if (responseData == null) {
            LOG.error("Plain CVS response data from '{}': Failed to write CVS <NULL> response data!", (Object)url);
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            IOUtils.write((byte[])responseData.getResponse(), (OutputStream)bos);
            LOG.trace("Plain CVS response data from '{}':\n\n{}", (Object)url, (Object)bos);
        }
        catch (Exception ex) {
            LOG.error("Plain CVS response data from '{}': Failed to write CVS response data!", (Object)url, (Object)ex);
        }
    }

    private void logMarshalledUnmarshalledCVSResponse(URI url, Object responseObj) {
        if (!LOG.isTraceEnabled()) {
            return;
        }
        try {
            if (responseObj instanceof CertificateValidationResponse) {
                responseObj = this.cvpObjectFactory.createCertificateValidationResponse((CertificateValidationResponse)responseObj);
            } else if (responseObj instanceof CompoundCertificateValidationResponse) {
                responseObj = this.cvpObjectFactory.createCompoundCertificateValidationResponse((CompoundCertificateValidationResponse)responseObj);
            } else if (responseObj instanceof AttributeCertificateValidationResponse) {
                responseObj = this.cvpObjectFactory.createAttributeCertificateValidationResponse((AttributeCertificateValidationResponse)responseObj);
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Marshaller marshaller = this.cvpContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal(responseObj, (OutputStream)bos);
            LOG.trace("Marshalled CVS response data from '{}':\n\n{}", (Object)url, (Object)bos);
        }
        catch (JAXBException ex) {
            LOG.error("Marshalled CVS response data from '{}': Failed to unmarshall marshalled CVS response data!", (Object)url, (Object)ex);
        }
    }

    private void checkHttpResponse(ResponseData responseData) throws IOException {
        if (responseData.getResponseHttpCode() >= 300) {
            LOG.error("HTTP response code {}", (Object)responseData.getResponseHttpCode());
            if (responseData.getResponseHeader() != null) {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry header : responseData.getResponseHeader().entrySet()) {
                    sb.append(System.lineSeparator()).append(" - ").append((String)header.getKey()).append(": ").append((String)header.getValue());
                }
                LOG.error("HTTP response headers {}", (Object)sb);
            }
            throw new IOException("HTTP response code " + responseData.getResponseHttpCode());
        }
    }

    public RSSResponse<byte[]> getValidatedRawResult(INPUT input) throws IOException, JAXBException {
        return this.getValidatedRawResult(input, this.defaultURL, this.defaultValidator);
    }

    public RSSResponse<byte[]> getValidatedRawResult(INPUT input, URI url, ResponseValidator validator) throws IOException, JAXBException {
        ResponseValidator validatorToUse = validator;
        if (validatorToUse == null) {
            validatorToUse = this.defaultValidator;
        }
        ResponseData responseData = this.sendHTTPRequest(input, url);
        ResponseValidatorResult validatorResponse = validatorToUse.checkSignature(responseData.getResponse(), responseData.getResponseHeader());
        RSSResponse<byte[]> result = new RSSResponse<byte[]>();
        result.setResult(responseData.getResponse());
        result.setSignatureValid(validatorResponse.isSignatureValid());
        result.setWholeDocumentSigned(validatorResponse.isWholeDocumentSigned());
        result.setCertificateMatching(validatorResponse.isCertificateMatching());
        result.setCvsSignerCn(validatorResponse.getCvsSignerCn());
        result.setError(validatorResponse.getError());
        return result;
    }

    public void setTrustedCertificates(List<? extends Certificate> trustedCerts) {
        if (trustedCerts != null && !trustedCerts.isEmpty()) {
            this.defaultValidator.setTrustedCertificates(trustedCerts);
        }
    }

    public void setTrustedCertificates(CertStore certStore) {
        this.defaultValidator.setTrustedCertificates(certStore);
    }

    public URI getUrl() {
        return this.defaultURL;
    }

    private ResponseData sendHTTPRequest(INPUT input, URI serviceURL) throws IOException, JAXBException {
        URI urlToUse = serviceURL;
        if (urlToUse == null) {
            urlToUse = this.defaultURL;
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "text/xml");
        header.put("Accept", "text/xml");
        if (this.sendNoCacheHeader) {
            header.put("Cache-Control", "no-cache");
            header.put("max-age", "0");
            header.put("post-check", "0");
            header.put("precheck", "0");
            header.put("must-revalidate", "");
            header.put("Pragma", "no-cache");
        }
        if (this.bearerTokenSupplier != null) {
            String token = this.bearerTokenSupplier.get();
            if (token != null && !token.isEmpty()) {
                header.put("Authorization", token);
            } else {
                LOG.warn("BearerTokenSupplier did supply null or empty token.");
            }
        }
        Marshaller inputMarshaller = this.contextInput.createMarshaller();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        inputMarshaller.marshal(input, (OutputStream)out);
        return this.transportFactory.sendPOSTRequest(urlToUse.toString(), header, out.toByteArray());
    }

    public void setBearerTokenSupplier(Supplier<String> bearerTokenSupplier) {
        this.bearerTokenSupplier = bearerTokenSupplier;
    }

    public Supplier<String> getBearerTokenProvider() {
        return this.bearerTokenSupplier;
    }
}

