/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cvs.client.rss;

import de.governikus.csl.cvs.client.rss.ResponseValidator;
import de.governikus.csl.cvs.client.rss.ResponseValidatorResult;
import de.governikus.csl.utils.CryptoProviderUtil;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Map;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class RawSignatureResponseValidator
implements ResponseValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(RawSignatureResponseValidator.class);
    protected Collection<? extends Certificate> certificates;

    @Override
    public ResponseValidatorResult checkSignature(byte[] signedData, Map<String, String> header) {
        if (this.certificates == null) {
            LOGGER.info("This client doesn't not have any trusted certificates configured. Aborting validation of signed response with invalid result");
            return new ResponseValidatorResult();
        }
        String signatureValue = null;
        String signatureAlgorithm = null;
        if (header != null) {
            signatureValue = header.get("X-SIGNATURE");
            signatureAlgorithm = header.get("X-SIGNATURE-ALGORITHM");
        }
        if (signatureAlgorithm == null) {
            LOGGER.error("Unspecified signature algorithm. Aborting validation of signature with invalid result");
            return new ResponseValidatorResult();
        }
        if (signatureValue == null) {
            LOGGER.error("Response is not signed. Aborting validation of signature with invalid result");
            return new ResponseValidatorResult();
        }
        byte[] signature = Base64.decode((String)signatureValue);
        try {
            Signature signatureInstance = CryptoProviderUtil.getSignatureInstance((String)signatureAlgorithm);
            for (Certificate certificate : this.certificates) {
                try {
                    signatureInstance.initVerify(certificate.getPublicKey());
                    signatureInstance.update(signedData);
                    boolean verify = signatureInstance.verify(signature);
                    if (!verify) continue;
                    return new ResponseValidatorResult(true);
                }
                catch (InvalidKeyException e) {
                    LOGGER.warn("Invalid certificate: {}", (Object)certificate.toString(), (Object)e);
                }
                catch (SignatureException e) {
                    LOGGER.warn("Certificate does not match to signature: {}", (Object)certificate.toString(), (Object)e);
                }
            }
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            LOGGER.warn("Unsupported signature algorithm: {}", (Object)signatureAlgorithm, (Object)e);
            return new ResponseValidatorResult();
        }
        return new ResponseValidatorResult();
    }

    @Override
    public void setTrustedCertificates(CertStore certStore) {
        try {
            this.certificates = certStore.getCertificates(new CertSelector(){

                @Override
                public boolean match(Certificate cert) {
                    return true;
                }

                @Override
                public Object clone() {
                    return this;
                }
            });
        }
        catch (CertStoreException e1) {
            LOGGER.error("Failes to get certificates from cert store. Aborting validation of signed response with invalid result.", (Throwable)e1);
        }
    }

    public void setTrustedCertificates(Collection<? extends Certificate> trustedCertificates) {
        this.certificates = trustedCertificates;
    }
}

