/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cvs.client;

import de.bos_bremen.algorithm_identifier.AlgorithmService;
import de.governikus.csl.cvs.client.CvsClientExceptionHelper;
import de.governikus.csl.cvs.client.CvsClientRequestError;
import de.governikus.csl.cvs.client.CvsClientRequestErrorType;
import de.governikus.csl.cvs.client.DynamicCVSClient;
import de.governikus.csl.cvs.client.model.AttributeCertificateValidationRequest;
import de.governikus.csl.cvs.client.model.AttributeCertificateValidationResponse;
import de.governikus.csl.cvs.client.model.CertificateValidationRequest;
import de.governikus.csl.cvs.client.model.CertificateValidationRequestBase;
import de.governikus.csl.cvs.client.model.CertificateValidationResponse;
import de.governikus.csl.cvs.client.model.CertificateValidationResponseBase;
import de.governikus.csl.cvs.client.model.CompoundCertificateValidationRequest;
import de.governikus.csl.cvs.client.model.CompoundCertificateValidationResponse;
import de.governikus.csl.cvs.client.model.ObjectFactory;
import de.governikus.csl.cvs.client.model.ResponseEntry;
import de.governikus.csl.cvs.client.rss.RSSResponse;
import de.governikus.csl.cvs.client.rss.ResponseSigningServletClient;
import de.governikus.csl.cvs.client.rss.ResponseValidator;
import de.governikus.csl.cvs.client.rss.XMLSignatureResponseValidator;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.transport.HttpClient;
import de.governikus.csl.uom.LogHelper;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.Certificate;
import java.util.Collection;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRelayClient
extends ResponseSigningServletClient<JAXBElement<? extends CertificateValidationRequestBase>, CertificateValidationResponseBase>
implements DynamicCVSClient {
    public static final String PROPKEY_ALLOW_UNSIGNED_RESPONSE = "csl.cvs.client.response.unsigned.allow";
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRelayClient.class);
    private static final String NO_RESULT = "Didn't receive a response from CVS, returning null";
    private CvsClientRequestError requestError;
    private ObjectFactory of = new ObjectFactory();

    public HttpRelayClient(String defaultURL, HttpClient transportFactory, boolean sendNoCacheHeader) throws JAXBException, URISyntaxException {
        super(defaultURL, new Class[]{ObjectFactory.class, de.governikus.csl.validate.svp.ObjectFactory.class, de.governikus.csl.validation.policy.ObjectFactory.class, org.w3._2000._09.xmldsig.ObjectFactory.class}, CertificateValidationResponseBase.class, new Class[]{ObjectFactory.class, de.governikus.csl.validate.svp.ObjectFactory.class, de.governikus.csl.validation.policy.ObjectFactory.class, org.w3._2000._09.xmldsig.ObjectFactory.class}, transportFactory, sendNoCacheHeader);
    }

    public HttpRelayClient(String defaultURL, HttpClient transportFactory, boolean sendNoCacheHeader, ClassLoader cl) throws JAXBException, URISyntaxException {
        super(defaultURL, new Class[]{ObjectFactory.class, de.governikus.csl.validate.svp.ObjectFactory.class, de.governikus.csl.validation.policy.ObjectFactory.class, org.w3._2000._09.xmldsig.ObjectFactory.class}, CertificateValidationResponseBase.class, new Class[]{ObjectFactory.class, de.governikus.csl.validate.svp.ObjectFactory.class, de.governikus.csl.validation.policy.ObjectFactory.class, org.w3._2000._09.xmldsig.ObjectFactory.class}, transportFactory, sendNoCacheHeader, cl);
    }

    protected <T> T submitRequest(JAXBElement<? extends CertificateValidationRequestBase> request, Class<T> responseType, String cvsURL, Collection<? extends Certificate> trustedCertificates) {
        XMLSignatureResponseValidator validator = null;
        URI uri = null;
        this.requestError = null;
        if (trustedCertificates != null) {
            XMLSignatureResponseValidator v = new XMLSignatureResponseValidator();
            v.setTrustedCertificates(trustedCertificates);
            validator = v;
        }
        try {
            RSSResponse<CertificateValidationResponseBase> validatedResult;
            if (cvsURL != null) {
                uri = new URI(cvsURL);
            }
            if ((validatedResult = this.getValidatedResult(request, uri, (ResponseValidator)validator)) == null) {
                LOGGER.error(NO_RESULT);
                this.requestError = new CvsClientRequestError(CvsClientRequestErrorType.MISSING_RESULT, NO_RESULT);
                return null;
            }
            return responseType.cast(validatedResult.getResult());
        }
        catch (IOException | URISyntaxException | JAXBException | XMLStreamException e) {
            this.requestError = CvsClientExceptionHelper.createError((Exception)e);
            LogHelper.logWarningOrPrintDebugException((String)("Returning null, can't process request because of " + this.requestError.getMessage()), (Logger)LOGGER, (Throwable)e);
            return null;
        }
    }

    @Override
    public CertificateValidationResponse validate(CertificateValidationRequest request) {
        CertificateValidationResponse submitRequest = this.submitRequest((JAXBElement<? extends CertificateValidationRequestBase>)this.of.createCertificateValidationRequest(request), CertificateValidationResponse.class, null, null);
        if (submitRequest != null) {
            if (submitRequest.getServiceBuildInformation() != null) {
                submitRequest.getCertificateValidationResult().setCvsVersion(submitRequest.getServiceBuildInformation().getServiceVersion());
            }
            submitRequest.getCertificateValidationResult().setCvsURL(this.defaultURL.toString());
        }
        return submitRequest;
    }

    @Override
    public AttributeCertificateValidationResponse validateAttributeCertificate(AttributeCertificateValidationRequest request) {
        AttributeCertificateValidationResponse submitRequest = this.submitRequest((JAXBElement<? extends CertificateValidationRequestBase>)this.of.createAttributeCertificateValidationRequest(request), AttributeCertificateValidationResponse.class, null, null);
        if (submitRequest != null) {
            if (submitRequest.getServiceBuildInformation() != null) {
                submitRequest.getAttributeCertificateValidationResult().setCvsVersion(submitRequest.getServiceBuildInformation().getServiceVersion());
            }
            submitRequest.getAttributeCertificateValidationResult().setCvsURL(this.defaultURL.toString());
        }
        return submitRequest;
    }

    @Override
    public CompoundCertificateValidationResponse validateCompound(CompoundCertificateValidationRequest request) {
        CompoundCertificateValidationResponse submitRequest = this.submitRequest((JAXBElement<? extends CertificateValidationRequestBase>)this.of.createCompoundCertificateValidationRequest(request), CompoundCertificateValidationResponse.class, null, null);
        if (submitRequest != null && submitRequest.getValidationResults() != null) {
            for (ResponseEntry entry : submitRequest.getValidationResults()) {
                if (submitRequest.getServiceBuildInformation() != null) {
                    entry.getCertificateValidationResult().setCvsVersion(submitRequest.getServiceBuildInformation().getServiceVersion());
                }
                entry.getCertificateValidationResult().setCvsURL(this.defaultURL.toString());
            }
        }
        return submitRequest;
    }

    @Override
    public RSSResponse<CertificateValidationResponseBase> getValidatedResult(JAXBElement<? extends CertificateValidationRequestBase> input, URI url, ResponseValidator validator) throws IOException, JAXBException, XMLStreamException {
        RSSResponse<CertificateValidationResponseBase> rssResponse = super.getValidatedResult(input, url, validator);
        this.checkClientResponseForErrors(rssResponse);
        return rssResponse;
    }

    void checkClientResponseForErrors(RSSResponse<CertificateValidationResponseBase> rssResponse) {
        if (rssResponse != null) {
            boolean validResult = rssResponse.isSignatureValid();
            boolean wholeDocumentSigned = rssResponse.isWholeDocumentSigned();
            boolean certsMatch = rssResponse.isCertificateMatching();
            String cvsSignerCn = rssResponse.getCvsSignerCn();
            Throwable error = rssResponse.getError();
            CertificateValidationResponseBase cvsResponse = rssResponse.getResult();
            if (cvsResponse != null) {
                if (error != null) {
                    String exceptionDesc;
                    switch (exceptionDesc = error.getMessage()) {
                        case "The cvs response cannot be parsed.": {
                            this.setSigResult(cvsResponse, "cvs_signature_error_parse");
                            break;
                        }
                        case "The cvs response is not signed.": {
                            this.setSigResult(cvsResponse, "cvs_signature_missing");
                            break;
                        }
                        case "Found multiple signatures in cvs response.": {
                            this.setSigResult(cvsResponse, "cvs_signature_multiple_signatures");
                            break;
                        }
                        case "Empty store of trusted certificates configured.": {
                            this.setSigResultWithArg(cvsResponse, "cvs_signature_missing_truststore", cvsSignerCn);
                            break;
                        }
                        case "Did not find a KeyInfo.": {
                            this.setSigResult(cvsResponse, "cvs_signature_missing_keyinfo");
                            break;
                        }
                        case "Did not find a SignerCertificate.": {
                            this.setSigResult(cvsResponse, "cvs_signature_missing_cert");
                            break;
                        }
                        default: {
                            this.setSigResultWithArg(cvsResponse, "cvs_signature_error_general", exceptionDesc);
                            break;
                        }
                    }
                } else if (!certsMatch) {
                    this.setSigResultWithArg(cvsResponse, "cvs_signature_cert_mismatch", cvsSignerCn);
                } else if (!validResult) {
                    this.setSigResult(cvsResponse, "cvs_signature_broken");
                } else if (!wholeDocumentSigned) {
                    this.setSigResult(cvsResponse, "cvs_signature_not_whole_signed");
                } else {
                    cvsResponse.setCvsSignatureValidationResult(SVPFactory.createResultOk());
                }
            }
        }
    }

    private void setSigResult(CertificateValidationResponseBase cvsResponse, String msgCode) {
        cvsResponse.setCvsSignatureValidationResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.GENERIC, (String[])new String[]{msgCode}));
    }

    private void setSigResultWithArg(CertificateValidationResponseBase cvsResponse, String msgCode, String msgArg) {
        cvsResponse.setCvsSignatureValidationResult(SVPFactory.createWithArg((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.GENERIC, (String)msgCode, (Object[])new Object[]{msgArg}));
    }

    @Override
    public CertificateValidationResponse validate(CertificateValidationRequest request, String cvsURL, Collection<? extends Certificate> trustedCertificates) {
        CertificateValidationResponse submitRequest = this.submitRequest((JAXBElement<? extends CertificateValidationRequestBase>)this.of.createCertificateValidationRequest(request), CertificateValidationResponse.class, cvsURL, trustedCertificates);
        if (submitRequest != null) {
            if (submitRequest.getServiceBuildInformation() != null) {
                submitRequest.getCertificateValidationResult().setCvsVersion(submitRequest.getServiceBuildInformation().getServiceVersion());
            }
            submitRequest.getCertificateValidationResult().setCvsURL(cvsURL != null ? cvsURL : this.defaultURL.toString());
        }
        return submitRequest;
    }

    @Override
    public AttributeCertificateValidationResponse validateAttributeCertificate(AttributeCertificateValidationRequest request, String cvsURL, Collection<? extends Certificate> trustedCertificates) {
        AttributeCertificateValidationResponse submitRequest = this.submitRequest((JAXBElement<? extends CertificateValidationRequestBase>)this.of.createAttributeCertificateValidationRequest(request), AttributeCertificateValidationResponse.class, cvsURL, trustedCertificates);
        if (submitRequest != null) {
            if (submitRequest.getServiceBuildInformation() != null) {
                submitRequest.getAttributeCertificateValidationResult().getSigningCertificateValidationResult().setCvsVersion(submitRequest.getServiceBuildInformation().getServiceVersion());
            }
            submitRequest.getAttributeCertificateValidationResult().getSigningCertificateValidationResult().setCvsURL(cvsURL != null ? cvsURL : this.defaultURL.toString());
        }
        return submitRequest;
    }

    @Override
    public CompoundCertificateValidationResponse validateCompound(CompoundCertificateValidationRequest request, String cvsURL, Collection<? extends Certificate> trustedCertificates) {
        CompoundCertificateValidationResponse submitRequest = this.submitRequest((JAXBElement<? extends CertificateValidationRequestBase>)this.of.createCompoundCertificateValidationRequest(request), CompoundCertificateValidationResponse.class, cvsURL, trustedCertificates);
        if (submitRequest != null && submitRequest.getValidationResults() != null) {
            for (ResponseEntry entry : submitRequest.getValidationResults()) {
                if (submitRequest.getServiceBuildInformation() != null) {
                    entry.getCertificateValidationResult().setCvsVersion(submitRequest.getServiceBuildInformation().getServiceVersion());
                }
                entry.getCertificateValidationResult().setCvsURL(cvsURL != null ? cvsURL : this.defaultURL.toString());
            }
        }
        return submitRequest;
    }

    @Override
    public CvsClientRequestError getError() {
        return this.requestError;
    }

    static {
        new AlgorithmService();
    }
}

