/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cvs.client;

import de.governikus.csl.cvs.client.CvsClientRequestError;
import de.governikus.csl.cvs.client.CvsClientRequestErrorType;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.net.ssl.SSLException;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.exception.ExceptionUtils;

public final class CvsClientExceptionHelper {
    private CvsClientExceptionHelper() {
    }

    public static CvsClientRequestError createError(Exception e) {
        CvsClientRequestError requestError = new CvsClientRequestError(e);
        if (e instanceof SSLException) {
            requestError.setType(CvsClientRequestErrorType.SSL);
            CvsClientExceptionHelper.findMessage(requestError, e);
        } else {
            for (Throwable t : ExceptionUtils.getThrowableList((Throwable)e)) {
                if (!(t instanceof SSLException)) continue;
                requestError.setType(CvsClientRequestErrorType.SSL);
                CvsClientExceptionHelper.findMessage(requestError, t);
                return requestError;
            }
            if (e instanceof IOException) {
                requestError.setType(CvsClientRequestErrorType.IO);
                CvsClientExceptionHelper.findMessage(requestError, e);
            } else if (e instanceof URISyntaxException) {
                requestError.setType(CvsClientRequestErrorType.URI);
                CvsClientExceptionHelper.findMessage(requestError, e);
            } else if (e instanceof JAXBException) {
                requestError.setType(CvsClientRequestErrorType.JAXB);
                CvsClientExceptionHelper.findMessage(requestError, e);
            } else if (e instanceof XMLStreamException) {
                requestError.setType(CvsClientRequestErrorType.XML);
                CvsClientExceptionHelper.findMessage(requestError, e);
            }
        }
        return requestError;
    }

    static void findMessage(CvsClientRequestError requestError, Throwable t) {
        String message = t.getLocalizedMessage();
        if (message != null) {
            requestError.setMessage(message);
        } else {
            for (Throwable cause : ExceptionUtils.getThrowableList((Throwable)t)) {
                message = cause.getMessage();
                if (message == null) continue;
                requestError.setMessage(message);
                break;
            }
        }
    }
}

