/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cvs.client;

import de.governikus.csl.cvs.client.model.CertificateValidationRequestBase;
import de.governikus.csl.cvs.client.model.ValidationDataWithPOE;
import de.governikus.csl.uom.validate.commons.SignatureValidationDataAttachment;
import java.io.IOException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateValidationRequestBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateValidationRequestBuilder.class);

    public static void extendRequestWithAttachedValidationData(CertificateValidationRequestBase request, Collection<SignatureValidationDataAttachment<X509Certificate>> attachedCertificates, Collection<SignatureValidationDataAttachment<CRL>> attachedCRLs, Collection<SignatureValidationDataAttachment<OCSPResp>> attachedOCSPValues) {
        List poes2;
        List poEs;
        ValidationDataWithPOE valData;
        List bv;
        if (attachedCertificates != null) {
            bv = request.getAttachedCertificates();
            for (SignatureValidationDataAttachment signatureValidationDataAttachment : attachedCertificates) {
                valData = new ValidationDataWithPOE();
                poEs = signatureValidationDataAttachment.getPOEs();
                if (poEs != null) {
                    poes2 = valData.getPoes();
                    poEs.forEach(x -> poes2.add(x));
                }
                try {
                    X509Certificate value = (X509Certificate)signatureValidationDataAttachment.getValue();
                    if (value == null) continue;
                    valData.setValue(value.getEncoded());
                    bv.add(valData);
                }
                catch (CertificateEncodingException e) {
                    LOGGER.warn("Can't process attached certificate.");
                }
            }
        }
        if (attachedCRLs != null) {
            bv = request.getAttachedCRLs();
            for (SignatureValidationDataAttachment signatureValidationDataAttachment : attachedCRLs) {
                valData = new ValidationDataWithPOE();
                poEs = signatureValidationDataAttachment.getPOEs();
                if (poEs != null) {
                    poes2 = valData.getPoes();
                    poEs.forEach(x -> poes2.add(x));
                }
                try {
                    valData.setValue(((X509CRL)signatureValidationDataAttachment.getValue()).getEncoded());
                    bv.add(valData);
                }
                catch (CRLException e) {
                    LOGGER.warn("Can't process attached CRL.");
                }
            }
        }
        if (attachedOCSPValues != null) {
            bv = request.getAttachedOCSPValues();
            for (SignatureValidationDataAttachment signatureValidationDataAttachment : attachedOCSPValues) {
                valData = new ValidationDataWithPOE();
                poEs = signatureValidationDataAttachment.getPOEs();
                if (poEs != null) {
                    poes2 = valData.getPoes();
                    poEs.forEach(x -> poes2.add(x));
                }
                try {
                    valData.setValue(((OCSPResp)signatureValidationDataAttachment.getValue()).getEncoded());
                    bv.add(valData);
                }
                catch (IOException e) {
                    LOGGER.warn("Can't process attached OSCP.");
                }
            }
        }
    }
}

