/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.remote.sign.util;

import de.governikus.csl.uom.jcebase.DefaultDigestAlgorithmURIFinder;
import java.util.Arrays;
import java.util.List;

public class AlgorithmUtil {
    private static final List<String> defaultFilter = Arrays.asList("http://www.w3.org/2007/05/xmldsig-more#sha256-rsa-MGF1", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256");

    private AlgorithmUtil() {
    }

    public static String getRecommendSignatureAlgorithm(List<String> supportedSigAlgoList) {
        return AlgorithmUtil.getRecommendSignatureAlgorithm(supportedSigAlgoList, defaultFilter);
    }

    public static String getRecommendSignatureAlgorithm(List<String> supportedSigAlgoList, List<String> algoFilter) {
        String recommendSignatureAlgorithm = null;
        if (algoFilter == null || algoFilter.isEmpty() || supportedSigAlgoList == null || supportedSigAlgoList.isEmpty()) {
            return recommendSignatureAlgorithm;
        }
        for (String filter : algoFilter) {
            for (String sigAlgo : supportedSigAlgoList) {
                if (!sigAlgo.contains(filter)) continue;
                recommendSignatureAlgorithm = sigAlgo;
                break;
            }
            if (recommendSignatureAlgorithm == null || !recommendSignatureAlgorithm.equals(filter)) continue;
            break;
        }
        return recommendSignatureAlgorithm;
    }

    public static String getRecommendDigestAlgorithm(String signatureAlgorithmUri) {
        return DefaultDigestAlgorithmURIFinder.getFinder().getDigestAlgorithmURI(signatureAlgorithmUri);
    }
}

