/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.remote.sign.exception;

import de.governikus.csl.transport.exception.ConnectionException;
import de.governikus.csl.transport.exception.ResponseException;
import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.jce.remote.CSLJCERemoteSignatureException;
import java.net.UnknownHostException;

public class RemoteSigningException
extends CSLJCERemoteSignatureException {
    private static final long serialVersionUID = -4938475063607194555L;
    private final RemoteSigningFailure failure;

    public RemoteSigningException(RemoteSigningFailure failure, String message) {
        super(message);
        this.failure = failure;
    }

    public RemoteSigningException(RemoteSigningFailure failure) {
        this.failure = failure;
    }

    public RemoteSigningException(RemoteSigningFailure failure, Throwable t) {
        super(t);
        this.failure = failure;
    }

    public RemoteSigningFailure getFailure() {
        return this.failure;
    }

    public String getMessage() {
        return this.failure.name() + " " + super.getMessage();
    }

    public static RemoteSigningException createRemoteSigningException(Exception e) {
        if (CoreException.findException(UnknownHostException.class, (Throwable)e) != null || CoreException.findException(ConnectionException.class, (Throwable)e) != null) {
            return new RemoteSigningException(RemoteSigningFailure.SIGNSERVICE_NOT_REACHABLE, e);
        }
        ResponseException re = (ResponseException)CoreException.findException(ResponseException.class, (Throwable)e);
        if (re instanceof ResponseException) {
            if (re.getMessage().contains("status: 401")) {
                return new RemoteSigningException(RemoteSigningFailure.SIGNSERVICE_UNAUTHORIZED_401, e);
            }
            if (re.getMessage().contains("status: 403")) {
                return new RemoteSigningException(RemoteSigningFailure.SIGNSERVICE_FORBIDDEN_REMOTE_RESOURCE_403, e);
            }
            if (re.getMessage().contains("status: 404")) {
                return new RemoteSigningException(RemoteSigningFailure.SIGNSERVICE_RESOURCES_NOT_FOUND_404, e);
            }
            if (re.getMessage().contains("status: 500")) {
                return new RemoteSigningException(RemoteSigningFailure.INTERNAL_SERVER_ERROR_500, e);
            }
        }
        return new RemoteSigningException(RemoteSigningFailure.GENERAL_EXCEPTION, e);
    }

    public static enum RemoteSigningFailure {
        AUTHSERVER_NOT_REACHABLE,
        AUTHSERVER_RESOURCES_NOT_FOUND_404,
        AUTHSERVER_RESOURCES_NOT_ALLOWED_405,
        AUTHENTICATION_FAILED_401,
        GENERAL_AUTHENTICATION_EXCEPTION,
        GENERAL_EXCEPTION,
        INTERNAL_SERVER_ERROR_500,
        SIGNSERVICE_NOT_REACHABLE,
        KEY_RESOURCEREFS_NOT_FOUND,
        SIGNSERVICE_UNAUTHORIZED_401,
        SIGNSERVICE_RESOURCES_NOT_FOUND_404,
        SIGNSERVICE_FORBIDDEN_REMOTE_RESOURCE_403;

    }
}

