/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.remote.sign;

import de.governikus.csc.config.xml.sign.SignOptionsType;
import de.governikus.csc.config.xml.sign.SignParametersType;
import de.governikus.csc.signservice.client.SignServiceClient;
import de.governikus.csc.signservice.model.SignRequest;
import de.governikus.csc.signservice.model.SignResponse;
import de.governikus.csc.signservice.model.SignatureFormat;
import de.governikus.csl.raw.sign.RAWSignPlugin;
import de.governikus.csl.remote.sign.exception.RemoteSigningException;
import de.governikus.csl.uom.jce.remote.CSLJCERemoteSignatureException;
import de.governikus.csl.uom.jce.remote.RemoteSignaturePrivateKey;
import de.governikus.csl.uom.res.PrivateKeyResourceReference;
import de.governikus.csl.uom.sign.SignatureType;
import de.governikus.csl.uom.util.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientRemoteSignaturePrivateKey
implements RemoteSignaturePrivateKey {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ClientRemoteSignaturePrivateKey.class);
    private SignServiceClient signServiceClient;
    private PrivateKeyResourceReference keyRef;

    ClientRemoteSignaturePrivateKey(PrivateKeyResourceReference keyRef, SignServiceClient signServiceClient) {
        this.keyRef = keyRef;
        this.signServiceClient = signServiceClient;
    }

    public byte[] sign(String signatureAlgorithmURI, String digestAlgorithmURI, byte[] digestValue, Environment environment) throws CSLJCERemoteSignatureException {
        if (signatureAlgorithmURI == null || signatureAlgorithmURI.trim().isEmpty()) {
            LOG.error("Missing signature algorithm, the signature algorithm must not be null or empty");
            throw new CSLJCERemoteSignatureException("Missing signature algorithm, the signature algorithm must not be null or empty");
        }
        if (digestAlgorithmURI == null || digestAlgorithmURI.trim().isEmpty()) {
            LOG.error("Missing digest algorithm, the digest algorithm must not be null or empty");
            throw new CSLJCERemoteSignatureException("Missing digest algorithm, the digest algorithm must not be null or empty");
        }
        if (this.signServiceClient == null) {
            LOG.error("Missing signServiceClient, the signServiceClient must not be null");
            throw new CSLJCERemoteSignatureException("Missing signServiceClient, the signServiceClient must not be null");
        }
        SignRequest request = ClientRemoteSignaturePrivateKey.createRawRequest(digestValue, SignatureType.DETACHED, SignatureFormat.RAW, signatureAlgorithmURI, digestAlgorithmURI, RAWSignPlugin.POLICY.getId());
        try {
            SignResponse signResponse = (SignResponse)this.signServiceClient.handleComplex((Object)request, "keyid/" + this.keyRef.getId());
            return signResponse.getSignedData();
        }
        catch (Exception cause) {
            LOG.error("Fehler beim Request mit keyid: {}", (Object)this.keyRef.getId(), (Object)cause);
            return this.requestWithKeyRefName(request);
        }
    }

    private byte[] requestWithKeyRefName(SignRequest request) throws RemoteSigningException {
        try {
            SignResponse signResponse = (SignResponse)this.signServiceClient.handleComplex((Object)request, "keyid/" + this.keyRef.getName());
            return signResponse.getSignedData();
        }
        catch (Exception cause) {
            throw RemoteSigningException.createRemoteSigningException(cause);
        }
    }

    private static SignRequest createRawRequest(byte[] dataToBeSigned, SignatureType type, SignatureFormat format, String signatureAlgorithm, String digestAlgorithm, String policy) {
        SignRequest request = new SignRequest();
        request.getDataToBeSigned().add(dataToBeSigned);
        SignOptionsType options = new SignOptionsType();
        options.setPolicy(policy);
        SignParametersType params = new SignParametersType();
        params.setSignatureType(type.name());
        params.setOutputFormat(format.value());
        params.setDigestAlgorithmURI(digestAlgorithm);
        params.setSignatureAlgorithmURI(signatureAlgorithm);
        options.setSignParameters(params);
        request.setSignOptions(options);
        return request;
    }

    public String getAlgorithm() {
        return this.keyRef.getAlgorithm();
    }

    public String getFormat() {
        return this.keyRef.getFormat();
    }

    public byte[] getEncoded() {
        throw new UnsupportedOperationException("methode not implemented");
    }

    public PrivateKeyResourceReference getPrivateKeyResourceReference() {
        return this.keyRef;
    }
}

