/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.remote.sign;

import de.governikus.csc.authentication.keycloak.client.KeycloakAuthClient;
import de.governikus.csc.signservice.client.AuthenticatedSignServiceClient;
import de.governikus.csc.signservice.client.SignServiceClient;
import de.governikus.csl.remote.sign.AbstractRemoteSignature;
import de.governikus.csl.transport.HttpClient;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientRemoteSignature
extends AbstractRemoteSignature {
    private static final Logger LOG = LoggerFactory.getLogger(ClientRemoteSignature.class);
    private HttpClient httpClientSignService;
    private String signServiceUrl;

    public ClientRemoteSignature(HttpClient httpClientSignService, String signServiceUrl, KeycloakAuthClient keycloakAuthClient) {
        this.httpClientSignService = httpClientSignService;
        this.signServiceUrl = signServiceUrl;
        this.authenticationBasedInit(keycloakAuthClient);
    }

    public ClientRemoteSignature(HttpClient httpClientSignService, String signServiceUrl, String token) {
        this.httpClientSignService = httpClientSignService;
        this.signServiceUrl = signServiceUrl;
        this.checkParams();
        this.tokenBasedInit(token);
    }

    private void checkParams() {
        if (this.signServiceUrl == null || this.signServiceUrl.trim().isEmpty()) {
            LOG.error("Missing sign service url, the sign service must not be null or empty");
            throw new IllegalArgumentException("Missing sign service url, the sign service must not be null or empty");
        }
        if (this.httpClientSignService == null) {
            LOG.error("The http client SignService connection must not be null or empty");
            throw new IllegalArgumentException("The http client SignService connection must not be null or empty");
        }
    }

    private void tokenBasedInit(String token) {
        if (token == null || token.trim().isEmpty()) {
            LOG.error("Missing authorization, the authorization token must not be null or empty");
            throw new IllegalArgumentException("Missing authorization, the authorization token must not be null or empty");
        }
        try {
            this.signServiceClient = new SignServiceClient(new URI(this.signServiceUrl), this.httpClientSignService);
            this.signServiceClient.setAuthToken(token);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void authenticationBasedInit(KeycloakAuthClient keycloakAuthClient) {
        if (keycloakAuthClient == null) {
            LOG.error("Missing KeycloakAuthClient, the KeycloakAuthClient must not be null");
            throw new IllegalArgumentException("Missing KeycloakAuthClient, the KeycloakAuthClient must not be null");
        }
        try {
            this.signServiceClient = new AuthenticatedSignServiceClient(new URI(this.signServiceUrl), this.httpClientSignService, keycloakAuthClient);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

